/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.model;

import java.util.ArrayList;
import java.util.List;

public class DigestModel {
    public int objHash;
    public int digestHash;
    public String name;
    public String database;
    public int execution;
    public int errorCnt;
    public int warnCnt;
    public long sumResponseTime;
    public double avgResponseTime;
    public long minResponseTime = Long.MAX_VALUE;
    public long maxResponseTime = Long.MIN_VALUE;
    public long lockTime;
    public long rowsAffected;
    public long rowsSent;
    public long rowsExamined;
    public long createdTmpDiskTables;
    public long createdTmpTables;
    public long selectFullJoin;
    public long selectFullRangeJoin;
    public long selectRange;
    public long selectRangeCheck;
    public long selectScan;
    public long sortMergePasses;
    public long sortRange;
    public long sortRows;
    public long sortScan;
    public long noIndexUsed;
    public long noGoodIndexUsed;
    public long firstSeen = Long.MAX_VALUE;
    public long lastSeen = Long.MIN_VALUE;
    public DigestModel parent;
    private List<DigestModel> childList;

    public synchronized void addChild(DigestModel child) {
        if (this.database == null) {
            this.database = child.database;
        }
        this.execution += child.execution;
        this.errorCnt += child.errorCnt;
        this.warnCnt += child.warnCnt;
        this.sumResponseTime += child.sumResponseTime;
        if (this.maxResponseTime < child.maxResponseTime) {
            this.maxResponseTime = child.maxResponseTime;
        }
        if (this.minResponseTime > child.minResponseTime) {
            this.minResponseTime = child.minResponseTime;
        }
        this.lockTime += child.lockTime;
        this.rowsAffected += child.rowsAffected;
        this.rowsSent += child.rowsSent;
        this.rowsExamined += child.rowsExamined;
        this.createdTmpDiskTables += child.createdTmpDiskTables;
        this.createdTmpTables += child.createdTmpTables;
        this.selectFullJoin += child.selectFullJoin;
        this.selectFullRangeJoin += child.selectFullRangeJoin;
        this.selectRange += child.selectRange;
        this.selectRangeCheck += child.selectRangeCheck;
        this.selectScan += child.selectScan;
        this.sortMergePasses += child.sortMergePasses;
        this.sortRange += child.sortRange;
        this.sortRows += child.sortRows;
        this.sortScan += child.sortScan;
        this.noIndexUsed += child.noIndexUsed;
        this.noGoodIndexUsed += child.noGoodIndexUsed;
        if (this.firstSeen > child.firstSeen) {
            this.firstSeen = child.firstSeen;
        }
        if (this.lastSeen < child.lastSeen) {
            this.lastSeen = child.lastSeen;
        }
        if (this.childList == null) {
            this.childList = new ArrayList<DigestModel>();
        }
        this.childList.add(child);
    }

    public DigestModel[] getChildArray() {
        if (this.childList == null) {
            return null;
        }
        DigestModel[] array = new DigestModel[this.childList.size()];
        int i = 0;
        while (i < this.childList.size()) {
            array[i] = this.childList.get(i);
            ++i;
        }
        return array;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.database == null ? 0 : this.database.hashCode());
        result = 31 * result + this.digestHash;
        result = 31 * result + this.objHash;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DigestModel other = (DigestModel)obj;
        if (this.database == null ? other.database != null : !this.database.equals(other.database)) {
            return false;
        }
        if (this.digestHash != other.digestHash) {
            return false;
        }
        return this.objHash == other.objHash;
    }
}

