/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import scouter.client.model.DummyObject;
import scouter.client.sorter.ObjectTreeSorter;

public abstract class HierarchyObject {
    protected Map<String, HierarchyObject> childMap = new HashMap<String, HierarchyObject>();
    private TreeMap<String, HierarchyObject> sortedMap = new TreeMap(new ObjectTreeSorter(this.childMap));
    private HierarchyObject parent;

    public HierarchyObject getChild(String key) {
        return this.childMap.get(key);
    }

    public HierarchyObject putChild(String key, HierarchyObject child) {
        this.childMap.put(key, child);
        return this.sortedMap.put(key, child);
    }

    public void setParent(HierarchyObject obj) {
        this.parent = obj;
    }

    public HierarchyObject getParent() {
        return this.parent;
    }

    public int getChildSize() {
        return this.childMap.size();
    }

    public Set<String> keySet() {
        return this.sortedMap.keySet();
    }

    public Object[] getSortedChildArray() {
        return this.sortedMap.values().toArray();
    }

    public abstract String getName();

    public abstract String getDisplayName();

    public String toString() {
        return this.getName();
    }

    public static void main(String[] args) {
        HashMap<String, HierarchyObject> childMap = new HashMap<String, HierarchyObject>();
        TreeMap<String, DummyObject> sortedSet = new TreeMap<String, DummyObject>(new ObjectTreeSorter(childMap));
        DummyObject obj1 = new DummyObject("kim");
        DummyObject obj2 = new DummyObject("lee");
        System.out.println(childMap.put("abc", obj1));
        System.out.println(childMap.put("abc", obj2));
        System.out.println(sortedSet.put("abc", obj1));
        System.out.println(sortedSet.put("abc", obj2));
        System.out.println(childMap.size());
        System.out.println(sortedSet.size());
    }
}

