/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import scouter.client.net.TcpProxy;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.Hexa32;
import scouter.util.LinkedMap;
import scouter.util.StringUtil;

public class TextModel {
    private final String cmd = "GET_TEXT_100";
    private final String type;
    private int limit;
    private LinkedMap<Integer, String> entries = new LinkedMap();

    public TextModel(String textType, int limit) {
        this.type = textType;
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        this.limit = limit;
    }

    public void setLimit(int limit) {
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void putText(int id, String name) {
        this.entries.put((Object)id, (Object)name);
    }

    public String getText(int id) {
        return (String)this.entries.get((Object)id);
    }

    public boolean load(String date, Collection<Integer> hashs, int serverId) {
        List<Pack> packList;
        block11: {
            if (hashs == null || hashs.size() == 0) {
                return false;
            }
            MapPack param = new MapPack();
            param.put("date", date);
            param.put("type", this.type);
            ListValue hashLv = param.newList("hash");
            for (int key : hashs) {
                if (this.entries.containsKey((Object)key)) continue;
                hashLv.add((long)key);
            }
            if (hashLv.size() == 0) {
                return false;
            }
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            packList = null;
            try {
                try {
                    packList = tcp.process("GET_TEXT_100", (Pack)param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (packList == null) {
            return false;
        }
        for (Pack pack : packList) {
            MapPack re = (MapPack)pack;
            Iterator en = re.keys();
            while (en.hasNext()) {
                String key = (String)en.next();
                String value = re.getText(key);
                if (!StringUtil.isNotEmpty((String)value)) continue;
                this.entries.put((Object)((int)Hexa32.toLong32((String)key)), (Object)value);
                if (this.entries.size() <= this.limit) continue;
                this.entries.removeFirst();
            }
        }
        return true;
    }

    public String getLoadText(String date, int hash, int serverId) {
        if (hash == 0) {
            return null;
        }
        String value = this.getText(hash);
        if (value != null) {
            return value;
        }
        ArrayList<Integer> a = new ArrayList<Integer>();
        a.add(hash);
        this.load(date, a, serverId);
        return this.getText(hash);
    }

    public void load(String date, ListValue hashList, int serverId) {
        ArrayList<Integer> arrList = new ArrayList<Integer>();
        int i = 0;
        while (i < hashList.size()) {
            int hash = (int)hashList.getLong(i);
            if (hash != 0) {
                arrList.add(hash);
            }
            ++i;
        }
        this.load(date, arrList, serverId);
    }
}

