/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.model;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.xlog.XLogUtil;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.lang.pack.XLogProfilePack;
import scouter.lang.step.Step;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.Value;
import scouter.util.FileUtil;

public class XLogProxy {
    public static Step[] getProfile(String date, long txid, int serverId) {
        MapPack param = new MapPack();
        if (date != null) {
            param.put("date", date);
        }
        param.put("txid", (Value)new DecimalValue(txid));
        int max = PManager.getInstance().getInt("massProfileBlock");
        param.put("max", (Value)new DecimalValue((long)max));
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            Pack re = tcp.getSingle("TRANX_PROFILE", (Pack)param);
            if (re == null) {
                return null;
            }
            Step[] stepArray = Step.toObjects((byte[])((XLogProfilePack)re).profile);
            return stepArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }

    public static Step[] getFullProfile(String date, long txid, int max, int serverId) {
        System.err.println("TRANX_PROFILE_FULL: date=" + date);
        final ArrayList arr = new ArrayList();
        MapPack param = new MapPack();
        if (date != null) {
            param.put("date", date);
        }
        param.put("txid", (Value)new DecimalValue(txid));
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            tcp.process("TRANX_PROFILE_FULL", param, new INetReader(){

                @Override
                public void process(DataInputX in) throws IOException {
                    byte[] buff = in.readBlob();
                    arr.addAll(Arrays.asList(Step.toObjects((byte[])buff)));
                }
            });
            Step[] stepArray = arr.toArray(new Step[0]);
            return stepArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }

    public static byte[] getFullProfileByteArray(String date, long txid, int max, int serverId) {
        final ArrayList arr = new ArrayList();
        MapPack param = new MapPack();
        if (date != null) {
            param.put("date", date);
        }
        param.put("txid", (Value)new DecimalValue(txid));
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            tcp.process("TRANX_PROFILE_FULL", param, new INetReader(){

                @Override
                public void process(DataInputX in) throws IOException {
                    byte[] buff;
                    byte[] byArray = buff = in.readBlob();
                    int n = buff.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        arr.add(b);
                        ++n2;
                    }
                }
            });
            byte[] profile = new byte[arr.size()];
            int inx = 0;
            while (inx < arr.size()) {
                profile[inx] = (Byte)arr.get(inx);
                ++inx;
            }
            byte[] byArray = profile;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }

    public static boolean getHeapdumpByteArray(int objHash, String fileName, String localName, int serverId) {
        MapPack param = new MapPack();
        param.put("objHash", (long)objHash);
        param.put("fileName", fileName);
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            try {
                final FileOutputStream fileOuputStream = new FileOutputStream(localName);
                tcp.process("OBJECT_DOWNLOAD_HEAP_DUMP", param, new INetReader(){

                    @Override
                    public void process(DataInputX in) throws IOException {
                        byte[] buff = in.readBlob();
                        fileOuputStream.write(buff);
                    }
                });
                FileUtil.close((OutputStream)fileOuputStream);
            }
            catch (Exception e) {
                ConsoleProxy.errorSafe(e.toString());
                TcpProxy.putTcpProxy(tcp);
                return false;
            }
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return true;
    }

    public static XLogData getXLogData(int serverId, String date, long txid) {
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            MapPack param = new MapPack();
            param.put("date", date);
            param.put("txid", txid);
            Pack p = tcp.getSingle("XLOG_READ_BY_TXID", (Pack)param);
            if (p != null) {
                XLogPack xp = XLogUtil.toXLogPack(p);
                XLogData d = new XLogData(xp, serverId);
                d.objName = TextProxy.object.getLoadText(date, xp.objHash, serverId);
                d.serviceName = TextProxy.service.getLoadText(date, xp.service, serverId);
                XLogData xLogData = d;
                return xLogData;
            }
        }
        catch (Throwable th) {
            ConsoleProxy.errorSafe(th.toString());
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }
}

