/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.util.FileUtil;

public class ClientTCP {
    Socket socket;
    DataInputX in;
    DataOutputX out;

    public void open(int serverId, boolean socksLogin) {
        block6: {
            this.close();
            Server server = ServerManager.getInstance().getServer(serverId);
            if (server == null) {
                return;
            }
            try {
                if (socksLogin) {
                    InetSocketAddress proxyAddr = new InetSocketAddress(server.getSocksIp(), server.getSocksPort());
                    this.socket = new Socket(new Proxy(Proxy.Type.SOCKS, proxyAddr));
                } else {
                    this.socket = new Socket();
                }
                this.socket.setKeepAlive(true);
                this.socket.setTcpNoDelay(true);
                this.socket.connect(new InetSocketAddress(server.getIp(), server.getPort()), 3000);
                this.socket.setTcpNoDelay(true);
                this.socket.setSoTimeout(server.getSoTimeOut());
                this.in = new DataInputX(new BufferedInputStream(this.socket.getInputStream()));
                this.out = new DataOutputX(new BufferedOutputStream(this.socket.getOutputStream()));
                this.out.writeInt(-889315327);
                this.out.flush();
                if (!server.isConnected()) {
                    System.out.println(String.format("Success to connect %s:%d (%s)", server.getIp(), server.getPort(), server.isSocksLogin() ? String.valueOf(server.getSocksIp()) + ":" + server.getSocksPort() : "direct"));
                }
                server.setConnected(true);
            }
            catch (Throwable t) {
                System.out.println(t.getMessage());
                this.close();
                if (server.getConnectionPool().size() >= 1) break block6;
                server.setConnected(false);
            }
        }
    }

    public DataOutputX getOutput() {
        return this.out;
    }

    public DataInputX getInput() {
        return this.in;
    }

    public boolean isSessionOk() {
        return this.socket != null && !this.socket.isClosed();
    }

    public void close() {
        FileUtil.close((Socket)this.socket);
        FileUtil.close((DataInputX)this.in);
        FileUtil.close((DataOutputX)this.out);
        this.socket = null;
        this.in = null;
        this.out = null;
    }
}

