/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.net;

import scouter.Version;
import scouter.client.net.LoginResult;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BlobValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.CipherUtil;
import scouter.util.SysJMX;

public class LoginMgr {
    public static LoginResult login(int serverId, String user, String password) {
        Server server = ServerManager.getInstance().getServer(serverId);
        String encrypted = CipherUtil.sha256((String)password);
        return LoginMgr.silentLogin(server, user, encrypted);
    }

    public static LoginResult login(int serverId, String user, String password, boolean secureLogin) {
        Server server = ServerManager.getInstance().getServer(serverId);
        if (secureLogin) {
            password = CipherUtil.sha256((String)password);
        }
        server.setSecureMode(secureLogin);
        return LoginMgr.silentLogin(server, user, password);
    }

    public static LoginResult silentLogin(Server server, String user, String password) {
        LoginResult result = new LoginResult();
        try {
            MapPack param = new MapPack();
            param.put("id", user);
            param.put("pass", password);
            param.put("version", Version.getClientFullVersion());
            param.put("hostname", SysJMX.getHostName());
            param.put("isSocks", server.isSocksLogin());
            param.put("socksIp", server.getSocksIp());
            param.put("socksPort", (long)server.getSocksPort());
            MapPack out = TcpProxy.loginProxy(server.getId(), param);
            if (out == null) {
                result.success = false;
                result.errorMessage = "Network connection failed";
            } else {
                Value menuV;
                long session = out.getLong("session");
                String error = out.getText("error");
                if (error != null && session == 0L) {
                    result.success = false;
                    result.errorMessage = "Authentication failed";
                    return result;
                }
                server.setOpen(true);
                long time = out.getLong("time");
                String serverName = out.getText("server_id");
                String type = out.getText("type");
                String version = out.getText("version");
                String recommendedClientVersion = out.getText("client_version");
                String email = out.getText("email");
                String timezone = out.getText("timezone");
                int soTimeOut = out.getInt("so_time_out");
                String extLinkName = out.getText("ext_link_name");
                String extLinkUrlPattern = out.getText("ext_link_url_pattern");
                server.setSession(session);
                server.setName(serverName);
                server.setDelta(time);
                server.setUserId(user);
                server.setPassword(password);
                server.setGroup(type);
                server.setVersion(version);
                server.setRecommendedClientVersion(recommendedClientVersion);
                server.setEmail(email);
                server.setTimezone(timezone);
                server.setSoTimeOut(soTimeOut);
                server.setExtLinkName(extLinkName);
                server.setExtLinkUrlPattern(extLinkUrlPattern);
                Value value = out.get("policy");
                if (value != null) {
                    MapValue mv = (MapValue)value;
                    server.setGroupPolicy(mv);
                }
                if ((menuV = out.get("menu")) != null) {
                    MapValue mv = (MapValue)menuV;
                    server.setMenuEnableMap(mv);
                }
                CounterEngine counterEngine = server.getCounterEngine();
                MapPack m = LoginMgr.getCounterXmlServer(server.getId());
                if (m != null) {
                    counterEngine.clear();
                    Value v1 = m.get("default");
                    counterEngine.parse(((BlobValue)v1).value);
                    v1 = m.get("custom");
                    if (v1 != null) {
                        counterEngine.parse(((BlobValue)v1).value);
                    }
                }
                result.success = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.success = false;
            result.errorMessage = "Network connection failed : " + e.getMessage();
        }
        return result;
    }

    public static MapPack getCounterXmlServer(int serverId) {
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        Pack p = null;
        try {
            try {
                p = tcp.getSingle("GET_XML_COUNTER", null);
            }
            catch (Exception e) {
                e.printStackTrace();
                TcpProxy.putTcpProxy(tcp);
                return null;
            }
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return (MapPack)p;
    }
}

