/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.net;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import scouter.client.net.ClientTCP;
import scouter.client.net.ConnectionPool;
import scouter.client.net.DummyTcpProxy;
import scouter.client.net.INetReader;
import scouter.client.preferences.ServerPrefUtil;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.Value;

public class TcpProxy {
    private final ClientTCP tcp = new ClientTCP();
    private Server server;

    protected TcpProxy() {
    }

    protected TcpProxy(int serverId) {
        this.server = ServerManager.getInstance().getServer(serverId);
    }

    public static synchronized TcpProxy getTcpProxy(int serverId) {
        Server server = ServerManager.getInstance().getServer(serverId);
        if (server == null || !server.isOpen() || !server.isConnected()) {
            return new DummyTcpProxy();
        }
        ConnectionPool pool = server.getConnectionPool();
        if (pool.size() == 0) {
            return new TcpProxy(serverId);
        }
        return pool.removeFirst();
    }

    public static synchronized void putTcpProxy(TcpProxy t) {
        if (t == null) {
            return;
        }
        if (t.isValid() && t.getServer().isConnected()) {
            ConnectionPool pool = t.getServer().getConnectionPool();
            pool.put(t);
        } else {
            t.close();
        }
    }

    protected ClientTCP getClientTcp() {
        return this.tcp;
    }

    public Server getServer() {
        return this.server;
    }

    public synchronized void open() {
        if (!this.tcp.isSessionOk()) {
            boolean socksLogin = ServerPrefUtil.isSocksLogin(String.valueOf(this.getServer().getIp()) + ":" + this.getServer().getPort());
            this.tcp.open(this.server.getId(), socksLogin);
        }
    }

    public synchronized void open(boolean socksLogin) {
        if (!this.tcp.isSessionOk()) {
            this.tcp.open(this.server.getId(), socksLogin);
        }
    }

    public synchronized void close() {
        this.sendClose();
        this.tcp.close();
    }

    protected void finalize() throws Throwable {
        this.tcp.close();
    }

    public Pack getSingle(String cmd, Pack param) {
        List<Pack> values = this.process(cmd, param);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public List<Pack> process(String cmd, Pack param) {
        ArrayList<Pack> list = new ArrayList<Pack>();
        this.process(cmd, param, in -> {
            Pack p = in.readPack();
            list.add(p);
        });
        return list;
    }

    public Value getSingleValue(String cmd, Pack param) {
        List<Value> values = this.processValues(cmd, param);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public List<Value> processValues(String cmd, Pack param) {
        ArrayList<Value> list = new ArrayList<Value>();
        this.process(cmd, param, in -> {
            Value v = in.readValue();
            list.add(v);
        });
        return list;
    }

    public boolean isValid() {
        if (this instanceof DummyTcpProxy) {
            return false;
        }
        return this.tcp.isSessionOk();
    }

    public synchronized void process(String cmd, Object param, INetReader recv) {
        this.open();
        if (!this.tcp.isSessionOk()) {
            return;
        }
        long session = this.server.getSession();
        if (session != 0L) {
            DataOutputX out = this.tcp.getOutput();
            DataInputX in = this.tcp.getInput();
            try {
                byte resFlag;
                out.writeText(cmd);
                out.writeLong(session);
                if (param instanceof Value) {
                    out.writeValue((Value)param);
                } else if (param instanceof Pack) {
                    out.writePack((Pack)param);
                }
                out.flush();
                while ((resFlag = in.readByte()) == 3) {
                    recv.process(in);
                }
                if (resFlag == 68) {
                    this.server.setSession(0L);
                    this.tcp.close();
                }
            }
            catch (Throwable e) {
                this.tcp.close();
            }
        }
    }

    public synchronized void sendClose() {
        if (!this.tcp.isSessionOk()) {
            return;
        }
        DataOutputX out = this.tcp.getOutput();
        try {
            out.writeText("CLOSE");
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static MapPack loginProxy(int serverId, MapPack param) throws IOException {
        boolean socksLogin = param.getBoolean("isSocks");
        TcpProxy proxy = new TcpProxy(serverId);
        proxy.open(socksLogin);
        if (!proxy.isValid()) {
            return null;
        }
        param.put("ip", proxy.getLocalInetAddress().getHostAddress());
        DataOutputX out = proxy.getClientTcp().getOutput();
        DataInputX in = proxy.getClientTcp().getInput();
        try {
            out.writeText("LOGIN");
            out.writeLong(0L);
            out.writePack((Pack)param);
            out.flush();
            MapPack pack = null;
            while (in.readByte() == 3) {
                pack = (MapPack)in.readPack();
            }
            MapPack mapPack = pack;
            return mapPack;
        }
        finally {
            proxy.close();
        }
    }

    public InetAddress getLocalInetAddress() {
        return this.tcp.socket.getLocalAddress();
    }
}

