/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.notice;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.ui.PlatformUI;
import scouter.Version;
import scouter.client.misc.UpdateCheckScheduler;
import scouter.client.notice.NoticeDialog;
import scouter.client.util.ExUtil;
import scouter.client.util.RCPUtil;
import scouter.util.FileUtil;
import scouter.util.StringUtil;
import scouter.util.ThreadUtil;

public enum NoticeCheckScheduler {
    INSTANCE;

    private final String NOTICE_URL = "http://notice.scouterapm.com:6181/latest-notice";
    private final String NOTICE_FILENAME = "notice_tag";
    private final String CLIENT_HASH_FILENAME = "client_hash_tag";
    boolean initialized = false;

    public void initialize() {
        ExUtil.asyncRun(() -> {
            if (!this.initialized) {
                this.initialized = true;
                try {
                    ThreadUtil.sleep((long)5000L);
                    this.process();
                    this.registerTimer();
                }
                catch (Exception e) {
                    this.initialized = false;
                    e.printStackTrace();
                }
            }
        });
    }

    void registerTimer() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 10);
        calendar.set(12, 30);
        calendar.set(13, 0);
        Date checkTime = calendar.getTime();
        if (System.currentTimeMillis() > checkTime.getTime()) {
            calendar.add(5, 1);
            checkTime = calendar.getTime();
        }
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    System.out.println("Timer Start");
                    NoticeCheckScheduler.this.process();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, checkTime, 86400000L);
    }

    private void process() throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet("http://notice.scouterapm.com:6181/latest-notice");
        httpGet.addHeader("X-SCCH", this.getClientHash());
        try {
            String recommendedVersion = UpdateCheckScheduler.getRecommendedVersion();
            String clientVersion = Version.getVersion();
            httpGet.addHeader("X-SCV", String.valueOf(recommendedVersion) + "::" + clientVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HttpResponse response = null;
        response = httpClient.execute((HttpUriRequest)httpGet);
        System.out.println("Notice Response Code : " + response.getStatusLine().getStatusCode());
        String cacheTag = response.getFirstHeader("X-Scouter-ETag").getValue();
        if (StringUtil.isEmpty((String)cacheTag)) {
            return;
        }
        File noticeFile = new File(RCPUtil.getWorkingDirectory(), "notice_tag");
        if (!noticeFile.exists() || !cacheTag.equals(new String(FileUtil.readAll((File)noticeFile), "UTF-8")) || noticeFile.lastModified() < System.currentTimeMillis() - 2592000000L) {
            HttpEntity entity = response.getEntity();
            final String html = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            ExUtil.exec(PlatformUI.getWorkbench().getDisplay(), new Runnable(){

                @Override
                public void run() {
                    System.out.println("Open Notice Dialog");
                    new NoticeDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), html).open();
                }
            });
            FileUtil.save((File)noticeFile, (byte[])cacheTag.getBytes());
        }
    }

    private String getClientHash() {
        String newValue = Long.toHexString(Double.doubleToLongBits(Math.random()));
        File clientHashFile = new File(RCPUtil.getWorkingDirectory(), "client_hash_tag");
        if (!clientHashFile.exists()) {
            FileUtil.save((File)clientHashFile, (byte[])newValue.getBytes());
        } else {
            try {
                newValue = new String(FileUtil.readAll((File)clientHashFile), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                FileUtil.save((File)clientHashFile, (byte[])newValue.getBytes());
            }
        }
        return newValue;
    }
}

