/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.RCPUtil;
import scouter.client.util.UIUtil;
import scouter.lang.Account;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.CipherUtil;
import scouter.util.StringUtil;

public class AccountDialog {
    public static short ADD_MODE = 1;
    public static short EDIT_MODE = (short)2;
    int mode = ADD_MODE;
    Account targetAccount;
    int serverId;
    Shell dialog;
    Text idText;
    Button dupCheckBtn;
    Text passText;
    Text rePassText;
    Text emailText;
    Button okBtn;
    String selectedGroup = null;
    List<Button> radiobuttons = new ArrayList<Button>();
    boolean confirmId = false;

    public AccountDialog(int serverId) {
        this.serverId = serverId;
    }

    public AccountDialog(int serverId, Account account) {
        this.serverId = serverId;
        this.targetAccount = account;
    }

    public void show(short mode) {
        this.mode = mode;
        this.dialog = new Shell(Display.getDefault(), 67680);
        UIUtil.setDialogDefaultFunctions(this.dialog);
        if (mode == ADD_MODE) {
            this.dialog.setText("Add Account");
        } else if (mode == EDIT_MODE) {
            this.dialog.setText("Edit Account");
        }
        this.initialLayout();
        if (mode == ADD_MODE) {
            this.okBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AccountDialog.this.validateOk()) {
                        AccountDialog.this.okBtn.setEnabled(false);
                        AccountDialog.this.addAccount();
                    }
                }
            });
        } else if (mode == EDIT_MODE) {
            String group = null;
            if (this.targetAccount == null) {
                Server server = ServerManager.getInstance().getServer(this.serverId);
                this.idText.setText(server.getUserId());
                this.emailText.setText(server.getEmail());
                group = server.getGroup();
            } else {
                this.idText.setText(this.targetAccount.id);
                this.emailText.setText(this.targetAccount.email);
                group = this.targetAccount.group;
            }
            this.idText.setEnabled(false);
            this.dupCheckBtn.setEnabled(false);
            if (StringUtil.isNotEmpty((String)group)) {
                for (Button btn : this.radiobuttons) {
                    if (!btn.getText().equals(group)) continue;
                    this.selectedGroup = group;
                    btn.setSelection(true);
                    break;
                }
            }
            this.okBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AccountDialog.this.confirmId = true;
                    if (AccountDialog.this.validateOk()) {
                        AccountDialog.this.okBtn.setEnabled(false);
                        AccountDialog.this.editAccount();
                    }
                }
            });
        }
        this.dialog.pack();
        this.dialog.open();
    }

    private void initialLayout() {
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 10;
        this.dialog.setLayout((Layout)new GridLayout(1, true));
        Composite comp = new Composite((Composite)this.dialog, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        comp.setLayout((Layout)new FillLayout());
        Group profileGrp = new Group(comp, 0);
        profileGrp.setText("Profile");
        profileGrp.setLayout((Layout)ChartUtil.gridlayout(3));
        GridData data = null;
        Label label = new Label((Composite)profileGrp, 0);
        label.setText("ID");
        label.setAlignment(131072);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 100;
        label.setLayoutData((Object)data);
        this.idText = new Text((Composite)profileGrp, 2052);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 150;
        this.idText.setLayoutData((Object)data);
        this.dupCheckBtn = new Button((Composite)profileGrp, 8);
        this.dupCheckBtn.setText("&Check");
        data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 80;
        this.dupCheckBtn.setLayoutData((Object)data);
        this.dupCheckBtn.setEnabled(false);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String id = AccountDialog.this.idText.getText();
                AccountDialog.this.confirmId = false;
                if (StringUtil.isEmpty((String)id)) {
                    AccountDialog.this.dupCheckBtn.setEnabled(false);
                } else {
                    AccountDialog.this.dupCheckBtn.setEnabled(true);
                }
            }
        });
        this.dupCheckBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = AccountDialog.this.idText.getText();
                boolean avaliable = AccountDialog.this.avaliableId(id);
                if (avaliable) {
                    MessageDialog.openInformation((Shell)AccountDialog.this.dialog, (String)"Confirm", (String)(String.valueOf(id) + " is available"));
                    AccountDialog.this.confirmId = true;
                } else {
                    MessageDialog.openWarning((Shell)AccountDialog.this.dialog, (String)"Duplicated", (String)(String.valueOf(id) + " is exist"));
                    AccountDialog.this.confirmId = false;
                }
            }
        });
        label = new Label((Composite)profileGrp, 0);
        label.setText("Password");
        label.setAlignment(131072);
        data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        this.passText = new Text((Composite)profileGrp, 0x400804);
        data = new GridData(4, 0x1000000, true, false);
        this.passText.setLayoutData((Object)data);
        label = new Label((Composite)profileGrp, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        label = new Label((Composite)profileGrp, 0);
        label.setText("Re-Password");
        label.setAlignment(131072);
        data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        this.rePassText = new Text((Composite)profileGrp, 0x400804);
        data = new GridData(4, 0x1000000, true, false);
        this.rePassText.setLayoutData((Object)data);
        label = new Label((Composite)profileGrp, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        label = new Label((Composite)profileGrp, 0);
        label.setText("E-mail");
        label.setAlignment(131072);
        data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        this.emailText = new Text((Composite)profileGrp, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.emailText.setLayoutData((Object)data);
        label = new Label((Composite)profileGrp, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        ListValue groupList = this.getGroupList();
        if (groupList != null && groupList.size() > 0) {
            Group typeGrp = new Group((Composite)profileGrp, 0);
            typeGrp.setText("Group");
            data = new GridData(4, 4, true, false);
            data.horizontalSpan = 3;
            typeGrp.setLayoutData((Object)data);
            typeGrp.setLayout((Layout)new GridLayout(groupList.size() % 4 + 1, true));
            int i = 0;
            while (i < groupList.size()) {
                final Button btn = new Button((Composite)typeGrp, 16);
                btn.setText(CastUtil.cString((Object)groupList.get(i)));
                btn.setLayoutData((Object)new GridData(4, 4, true, false));
                btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AccountDialog.this.selectedGroup = btn.getText();
                    }
                });
                this.radiobuttons.add(btn);
                ++i;
            }
        }
        this.okBtn = new Button((Composite)this.dialog, 8);
        GridData gd = new GridData(131072, 4, false, false);
        gd.widthHint = 100;
        this.okBtn.setLayoutData((Object)gd);
        this.okBtn.setText("&Ok");
    }

    private boolean avaliableId(String id) {
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        MapPack p = new MapPack();
        try {
            MapPack param = new MapPack();
            param.put("id", id);
            p = (MapPack)tcp.getSingle("CHECK_ACCOUNT_ID", (Pack)param);
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return p.getBoolean("result");
    }

    private boolean validateOk() {
        if (!this.confirmId) {
            MessageDialog.openWarning((Shell)this.dialog, (String)"Confirm ID", (String)"Please check ID");
            return false;
        }
        String password = this.passText.getText();
        String repassword = this.rePassText.getText();
        if (StringUtil.isEmpty((String)password)) {
            MessageDialog.openWarning((Shell)this.dialog, (String)"Confirm Password", (String)"Please check password");
            return false;
        }
        if (!password.equals(repassword)) {
            MessageDialog.openWarning((Shell)this.dialog, (String)"Confirm Password", (String)"Please check re-password");
            return false;
        }
        if (this.selectedGroup == null) {
            MessageDialog.openWarning((Shell)this.dialog, (String)"Confirm Group", (String)"Please check group");
            return false;
        }
        return true;
    }

    private void addAccount() {
        final String id = this.idText.getText();
        final String password = this.passText.getText();
        final String email = this.emailText.getText();
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                boolean result;
                block5: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(AccountDialog.this.serverId);
                    result = false;
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("id", id);
                            param.put("pass", CipherUtil.sha256((String)password));
                            param.put("email", email);
                            param.put("group", AccountDialog.this.selectedGroup);
                            MapPack p = (MapPack)tcp.getSingle("ADD_ACCOUNT", (Pack)param);
                            result = p.getBoolean("result");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                final boolean finalResult = result;
                ExUtil.exec((Composite)AccountDialog.this.dialog, new Runnable(){

                    @Override
                    public void run() {
                        if (finalResult) {
                            MessageDialog.openInformation((Shell)(this).AccountDialog.this.dialog, (String)"Success[Add Account]", (String)"Your registration has been successful");
                            (this).AccountDialog.this.dialog.close();
                        } else {
                            MessageDialog.openError((Shell)(this).AccountDialog.this.dialog, (String)"Failed[Add Account]", (String)"Your registration failed");
                            (this).AccountDialog.this.okBtn.setEnabled(true);
                        }
                    }
                });
            }
        });
    }

    private void editAccount() {
        final String id = this.idText.getText();
        final String password = this.passText.getText();
        final String email = this.emailText.getText();
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                boolean result;
                block5: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(AccountDialog.this.serverId);
                    result = false;
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("id", id);
                            param.put("pass", CipherUtil.sha256((String)password));
                            param.put("email", email);
                            param.put("group", AccountDialog.this.selectedGroup);
                            MapPack p = (MapPack)tcp.getSingle("EDIT_ACCOUNT", (Pack)param);
                            result = p.getBoolean("result");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                final boolean finalResult = result;
                ExUtil.exec((Composite)AccountDialog.this.dialog, new Runnable(){

                    @Override
                    public void run() {
                        if (finalResult) {
                            if (ServerManager.getInstance().getServer((this).AccountDialog.this.serverId).getUserId().equals(id)) {
                                MessageDialog.openInformation((Shell)(this).AccountDialog.this.dialog, (String)"Success[Edit Account]", (String)"Your modification has been successful.\nYou will be restart.");
                                RCPUtil.restart();
                            } else {
                                MessageDialog.openInformation((Shell)(this).AccountDialog.this.dialog, (String)"Success[Edit Account]", (String)"Your modification has been successful.");
                                (this).AccountDialog.this.dialog.close();
                            }
                        } else {
                            MessageDialog.openError((Shell)(this).AccountDialog.this.dialog, (String)"Failed[Edit Account]", (String)"Your modification failed");
                            (this).AccountDialog.this.okBtn.setEnabled(true);
                        }
                    }
                });
            }
        });
    }

    private ListValue getGroupList() {
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        ListValue lv = null;
        try {
            MapPack p = (MapPack)tcp.getSingle("LIST_ACCOUNT_GROUP", null);
            lv = p.getList("group_list");
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return lv;
    }
}

