/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import scouter.client.Images;
import scouter.client.group.GroupManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.ImageCombo;
import scouter.client.util.UIUtil;

public class AddGroupDialog {
    Display display;
    IAddGroup callback;
    String objType;
    String displayObjType;
    int serverId;

    public AddGroupDialog(Display display, IAddGroup callback) {
        this.display = display;
        this.callback = callback;
    }

    public AddGroupDialog(Display display, IAddGroup callback, String objType, String displayObjType, int serverId) {
        this(display, callback);
        this.objType = objType;
        this.displayObjType = displayObjType;
        this.serverId = serverId;
    }

    public void show() {
        final Shell dialog = new Shell(this.display, 67680);
        UIUtil.setDialogDefaultFunctions(dialog);
        dialog.setLayout((Layout)new GridLayout(2, false));
        dialog.setText("Add Group");
        Label title = new Label((Composite)dialog, 0);
        title.setFont(new Font(null, "Arial", 10, 1));
        title.setText("Add group with object type");
        GridData gr = new GridData(16384, 0x1000000, true, true, 2, 1);
        gr.widthHint = 350;
        title.setLayoutData((Object)gr);
        Label label1 = new Label((Composite)dialog, 0);
        label1.setText("Object Type");
        label1.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        final ImageCombo typeCombo = new ImageCombo((Composite)dialog, 2056);
        typeCombo.setBackground(ColorUtil.getInstance().getColor("white"));
        if (this.objType == null) {
            Set<Integer> serverSet = ServerManager.getInstance().getOpenServerList();
            for (int serverId : serverSet) {
                Server server = ServerManager.getInstance().getServer(serverId);
                ArrayList objTypeList = server.getCounterEngine().getAllObjectType();
                for (String objType : objTypeList) {
                    String displayObjType = server.getCounterEngine().getDisplayNameObjectType(objType);
                    if (typeCombo.getData(displayObjType) != null) continue;
                    typeCombo.add(displayObjType, Images.getObjectIcon(objType, true, serverId));
                    typeCombo.setData(displayObjType, objType);
                }
            }
        } else {
            typeCombo.add(this.displayObjType, Images.getObjectIcon(this.objType, true, this.serverId));
            typeCombo.setData(this.displayObjType, this.objType);
            typeCombo.setEnabled(false);
        }
        typeCombo.setLayoutData(new GridData(4, 0x1000000, true, true));
        if (typeCombo.getItemCount() > 0) {
            typeCombo.select(0);
        }
        Label label2 = new Label((Composite)dialog, 0);
        label2.setText("Group Name");
        label2.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        final Text name = new Text((Composite)dialog, 2048);
        name.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        Button okBtn = new Button((Composite)dialog, 8);
        okBtn.setText("&Ok");
        gr = new GridData(131072, 0x1000000, false, false, 2, 1);
        gr.widthHint = 100;
        okBtn.setLayoutData((Object)gr);
        okBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (AddGroupDialog.this.callback == null) {
                    return;
                }
                String selectedType = (String)typeCombo.getData(typeCombo.getText());
                String groupName = name.getText();
                List<String> groups = GroupManager.getInstance().listGroup();
                if (groups.contains(groupName)) {
                    MessageDialog.openWarning((Shell)dialog, (String)"Duplicated Name", (String)(String.valueOf(groupName) + " is already exist."));
                } else if (AddGroupDialog.this.callback.addedGroup(selectedType, groupName)) {
                    dialog.close();
                } else {
                    MessageDialog.openError((Shell)dialog, (String)"Failed", (String)"Inappropriate name.");
                }
            }
        });
        dialog.setDefaultButton(okBtn);
        dialog.pack();
        dialog.open();
    }

    public static interface IAddGroup {
        public boolean addedGroup(String var1, String var2);
    }
}

