/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import scouter.client.util.UIUtil;
import scouter.util.StringUtil;

public class AddServerAddressDialog {
    private final Display display;
    ServerAddressAddition callback;
    Set<String> addr;
    private Shell dialog;
    Text newAddressTxt;

    public AddServerAddressDialog(Display display, ServerAddressAddition serverAddressAddition, Set<String> addr) {
        this.display = display;
        this.callback = serverAddressAddition;
        this.addr = addr;
    }

    public void show(Rectangle r) {
        this.dialog = this.setDialogLayout();
        this.dialog.pack();
        UIUtil.setDialogDefaultFunctions(this.dialog);
        Point cursorLocation = Display.getCurrent().getCursorLocation();
        this.dialog.setLocation(cursorLocation.x, cursorLocation.y);
        this.dialog.open();
    }

    public void close() {
        if (!this.dialog.isDisposed()) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private Shell setDialogLayout() {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setText("Add");
        dialog.setLayout((Layout)UIUtil.formLayout(5, 5));
        Label newAddressLbl = new Label((Composite)dialog, 0);
        newAddressLbl.setText("Server address (IP:Port)");
        newAddressLbl.setLayoutData((Object)UIUtil.formData(0, 5, 0, 5, null, -1, null, -1));
        final ToolTip formatTip = new ToolTip(dialog, 4096);
        formatTip.setMessage("IP:Port ex) 127.0.0.1:6100");
        final ToolTip existTip = new ToolTip(dialog, 4096);
        existTip.setMessage("Server Address is already exist!");
        this.newAddressTxt = new Text((Composite)dialog, 2048);
        this.newAddressTxt.setLayoutData((Object)UIUtil.formData(0, 5, newAddressLbl, 10, 100, -5, null, -1, 250));
        final Button confirmBtn = new Button((Composite)dialog, 8);
        confirmBtn.setLayoutData((Object)UIUtil.formData(null, -1, this.newAddressTxt, 10, 100, -5, null, -1, 100));
        confirmBtn.setText("Ok");
        confirmBtn.setEnabled(false);
        confirmBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String newAddr = AddServerAddressDialog.this.newAddressTxt.getText();
                newAddr.replaceAll("\\s+", "");
                if (StringUtil.isNotEmpty((String)newAddr)) {
                    if (AddServerAddressDialog.this.isInvalidFormat(newAddr)) {
                        AddServerAddressDialog.this.newAddressTxt.setFocus();
                        AddServerAddressDialog.this.newAddressTxt.selectAll();
                        Point loc = AddServerAddressDialog.this.newAddressTxt.toDisplay(AddServerAddressDialog.this.newAddressTxt.getLocation());
                        formatTip.setLocation(loc.x, loc.y - AddServerAddressDialog.this.newAddressTxt.getSize().y);
                        formatTip.setVisible(true);
                        return;
                    }
                    if (AddServerAddressDialog.this.addr.contains(newAddr)) {
                        AddServerAddressDialog.this.newAddressTxt.setFocus();
                        AddServerAddressDialog.this.newAddressTxt.selectAll();
                        Point loc = AddServerAddressDialog.this.newAddressTxt.toDisplay(AddServerAddressDialog.this.newAddressTxt.getLocation());
                        existTip.setLocation(loc.x, loc.y - AddServerAddressDialog.this.newAddressTxt.getSize().y);
                        existTip.setVisible(true);
                        return;
                    }
                    AddServerAddressDialog.this.callback.addServerAddress(newAddr);
                    dialog.close();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.newAddressTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AddServerAddressDialog.this.newAddressTxt.getText().length() > 0) {
                    confirmBtn.setEnabled(true);
                } else {
                    confirmBtn.setEnabled(false);
                }
            }
        });
        dialog.setDefaultButton(confirmBtn);
        return dialog;
    }

    private boolean isInvalidFormat(String text) {
        if (StringUtil.isEmpty((String)text)) {
            return true;
        }
        String[] strs = text.split(":");
        return strs == null || strs.length != 2;
    }

    public static interface ServerAddressAddition {
        public void addServerAddress(String var1);
    }
}

