/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.util.Date;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import scouter.client.Images;
import scouter.client.model.TextModel;
import scouter.client.model.TextProxy;
import scouter.client.preferences.PManager;
import scouter.client.util.ExUtil;
import scouter.client.util.UIUtil;
import scouter.lang.AlertLevel;
import scouter.lang.pack.AlertPack;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;

public class AlertNotifierDialog {
    private final Display display;
    private Shell dialog;
    private String objName;
    private int serverId;
    Label timeLbl;
    Label levelLbl;
    Label titleLbl;
    Label messageLbl;
    Label objectLbl;
    AlertPack p;
    Timer timer;

    public AlertNotifierDialog(Display display, int serverId) {
        this.display = display;
        this.serverId = serverId;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public void setPack(AlertPack p) {
        this.p = p;
    }

    public void show(Rectangle r) {
        this.dialog = this.setDialogLayout();
        this.dialog.pack();
        UIUtil.setDialogDefaultFunctions(this.dialog);
        if (this.p.tags.size() > 0) {
            this.dialog.setSize(600, 400);
        } else {
            this.dialog.setSize(600, 300);
        }
        int timeout = PManager.getInstance().getInt("alert_dialog_timeout");
        if (timeout > 0) {
            this.timer = new Timer(true);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ExUtil.exec((Composite)AlertNotifierDialog.this.dialog, new Runnable(){

                        @Override
                        public void run() {
                            AlertNotifierDialog.this.close();
                        }
                    });
                }
            }, timeout * 1000);
        }
        Monitor primaryMonitor = this.display.getPrimaryMonitor();
        Rectangle bounds = primaryMonitor.getBounds();
        Rectangle rect = this.dialog.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.dialog.setLocation(x, y);
        this.dialog.open();
    }

    public boolean isOpen() {
        return this.dialog != null && !this.dialog.isDisposed();
    }

    public void close() {
        if (!this.dialog.isDisposed()) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private Shell setDialogLayout() {
        Shell dialog = new Shell(this.display, 67696);
        dialog.setText("Alert");
        dialog.setLayout((Layout)UIUtil.formLayout(5, 5));
        Label iconLbl = new Label((Composite)dialog, 0);
        iconLbl.setImage(Images.ALERT_BIG);
        iconLbl.setLayoutData((Object)UIUtil.formData(0, 10, 0, 10, null, -1, null, -1));
        Composite mainComp = new Composite((Composite)dialog, 0);
        mainComp.setLayoutData((Object)UIUtil.formData(iconLbl, 10, 0, 5, 100, -5, 100, -30));
        mainComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        this.timeLbl = new Label(mainComp, 131072);
        this.timeLbl.setText(this.objName == null ? "" : "[" + this.objName + "] " + FormatUtil.print((Object)new Date(this.p.time), (String)"HH:mm:ss"));
        this.timeLbl.setLayoutData((Object)UIUtil.formData(0, 5, 0, 0, 100, -5, null, -1));
        FontData[] fD = this.timeLbl.getFont().getFontData();
        fD[0].setStyle(1);
        fD[0].setHeight(13);
        this.timeLbl.setFont(new Font((Device)this.display, fD[0]));
        this.timeLbl.setForeground(Display.getCurrent().getSystemColor(16));
        this.levelLbl = new Label(mainComp, 131072);
        this.levelLbl.setText(AlertLevel.getName((byte)this.p.level));
        this.levelLbl.setLayoutData((Object)UIUtil.formData(0, 5, this.timeLbl, 5, 100, -5, null, -1));
        fD[0].setHeight(15);
        this.levelLbl.setFont(new Font((Device)this.display, fD[0]));
        Label bar = new Label(mainComp, 0);
        bar.setBackground(Display.getCurrent().getSystemColor(16));
        bar.setLayoutData((Object)UIUtil.formData(0, 5, this.levelLbl, 4, 100, -5, null, -1, -1, 1));
        this.titleLbl = new Label(mainComp, 131072);
        if (this.p.level == 2) {
            this.titleLbl.setForeground(Display.getCurrent().getSystemColor(8));
        } else if (this.p.level == 1) {
            this.titleLbl.setForeground(Display.getCurrent().getSystemColor(6));
        } else if (this.p.level == 3) {
            this.titleLbl.setForeground(Display.getCurrent().getSystemColor(3));
        } else if (this.p.level == 0) {
            this.titleLbl.setForeground(Display.getCurrent().getSystemColor(9));
        }
        this.titleLbl.setText(this.p.title);
        this.titleLbl.setLayoutData((Object)UIUtil.formData(0, 5, this.levelLbl, 5, 100, -5, null, -1));
        fD[0].setHeight(17);
        fD[0].setStyle(1);
        this.titleLbl.setFont(new Font((Device)this.display, fD[0]));
        StyledText messageSt = new StyledText(mainComp, 2634);
        messageSt.setLayoutData((Object)UIUtil.formData(0, 5, this.titleLbl, 5, 100, -5, 100, 0));
        messageSt.setText(this.p.message);
        fD[0].setHeight(12);
        fD[0].setStyle(0);
        messageSt.setFont(new Font((Device)this.display, fD[0]));
        Pattern hyperlinkPattern = Pattern.compile("https*:\\/\\/\\S+");
        Matcher matcher = hyperlinkPattern.matcher(this.p.message);
        while (matcher.find()) {
            StyleRange styleRange = new StyleRange();
            styleRange.underline = true;
            styleRange.underlineStyle = 4;
            styleRange.start = matcher.start();
            styleRange.length = matcher.end() - matcher.start();
            messageSt.setStyleRange(styleRange);
        }
        messageSt.addListener(3, event -> {
            try {
                StyleRange offsetStyle;
                int offset = messageSt.getOffsetAtLocation(new Point(event.x, event.y));
                if (offset != -1 && (offsetStyle = messageSt.getStyleRangeAtOffset(offset)) != null && offsetStyle.underline && offsetStyle.underlineStyle == 4) {
                    StyleRange[] styleRangeArray = messageSt.getStyleRanges();
                    int n = styleRangeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StyleRange r = styleRangeArray[n2];
                        if (r.start <= offset && offset < r.start + r.length) {
                            String link = messageSt.getText().substring(r.start, r.start + r.length);
                            Program.launch((String)link);
                        }
                        ++n2;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        if (this.p.tags.size() > 0) {
            Text tagLabel = new Text(mainComp, 2634);
            tagLabel.setLayoutData((Object)UIUtil.formData(0, 5, this.objectLbl, 5, 100, -5, 100, 0));
            StringBuilder sb = new StringBuilder();
            Set keySet = this.p.tags.keySet();
            for (String key : keySet) {
                int hashIndex = key.indexOf(AlertPack.HASH_FLAG);
                if (hashIndex > -1) {
                    int titleIndex = key.lastIndexOf("_");
                    String title = key.substring(titleIndex + 1);
                    String textType = null;
                    textType = titleIndex > hashIndex ? key.substring(AlertPack.HASH_FLAG.length(), titleIndex) : key.substring(AlertPack.HASH_FLAG.length());
                    sb.append(String.valueOf(title) + " : ");
                    TextModel model = TextProxy.getTextModel(textType);
                    if (model != null) {
                        sb.append(model.getLoadText(DateUtil.yyyymmdd((long)this.p.time), this.p.tags.getInt(key), this.serverId));
                    }
                    sb.append("\n");
                    continue;
                }
                sb.append(String.valueOf(key) + " : " + this.p.tags.get(key) + "\n");
            }
            tagLabel.setText(sb.toString());
        }
        Button closeBtn = new Button((Composite)dialog, 8);
        closeBtn.setLayoutData((Object)UIUtil.formData(null, -1, mainComp, 5, 100, -5, null, -1, 150));
        closeBtn.setText("Close");
        closeBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AlertNotifierDialog.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        dialog.setDefaultButton(closeBtn);
        dialog.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                AlertNotifierDialog.this.close();
            }
        });
        return dialog;
    }
}

