/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class CalendarDialog {
    private final Display display;
    private final ILoadCalendarDialog callback;

    public CalendarDialog(Display display, ILoadCalendarDialog callback) {
        this.display = display;
        this.callback = callback;
    }

    public void show() {
        this.show(-1, -1, -1L);
    }

    public void show(int x, int y, long time) {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(2, true));
        dialog.setText("Date");
        UIUtil.setDialogDefaultFunctions(dialog);
        final DateTime calendar = new DateTime((Composite)dialog, 1024);
        GridData data = new GridData(4, 0x1000000, false, false, 2, 1);
        calendar.setLayoutData((Object)data);
        if (time > 0L) {
            String yyyymmdd = DateUtil.format((long)time, (String)"yyyy-MM-dd");
            String[] date = yyyymmdd.split("-");
            calendar.setDate(Integer.parseInt(date[0]), Integer.parseInt(date[1]) - 1, Integer.parseInt(date[2]));
        }
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            String date = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                            date = DateUtil.format((long)DateUtil.getTime((String)date, (String)"MM/dd/yyyy"), (String)"yyyyMMdd");
                            dialog.close();
                            CalendarDialog.this.callback.onPressedOk(date);
                            break;
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)dialog, (String)"Error55", (String)("Date format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        CalendarDialog.this.callback.onPressedCancel();
                        dialog.close();
                    }
                }
            }
        });
        dialog.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                CalendarDialog.this.callback.onPressedCancel();
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        }
        dialog.open();
    }

    public void showWithTime() {
        this.showWithTime(-1, -1, -1L);
    }

    public void showWithTime(Point p, long time) {
        if (p != null) {
            this.showWithTime((int)p.getX(), (int)p.getY() + 10, time);
        }
    }

    public void showWithTime(int x, int y, long time) {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(4, false));
        dialog.setText("Date/Time");
        UIUtil.setDialogDefaultFunctions(dialog);
        final DateTime calendar = new DateTime((Composite)dialog, 1024);
        GridData data = new GridData(4, 0x1000000, false, false, 4, 1);
        calendar.setLayoutData((Object)data);
        if (time > 0L) {
            int year = CastUtil.cint((Object)DateUtil.format((long)time, (String)"yyyy"));
            int month = CastUtil.cint((Object)DateUtil.format((long)time, (String)"MM")) - 1;
            int day = CastUtil.cint((Object)DateUtil.format((long)time, (String)"dd"));
            calendar.setDate(year, month, day);
            calendar.setDay(day);
        }
        Label label = new Label((Composite)dialog, 0);
        label.setText("From");
        final DateTime startTime = new DateTime((Composite)dialog, 32896);
        if (time > 0L) {
            int hours = CastUtil.cint((Object)DateUtil.format((long)time, (String)"HH"));
            int minutes = CastUtil.cint((Object)DateUtil.format((long)time, (String)"mm"));
            int seconds = CastUtil.cint((Object)DateUtil.format((long)time, (String)"ss"));
            startTime.setTime(hours, minutes, seconds);
        } else {
            startTime.setHours(7);
            startTime.setMinutes(0);
        }
        label = new Label((Composite)dialog, 0);
        label.setText("To");
        final Combo afterMinutes = new Combo((Composite)dialog, 12);
        ArrayList<String> minuteStrList = new ArrayList<String>();
        AfterMinuteUnit[] afterMinuteUnitArray = AfterMinuteUnit.values();
        int n = afterMinuteUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            AfterMinuteUnit minute = afterMinuteUnitArray[n2];
            minuteStrList.add(minute.getLabel());
            ++n2;
        }
        afterMinutes.setItems(minuteStrList.toArray(new String[AfterMinuteUnit.values().length]));
        afterMinutes.select(0);
        afterMinutes.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            String fromTime = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + " " + startTime.getHours() + ":" + (startTime.getMinutes() < 10 ? "0" : "") + startTime.getMinutes();
                            long startTime2 = DateUtil.getTime((String)fromTime, (String)"MM/dd/yyyy HH:mm");
                            long endTime = 0L;
                            String afterMinute = afterMinutes.getText();
                            AfterMinuteUnit m = AfterMinuteUnit.fromString(afterMinute);
                            if (m != null) {
                                endTime = startTime2 + m.getTime();
                            }
                            if (endTime <= startTime2) {
                                MessageDialog.openWarning((Shell)dialog, (String)"Warning", (String)"Time range is incorrect");
                                break;
                            }
                            if (!DateUtil.isSameDay((Date)new Date(startTime2), (Date)new Date(endTime))) {
                                endTime = DateUtil.getTime((String)(String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + " 23:59"), (String)"MM/dd/yyyy HH:mm");
                            }
                            CalendarDialog.this.callback.onPressedOk(startTime2, endTime);
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MessageDialog.openError((Shell)dialog, (String)"Error", (String)("Date format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        CalendarDialog.this.callback.onPressedCancel();
                        dialog.close();
                    }
                }
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        }
        dialog.open();
    }

    public void showWithEndTime() {
        long etime = TimeUtil.getCurrentTime() / 60000L * 60000L;
        long stime = etime - 300000L;
        this.showWithEndTime(stime, etime);
    }

    public void showWithEndTime(Point p, long stime, long etime) {
        if (p != null) {
            this.showWithEndTime((int)p.getX(), (int)p.getY() + 10, stime, etime);
        }
    }

    public void showWithEndTime(long stime, long etime) {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(4, false));
        dialog.setText("Date/Time");
        final DateTime calendar = new DateTime((Composite)dialog, 1024);
        GridData data = new GridData(4, 0x1000000, false, false, 4, 1);
        calendar.setLayoutData((Object)data);
        int year = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"yyyy"));
        int month = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"MM")) - 1;
        int day = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"dd"));
        calendar.setDate(year, month, day);
        calendar.setDay(day);
        Label label = new Label((Composite)dialog, 0);
        label.setText("From");
        final DateTime startTime = new DateTime((Composite)dialog, 32896);
        startTime.setHours(DateUtil.getHour((long)stime));
        startTime.setMinutes(DateUtil.getMin((long)stime));
        label = new Label((Composite)dialog, 0);
        label.setText("To");
        final DateTime endTime = new DateTime((Composite)dialog, 32896);
        endTime.setHours(DateUtil.getHour((long)etime));
        endTime.setMinutes(DateUtil.getMin((long)etime));
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            String fromTime = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + " " + (startTime.getHours() < 10 ? "0" : "") + startTime.getHours() + ":" + (startTime.getMinutes() < 10 ? "0" : "") + startTime.getMinutes();
                            boolean nextDay0 = false;
                            if (endTime.getHours() == 0 && endTime.getMinutes() == 0) {
                                nextDay0 = true;
                            }
                            String toTime = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + " " + (endTime.getHours() < 10 ? "0" : "") + endTime.getHours() + ":" + (endTime.getMinutes() < 10 ? "0" : "") + endTime.getMinutes();
                            long startTime2 = DateUtil.getTime((String)fromTime, (String)"MM/dd/yyyy HH:mm");
                            long endTime2 = DateUtil.getTime((String)toTime, (String)"MM/dd/yyyy HH:mm");
                            if (nextDay0) {
                                endTime2 += 86399000L;
                            }
                            if (endTime2 <= startTime2) {
                                MessageDialog.openWarning((Shell)dialog, (String)"Warning", (String)"Time range is incorrect");
                                break;
                            }
                            CalendarDialog.this.callback.onPressedOk(startTime2, endTime2);
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MessageDialog.openError((Shell)dialog, (String)"Error", (String)("Date format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        CalendarDialog.this.callback.onPressedCancel();
                        dialog.close();
                    }
                }
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        dialog.open();
    }

    public void showWithEndTime(int x, int y, long stime, long etime) {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(4, false));
        dialog.setText("Date/Time");
        final DateTime calendar = new DateTime((Composite)dialog, 1024);
        GridData data = new GridData(4, 0x1000000, false, false, 4, 1);
        calendar.setLayoutData((Object)data);
        int year = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"yyyy"));
        int month = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"MM")) - 1;
        int day = CastUtil.cint((Object)DateUtil.format((long)stime, (String)"dd"));
        calendar.setDate(year, month, day);
        calendar.setDay(day);
        Label label = new Label((Composite)dialog, 0);
        label.setText("From");
        final DateTime startTime = new DateTime((Composite)dialog, 32896);
        startTime.setHours(DateUtil.getHour((long)stime));
        startTime.setMinutes(DateUtil.getMin((long)stime));
        label = new Label((Composite)dialog, 0);
        label.setText("To");
        final DateTime endTime = new DateTime((Composite)dialog, 32896);
        endTime.setHours(DateUtil.getHour((long)etime));
        endTime.setMinutes(DateUtil.getMin((long)etime));
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            String fromTime = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + " " + (startTime.getHours() < 10 ? "0" : "") + startTime.getHours() + ":" + (startTime.getMinutes() < 10 ? "0" : "") + startTime.getMinutes();
                            boolean nextDay0 = false;
                            if (endTime.getHours() == 0 && endTime.getMinutes() == 0) {
                                nextDay0 = true;
                            }
                            String toTime = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + " " + (endTime.getHours() < 10 ? "0" : "") + endTime.getHours() + ":" + (endTime.getMinutes() < 10 ? "0" : "") + endTime.getMinutes();
                            long startTime2 = DateUtil.getTime((String)fromTime, (String)"MM/dd/yyyy HH:mm");
                            long endTime2 = DateUtil.getTime((String)toTime, (String)"MM/dd/yyyy HH:mm");
                            if (nextDay0) {
                                endTime2 += 86399000L;
                            }
                            if (endTime2 <= startTime2) {
                                MessageDialog.openWarning((Shell)dialog, (String)"Warning", (String)"Time range is incorrect");
                                break;
                            }
                            CalendarDialog.this.callback.onPressedOk(startTime2, endTime2);
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MessageDialog.openError((Shell)dialog, (String)"Error", (String)("Date format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        CalendarDialog.this.callback.onPressedCancel();
                        dialog.close();
                    }
                }
            }
        });
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        }
        dialog.setDefaultButton(okButton);
        dialog.pack();
        dialog.open();
    }

    public static enum AfterMinuteUnit {
        FIVE_MIN("5 min", 300000L),
        TEN_MIN("10 min", 600000L),
        TWT_MIN("20 min", 1200000L),
        THIRTY_MIN("30 min", 1800000L),
        ONE_HOUR("1 hour", 3600000L),
        FOUR_HOURS("4 hours", 14400000L);

        private String label;
        private long time;

        private AfterMinuteUnit(String label, long time) {
            this.label = label;
            this.time = time;
        }

        public String getLabel() {
            return this.label;
        }

        public long getTime() {
            return this.time;
        }

        public static AfterMinuteUnit fromString(String text) {
            if (text != null) {
                AfterMinuteUnit[] afterMinuteUnitArray = AfterMinuteUnit.values();
                int n = afterMinuteUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AfterMinuteUnit b = afterMinuteUnitArray[n2];
                    if (text.equalsIgnoreCase(b.label)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    public static interface ILoadCalendarDialog {
        public void onPressedOk(long var1, long var3);

        public void onPressedOk(String var1);

        public void onPressedCancel();
    }
}

