/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import scouter.client.Images;
import scouter.client.preferences.PManager;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.ImageCombo;
import scouter.client.util.UIUtil;
import scouter.lang.counters.CounterEngine;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class CalendarObjTypeDialog {
    private final Display display;
    private final ICalendarCallback callback;
    private final int serverId;
    private final CounterEngine counterEngine;
    private ImageCombo objTypeCombo;
    private String defObjType;

    public CalendarObjTypeDialog(Display display, ICalendarCallback callback, int serverId, String objType) {
        this.display = display;
        this.callback = callback;
        this.serverId = serverId;
        this.defObjType = StringUtil.isEmpty((String)objType) ? PManager.getInstance().getString("wasServiceDefaultWAS") : objType;
        this.counterEngine = ServerManager.getInstance().getServer(serverId).getCounterEngine();
    }

    public void show() {
        this.show(-1, -1, -1L);
    }

    public void show(int x, int y, long time) {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(2, true));
        dialog.setText("Date");
        UIUtil.setDialogDefaultFunctions(dialog);
        final DateTime calendar = new DateTime((Composite)dialog, 1024);
        calendar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        if (time > 0L) {
            String yyyymmdd = DateUtil.format((long)time, (String)"yyyy-MM-dd");
            String[] date = yyyymmdd.split("-");
            calendar.setDate(Integer.parseInt(date[0]), Integer.parseInt(date[1]) - 1, Integer.parseInt(date[2]));
        }
        this.objTypeCombo = new ImageCombo((Composite)dialog, 2056);
        GridData gd = new GridData(4, 4, false, true, 2, 1);
        gd.heightHint = 15;
        this.objTypeCombo.setLayoutData(gd);
        this.objTypeCombo.setBackground(ColorUtil.getInstance().getColor("white"));
        ArrayList objTypeList = this.counterEngine.getAllObjectType();
        int i = 0;
        while (i < objTypeList.size()) {
            String objType = (String)objTypeList.get(i);
            String displayName = this.counterEngine.getDisplayNameObjectType(objType);
            if (!StringUtil.isEmpty((String)displayName)) {
                this.objTypeCombo.add(displayName, Images.getObjectIcon(objType, true, this.serverId));
                this.objTypeCombo.setData(displayName, objType);
                if (this.defObjType.equals(objType)) {
                    this.objTypeCombo.select(i);
                }
            }
            ++i;
        }
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            String objType = CastUtil.cString((Object)CalendarObjTypeDialog.this.objTypeCombo.getData(CalendarObjTypeDialog.this.objTypeCombo.getText()));
                            if (StringUtil.isEmpty((String)objType)) {
                                MessageDialog.openError((Shell)dialog, (String)"Requirement", (String)"Select Object Type");
                                return;
                            }
                            String date = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                            date = DateUtil.format((long)DateUtil.getTime((String)date, (String)"MM/dd/yyyy"), (String)"yyyyMMdd");
                            CalendarObjTypeDialog.this.callback.onPressedOk(date, objType);
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)dialog, (String)"Error55", (String)("Date format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        dialog.close();
                    }
                }
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        }
        dialog.open();
    }

    public static interface ICalendarCallback {
        public void onPressedOk(String var1, String var2);
    }
}

