/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.hibernate.jdbc.util.BasicFormatterImpl;
import scouter.client.model.DigestModel;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.preferences.PManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.SpinnerThread;
import scouter.client.util.SqlFormatUtil;
import scouter.client.util.UIUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.StringUtil;

public class DigestDetailDialog {
    double PICO = Math.pow(10.0, -12.0);
    ArrayList<Resource> resources = new ArrayList();
    TabFolder tabFolder;
    DigestModel model;
    String date;
    long stime;
    long etime;
    int serverId;
    TabItem queryDetailItem;
    TabItem exampleQueryItem;
    TabItem graphsItem;
    XYGraph exTimeGraph;
    XYGraph exCntGraph;
    XYGraph rowsGraph;

    public void show(DigestModel model, long stime, long etime, int serverId) {
        this.model = model;
        this.date = DateUtil.yyyymmdd((long)stime);
        this.stime = stime;
        this.etime = etime;
        this.serverId = serverId;
        final Shell dialog = new Shell(Display.getDefault(), 67696);
        UIUtil.setDialogDefaultFunctions(dialog);
        dialog.setText("Digest Detail");
        dialog.setLayout((Layout)new GridLayout(1, true));
        this.tabFolder = new TabFolder((Composite)dialog, 2048);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.queryDetailItem = new TabItem(this.tabFolder, 0);
        this.queryDetailItem.setText("Query Detail");
        this.queryDetailItem.setControl(this.getQueryDetailControl((Composite)this.tabFolder));
        this.exampleQueryItem = new TabItem(this.tabFolder, 0);
        this.exampleQueryItem.setText("Example Query");
        this.exampleQueryItem.setControl(this.getSpinnerControl((Composite)this.tabFolder));
        this.graphsItem = new TabItem(this.tabFolder, 0);
        this.graphsItem.setText("Graphs");
        this.graphsItem.setControl(this.getSpinnerControl((Composite)this.tabFolder));
        Button closeBtn = new Button((Composite)dialog, 8);
        GridData gr = new GridData(131072, 4, false, false);
        gr.widthHint = 100;
        closeBtn.setLayoutData((Object)gr);
        closeBtn.setText("&Close");
        closeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Resource r : DigestDetailDialog.this.resources) {
                    if (r.isDisposed()) continue;
                    r.dispose();
                }
                dialog.close();
            }
        });
        dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Resource r : DigestDetailDialog.this.resources) {
                    if (r.isDisposed()) continue;
                    r.dispose();
                }
            }
        });
        this.loadExampleQuery();
        this.loadGraphsData();
        dialog.pack();
        dialog.open();
    }

    private Control getQueryDetailControl(Composite parent) {
        Font boldFont = new Font((Device)Display.getDefault(), "Arial", 9, 1);
        this.resources.add((Resource)boldFont);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        StyledText sqlText = new StyledText(composite, 2626);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 500;
        gd.heightHint = 150;
        sqlText.setLayoutData((Object)gd);
        String digest = TextProxy.maria.getLoadText(this.date, this.model.digestHash, this.serverId);
        if (digest != null) {
            digest = new BasicFormatterImpl().format(TextProxy.maria.getLoadText(this.date, this.model.digestHash, this.serverId));
        }
        SqlFormatUtil.applyStyledFormat(sqlText, digest);
        Label label1 = new Label(composite, 0);
        label1.setLayoutData((Object)new GridData(4, 4, false, false));
        label1.setText("Execution Time Statistics");
        label1.setFont(boldFont);
        Table exTimeTable = new Table(composite, 67584);
        gd = new GridData(4, 4, true, true);
        exTimeTable.setLayoutData((Object)gd);
        exTimeTable.setHeaderVisible(true);
        TableColumn maxTimeCol = new TableColumn(exTimeTable, 0);
        maxTimeCol.setWidth(125);
        maxTimeCol.setText("Max Time");
        TableColumn minTimeCol = new TableColumn(exTimeTable, 0);
        minTimeCol.setWidth(125);
        minTimeCol.setText("Min Time");
        TableColumn avgTimeCol = new TableColumn(exTimeTable, 0);
        avgTimeCol.setWidth(125);
        avgTimeCol.setText("Avg Time");
        TableColumn totalTimeCol = new TableColumn(exTimeTable, 0);
        totalTimeCol.setWidth(125);
        totalTimeCol.setText("Total Time");
        TableItem exTimeItem = new TableItem(exTimeTable, 0);
        exTimeItem.setText(new String[]{FormatUtil.print((Object)((double)this.model.maxResponseTime * this.PICO), (String)"#,##0.00#"), FormatUtil.print((Object)((double)this.model.minResponseTime * this.PICO), (String)"#,##0.00#"), FormatUtil.print((Object)(this.model.avgResponseTime * this.PICO), (String)"#,##0.00#"), FormatUtil.print((Object)((double)this.model.sumResponseTime * this.PICO), (String)"#,##0.00#")});
        label1 = new Label(composite, 0);
        label1.setLayoutData((Object)new GridData(4, 4, false, false));
        label1.setText("Row Statistics");
        label1.setFont(boldFont);
        Table rowTable = new Table(composite, 67584);
        gd = new GridData(4, 4, true, true);
        rowTable.setLayoutData((Object)gd);
        rowTable.setHeaderVisible(true);
        TableColumn rowsAffectedCol = new TableColumn(rowTable, 0);
        rowsAffectedCol.setWidth(165);
        rowsAffectedCol.setText("Rows Affected");
        TableColumn rowsSentCol = new TableColumn(rowTable, 0);
        rowsSentCol.setWidth(165);
        rowsSentCol.setText("Rows Sent");
        TableColumn rowsExaminedCol = new TableColumn(rowTable, 0);
        rowsExaminedCol.setWidth(165);
        rowsExaminedCol.setText("Rows Examined");
        TableItem rowItem = new TableItem(rowTable, 0);
        rowItem.setText(new String[]{FormatUtil.print((Object)this.model.rowsAffected, (String)"#,##0"), FormatUtil.print((Object)this.model.rowsSent, (String)"#,##0"), FormatUtil.print((Object)this.model.rowsExamined, (String)"#,##0")});
        label1 = new Label(composite, 0);
        label1.setLayoutData((Object)new GridData(4, 4, false, false));
        label1.setText("Execution Summary");
        label1.setFont(boldFont);
        Table sumTable = new Table(composite, 67584);
        gd = new GridData(4, 4, true, true);
        sumTable.setLayoutData((Object)gd);
        sumTable.setHeaderVisible(true);
        TableColumn execSum = new TableColumn(sumTable, 0);
        execSum.setWidth(100);
        execSum.setText("Executions");
        TableColumn errorCol = new TableColumn(sumTable, 0);
        errorCol.setWidth(100);
        errorCol.setText("Errors");
        TableColumn warnCol = new TableColumn(sumTable, 0);
        warnCol.setWidth(100);
        warnCol.setText("Warnings");
        TableColumn tableScansCol = new TableColumn(sumTable, 0);
        tableScansCol.setWidth(100);
        tableScansCol.setText("Table Scans");
        TableColumn badIndexCol = new TableColumn(sumTable, 0);
        badIndexCol.setWidth(100);
        badIndexCol.setText("Bad Index Used");
        TableItem sumItem = new TableItem(sumTable, 0);
        sumItem.setText(new String[]{FormatUtil.print((Object)this.model.execution, (String)"#,##0"), FormatUtil.print((Object)this.model.errorCnt, (String)"#,##0"), FormatUtil.print((Object)this.model.warnCnt, (String)"#,##0"), FormatUtil.print((Object)this.model.noIndexUsed, (String)"#,##0"), FormatUtil.print((Object)this.model.noGoodIndexUsed, (String)"#,##0")});
        label1 = new Label(composite, 0);
        label1.setLayoutData((Object)new GridData(4, 4, false, false));
        label1.setText("Time Span");
        label1.setFont(boldFont);
        Label timeLbl = new Label(composite, 0);
        timeLbl.setLayoutData((Object)new GridData(4, 4, false, false));
        timeLbl.setText(String.valueOf(DateUtil.timestamp((long)this.stime)) + " ~ " + DateUtil.timestamp((long)this.etime));
        label1 = new Label(composite, 0);
        label1.setLayoutData((Object)new GridData(4, 4, false, false));
        label1.setText("First Seen");
        label1.setFont(boldFont);
        Label firstLbl = new Label(composite, 0);
        firstLbl.setLayoutData((Object)new GridData(4, 4, false, false));
        firstLbl.setText(DateUtil.timestamp((long)this.model.firstSeen));
        return composite;
    }

    private Control getSpinnerControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        SpinnerThread spinnerThread = new SpinnerThread(composite, new GridData(0x1000000, 0x1000000, true, true));
        spinnerThread.start();
        return composite;
    }

    private Control getExampleQuery(Composite parent, MapPack m) {
        int sqlHash = m.getInt("sql_text");
        long time = m.getLong("time");
        long threadId = m.getLong("thread_id");
        long timer = m.getLong("timer");
        long lock_time = m.getLong("lock_time");
        Font boldFont = new Font((Device)Display.getDefault(), "Arial", 9, 1);
        this.resources.add((Resource)boldFont);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        StyledText sqlText = new StyledText(composite, 2626);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 500;
        gd.heightHint = 150;
        sqlText.setLayoutData((Object)gd);
        String sql = TextProxy.maria.getLoadText(this.date, sqlHash, this.serverId);
        if (!StringUtil.isEmpty((String)sql)) {
            sql = new BasicFormatterImpl().format(TextProxy.maria.getLoadText(this.date, sqlHash, this.serverId));
            SqlFormatUtil.applyStyledFormat(sqlText, sql);
        }
        Label label1 = new Label(composite, 0);
        label1.setLayoutData((Object)new GridData(4, 4, false, false));
        label1.setText("Execution Time");
        label1.setFont(boldFont);
        Label timerLbl = new Label(composite, 0);
        timerLbl.setLayoutData((Object)new GridData(4, 4, false, false));
        timerLbl.setText(String.valueOf(FormatUtil.print((Object)((double)timer * this.PICO), (String)"#,##0.00#")) + " sec");
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(4, 4, false, false));
        label2.setText("Date");
        label2.setFont(boldFont);
        Label dateLbl = new Label(composite, 0);
        dateLbl.setLayoutData((Object)new GridData(4, 4, false, false));
        dateLbl.setText(DateUtil.format((long)time, (String)"yyyy-MM-dd HH:mm:ss"));
        Label label3 = new Label(composite, 0);
        label3.setLayoutData((Object)new GridData(4, 4, false, false));
        label3.setText("Thread ID");
        label3.setFont(boldFont);
        Label threadLbl = new Label(composite, 0);
        threadLbl.setLayoutData((Object)new GridData(4, 4, false, false));
        threadLbl.setText(CastUtil.cString((Object)threadId));
        Label label4 = new Label(composite, 0);
        label4.setLayoutData((Object)new GridData(4, 4, false, false));
        label4.setText("Lock Time");
        label4.setFont(boldFont);
        Label lockLbl = new Label(composite, 0);
        lockLbl.setLayoutData((Object)new GridData(4, 4, false, false));
        lockLbl.setText(String.valueOf(FormatUtil.print((Object)((double)lock_time * this.PICO), (String)"#,##0.00#")) + " sec");
        return composite;
    }

    private Control getGraphsControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setBackground(ColorUtil.getInstance().getColor(1));
        composite.setBackgroundMode(2);
        final FigureCanvas exTimeCanvas = new FigureCanvas(composite);
        exTimeCanvas.setScrollBarVisibility(FigureCanvas.NEVER);
        exTimeCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.exTimeGraph = new XYGraph();
        exTimeCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = exTimeCanvas.getClientArea();
                DigestDetailDialog.this.exTimeGraph.setSize(r.width, r.height);
            }
        });
        this.exTimeGraph.setShowLegend(true);
        this.exTimeGraph.setShowTitle(true);
        this.exTimeGraph.setTitle("Execution Time (ms)");
        exTimeCanvas.setContents((IFigure)this.exTimeGraph);
        this.exTimeGraph.primaryXAxis.setDateEnabled(true);
        this.exTimeGraph.primaryXAxis.setShowMajorGrid(true);
        this.exTimeGraph.primaryYAxis.setAutoScale(true);
        this.exTimeGraph.primaryYAxis.setShowMajorGrid(true);
        this.exTimeGraph.primaryXAxis.setTitle("");
        this.exTimeGraph.primaryYAxis.setTitle("");
        this.exTimeGraph.primaryXAxis.setRange(this.stime, this.etime);
        final FigureCanvas exCntCanvas = new FigureCanvas(composite);
        exCntCanvas.setScrollBarVisibility(FigureCanvas.NEVER);
        exCntCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.exCntGraph = new XYGraph();
        exTimeCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = exCntCanvas.getClientArea();
                DigestDetailDialog.this.exCntGraph.setSize(r.width, r.height);
            }
        });
        this.exCntGraph.setShowLegend(false);
        this.exCntGraph.setShowTitle(true);
        this.exCntGraph.setTitle("Executions");
        exCntCanvas.setContents((IFigure)this.exCntGraph);
        this.exCntGraph.primaryXAxis.setDateEnabled(true);
        this.exCntGraph.primaryXAxis.setShowMajorGrid(true);
        this.exCntGraph.primaryYAxis.setAutoScale(true);
        this.exCntGraph.primaryYAxis.setShowMajorGrid(true);
        this.exCntGraph.primaryXAxis.setTitle("");
        this.exCntGraph.primaryYAxis.setTitle("");
        this.exCntGraph.primaryXAxis.setRange(this.stime, this.etime);
        final FigureCanvas rowsCanvas = new FigureCanvas(composite);
        rowsCanvas.setScrollBarVisibility(FigureCanvas.NEVER);
        rowsCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rowsGraph = new XYGraph();
        rowsCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = rowsCanvas.getClientArea();
                DigestDetailDialog.this.rowsGraph.setSize(r.width, r.height);
            }
        });
        this.rowsGraph.setShowLegend(true);
        this.rowsGraph.setShowTitle(true);
        this.rowsGraph.setTitle("Rows Affected/Sent");
        rowsCanvas.setContents((IFigure)this.rowsGraph);
        this.rowsGraph.primaryXAxis.setDateEnabled(true);
        this.rowsGraph.primaryXAxis.setShowMajorGrid(true);
        this.rowsGraph.primaryYAxis.setAutoScale(true);
        this.rowsGraph.primaryYAxis.setShowMajorGrid(true);
        this.rowsGraph.primaryXAxis.setTitle("");
        this.rowsGraph.primaryYAxis.setTitle("");
        this.rowsGraph.primaryXAxis.setRange(this.stime, this.etime);
        return composite;
    }

    private void loadExampleQuery() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                Pack p;
                block10: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(DigestDetailDialog.this.serverId);
                    p = null;
                    try {
                        try {
                            MapPack param = new MapPack();
                            ListValue objHashLv = new ListValue();
                            if (DigestDetailDialog.this.model.objHash == 0) {
                                DigestModel[] digestModelArray = DigestDetailDialog.this.model.getChildArray();
                                int n = digestModelArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    DigestModel d = digestModelArray[n2];
                                    objHashLv.add((long)d.objHash);
                                    ++n2;
                                }
                            } else {
                                objHashLv.add((long)DigestDetailDialog.this.model.objHash);
                            }
                            param.put("objHash", (Value)objHashLv);
                            param.put("date", DigestDetailDialog.this.date);
                            param.put("stime", DigestDetailDialog.this.stime);
                            param.put("etime", DigestDetailDialog.this.etime);
                            param.put("digest", (long)DigestDetailDialog.this.model.digestHash);
                            p = tcp.getSingle("DB_MAX_TIMER_WAIT_THREAD", (Pack)param);
                        }
                        catch (Exception e) {
                            ConsoleProxy.errorSafe(e.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (p != null && ((MapPack)p).size() > 0) {
                    final MapPack m = (MapPack)p;
                    ExUtil.exec((Composite)DigestDetailDialog.this.tabFolder, new Runnable(){

                        @Override
                        public void run() {
                            Control spinnerControl = (this).DigestDetailDialog.this.exampleQueryItem.getControl();
                            (this).DigestDetailDialog.this.exampleQueryItem.setControl(DigestDetailDialog.this.getExampleQuery((Composite)(this).DigestDetailDialog.this.tabFolder, m));
                            if (spinnerControl != null && !spinnerControl.isDisposed()) {
                                spinnerControl.dispose();
                            }
                        }
                    });
                } else {
                    ExUtil.exec((Composite)DigestDetailDialog.this.tabFolder, new Runnable(){

                        @Override
                        public void run() {
                            (this).DigestDetailDialog.this.exampleQueryItem.dispose();
                        }
                    });
                }
            }
        });
    }

    private void loadGraphsData() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                List<Pack> avgList = this.loadDigestCounter("AVG_TIMER_WAIT");
                List<Pack> minList = this.loadDigestCounter("MIN_TIMER_WAIT");
                List<Pack> maxList = this.loadDigestCounter("MAX_TIMER_WAIT");
                final Map<Long, Double> avgMap = ScouterUtil.getLoadTotalMap("AVG_TIMER_WAIT", avgList, "avg", (byte)1);
                final Map<Long, Double> minMap = ScouterUtil.getLoadMinOrMaxMap(minList, "min", (byte)1);
                final Map<Long, Double> maxMap = ScouterUtil.getLoadMinOrMaxMap(maxList, "max", (byte)1);
                List<Pack> execList = this.loadDigestCounter("COUNT_STAR");
                execList = this.changeToDeltaValue(execList);
                final Map<Long, Double> execMap = ScouterUtil.getLoadTotalMap("COUNT_STAR", execList, "sum", (byte)1);
                List<Pack> rowsAffectedList = this.loadDigestCounter("SUM_ROWS_AFFECTED");
                rowsAffectedList = this.changeToDeltaValue(rowsAffectedList);
                final Map<Long, Double> rowsAffectedMap = ScouterUtil.getLoadTotalMap("SUM_ROWS_AFFECTED", rowsAffectedList, "avg", (byte)1);
                List<Pack> rowsSentList = this.loadDigestCounter("SUM_ROWS_SENT");
                rowsSentList = this.changeToDeltaValue(rowsSentList);
                final Map<Long, Double> rowsSentMap = ScouterUtil.getLoadTotalMap("SUM_ROWS_SENT", rowsSentList, "avg", (byte)1);
                ExUtil.exec((Composite)DigestDetailDialog.this.tabFolder, new Runnable(){

                    @Override
                    public void run() {
                        Control spinnerControl = (this).DigestDetailDialog.this.graphsItem.getControl();
                        Control control = DigestDetailDialog.this.getGraphsControl((Composite)(this).DigestDetailDialog.this.tabFolder);
                        this.makeTrace("Average", (this).DigestDetailDialog.this.exTimeGraph, avgMap, Trace.TraceType.SOLID_LINE, ColorUtil.getInstance().getColor(4), (this).DigestDetailDialog.this.PICO * 1000.0);
                        this.makeTrace("Min", (this).DigestDetailDialog.this.exTimeGraph, minMap, Trace.TraceType.SOLID_LINE, ColorUtil.getInstance().getColor(6), (this).DigestDetailDialog.this.PICO * 1000.0);
                        double max = this.makeTrace("Max", (this).DigestDetailDialog.this.exTimeGraph, maxMap, Trace.TraceType.SOLID_LINE, ColorUtil.getInstance().getColor(10), (this).DigestDetailDialog.this.PICO * 1000.0);
                        (this).DigestDetailDialog.this.exTimeGraph.primaryYAxis.setRange(0.0, ChartUtil.getMaxValue(max));
                        max = this.makeTrace("Executions", (this).DigestDetailDialog.this.exCntGraph, execMap, Trace.TraceType.AREA, ColorUtil.getInstance().getColor(4), 1.0);
                        (this).DigestDetailDialog.this.exCntGraph.primaryYAxis.setRange(0.0, ChartUtil.getMaxValue(max));
                        max = this.makeTrace("Rows Affected", (this).DigestDetailDialog.this.rowsGraph, rowsAffectedMap, Trace.TraceType.AREA, ColorUtil.getInstance().getColor(4), 1.0);
                        double max2 = this.makeTrace("Rows Sent", (this).DigestDetailDialog.this.rowsGraph, rowsSentMap, Trace.TraceType.AREA, ColorUtil.getInstance().getColor(6), 1.0);
                        (this).DigestDetailDialog.this.rowsGraph.primaryYAxis.setRange(0.0, ChartUtil.getMaxValue(Math.max(max, max2)));
                        (this).DigestDetailDialog.this.graphsItem.setControl(control);
                        if (spinnerControl != null && !spinnerControl.isDisposed()) {
                            spinnerControl.dispose();
                        }
                    }

                    private double makeTrace(String name, XYGraph xyGraph, Map<Long, Double> valueMap, Trace.TraceType type, Color color, double weight) {
                        CircularBufferDataProvider provider = new CircularBufferDataProvider(true);
                        provider.setBufferSize(valueMap.size());
                        provider.setCurrentXDataArray(new double[0]);
                        provider.setCurrentYDataArray(new double[0]);
                        Trace trace = new Trace(name, xyGraph.primaryXAxis, xyGraph.primaryYAxis, provider);
                        trace.setPointStyle(Trace.PointStyle.NONE);
                        trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
                        trace.setTraceType(type);
                        trace.setTraceColor(color);
                        trace.setAreaAlpha(90);
                        xyGraph.addTrace(trace);
                        Set<Long> timeSet = valueMap.keySet();
                        double max = 0.0;
                        for (long time : timeSet) {
                            double v = CastUtil.cdouble((Object)valueMap.get(time)) * weight;
                            if (v > max) {
                                max = v;
                            }
                            provider.addSample(new Sample(CastUtil.cdouble((Object)time), v));
                        }
                        return max;
                    }
                });
            }

            private List<Pack> loadDigestCounter(String column) {
                TcpProxy tcp = TcpProxy.getTcpProxy(DigestDetailDialog.this.serverId);
                List<Pack> list = null;
                try {
                    try {
                        MapPack param = new MapPack();
                        ListValue objHashLv = new ListValue();
                        if (DigestDetailDialog.this.model.objHash == 0) {
                            DigestModel[] digestModelArray = DigestDetailDialog.this.model.getChildArray();
                            int n = digestModelArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DigestModel d = digestModelArray[n2];
                                objHashLv.add((long)d.objHash);
                                ++n2;
                            }
                        } else {
                            objHashLv.add((long)DigestDetailDialog.this.model.objHash);
                        }
                        param.put("objHash", (Value)objHashLv);
                        param.put("date", DigestDetailDialog.this.date);
                        param.put("stime", DigestDetailDialog.this.stime);
                        param.put("etime", DigestDetailDialog.this.etime);
                        param.put("digest", (long)DigestDetailDialog.this.model.digestHash);
                        param.put("column", column);
                        list = tcp.process("DB_LOAD_DIGEST_COUNTER", (Pack)param);
                    }
                    catch (Exception e) {
                        ConsoleProxy.errorSafe(e.toString());
                        TcpProxy.putTcpProxy(tcp);
                    }
                }
                finally {
                    TcpProxy.putTcpProxy(tcp);
                }
                return list;
            }

            private List<Pack> changeToDeltaValue(List<Pack> packList) {
                ArrayList<Pack> newList = new ArrayList<Pack>();
                for (Pack p : packList) {
                    MapPack m = (MapPack)p;
                    ListValue timeLv = m.getList("time");
                    ListValue valueLv = m.getList("value");
                    ListValue newValueLv = new ListValue();
                    long beforeTime = 0L;
                    double beforeValue = 0.0;
                    int i = 0;
                    while (i < timeLv.size()) {
                        long time = timeLv.getLong(i);
                        double value = valueLv.getDouble(i);
                        double newValue = 0.0;
                        if (i > 0) {
                            newValue = (value - beforeValue) / ((double)(time - beforeTime) / 1000.0);
                        }
                        newValueLv.add(newValue);
                        beforeTime = time;
                        beforeValue = value;
                        ++i;
                    }
                    m.put("value", (Value)newValueLv);
                    newList.add((Pack)m);
                }
                return newList;
            }
        });
    }
}

