/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.awt.Point;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import scouter.client.util.UIUtil;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class DualCalendarDialog {
    private final Display display;
    private final ILoadDualCounterDialog callback;

    public DualCalendarDialog(Display display, ILoadDualCounterDialog callback) {
        this.display = display;
        this.callback = callback;
    }

    public void show() {
        this.show(-1, -1);
    }

    public void show(Point p) {
        if (p != null) {
            this.show((int)p.getX(), (int)p.getY() + 10);
        }
    }

    public void show(int x, int y) {
        this.show("Start Date:", "End Date:", x, y, null, null);
    }

    public void show(int x, int y, String yyyymmdd1, String yyyymmdd2) {
        this.show("Start Date:", "End Date:", x, y, yyyymmdd1, yyyymmdd2);
    }

    public void show(String label1, String label2, int x, int y) {
        this.show(label1, label2, x, y, null, null);
    }

    public void show(String label1, String label2, int x, int y, String yyyymmdd1, String yyyymmdd2) {
        int day;
        int month;
        int year;
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(2, true));
        dialog.setText("Date");
        UIUtil.setDialogDefaultFunctions(dialog);
        Label sDate = new Label((Composite)dialog, 0);
        sDate.setText(label1);
        GridData data = new GridData(4, 0x1000000, false, false, 2, 1);
        sDate.setLayoutData((Object)data);
        final DateTime startCal = new DateTime((Composite)dialog, 1024);
        data = new GridData(4, 0x1000000, false, false, 2, 1);
        startCal.setLayoutData((Object)data);
        Label eDate = new Label((Composite)dialog, 0);
        eDate.setText(label2);
        data = new GridData(4, 0x1000000, false, false, 2, 1);
        eDate.setLayoutData((Object)data);
        final DateTime endCal = new DateTime((Composite)dialog, 1024);
        data = new GridData(4, 0x1000000, false, false, 2, 1);
        endCal.setLayoutData((Object)data);
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            String sDate = String.valueOf(startCal.getMonth() + 1) + "/" + startCal.getDay() + "/" + startCal.getYear();
                            sDate = DateUtil.format((long)DateUtil.getTime((String)sDate, (String)"MM/dd/yyyy"), (String)"yyyyMMdd");
                            String eDate = String.valueOf(endCal.getMonth() + 1) + "/" + endCal.getDay() + "/" + endCal.getYear();
                            eDate = DateUtil.format((long)DateUtil.getTime((String)eDate, (String)"MM/dd/yyyy"), (String)"yyyyMMdd");
                            if (CastUtil.cint((Object)sDate) > CastUtil.cint((Object)eDate)) {
                                MessageDialog.openError((Shell)dialog, (String)"Error", (String)"End Date is later than Start Date");
                                return;
                            }
                            DualCalendarDialog.this.callback.onPressedOk(sDate, eDate);
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)dialog, (String)"Error55", (String)("Date format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        DualCalendarDialog.this.callback.onPressedCancel();
                        dialog.close();
                    }
                }
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        }
        if (yyyymmdd1 != null) {
            year = Integer.valueOf(yyyymmdd1.substring(0, 4));
            month = Integer.valueOf(yyyymmdd1.substring(4, 6)) - 1;
            day = Integer.valueOf(yyyymmdd1.substring(6, 8));
            startCal.setDate(year, month, day);
        }
        if (yyyymmdd2 != null) {
            year = Integer.valueOf(yyyymmdd2.substring(0, 4));
            month = Integer.valueOf(yyyymmdd2.substring(4, 6)) - 1;
            day = Integer.valueOf(yyyymmdd2.substring(6, 8));
            endCal.setDate(year, month, day);
        }
        dialog.open();
    }

    public static enum AfterMinuteUnit {
        FIVE_MIN("5 min", 300000L),
        TEN_MIN("10 min", 600000L),
        TWT_MIN("20 min", 1200000L),
        THIRTY_MIN("30 min", 1800000L);

        private String label;
        private long time;

        private AfterMinuteUnit(String label, long time) {
            this.label = label;
            this.time = time;
        }

        public String getLabel() {
            return this.label;
        }

        public long getTime() {
            return this.time;
        }

        public static AfterMinuteUnit fromString(String text) {
            if (text != null) {
                AfterMinuteUnit[] afterMinuteUnitArray = AfterMinuteUnit.values();
                int n = afterMinuteUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AfterMinuteUnit b = afterMinuteUnitArray[n2];
                    if (text.equalsIgnoreCase(b.label)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    public static interface ILoadDualCounterDialog {
        public void onPressedOk(long var1, long var3);

        public void onPressedOk(String var1, String var2);

        public void onPressedCancel();
    }
}

