/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import scouter.client.util.UIUtil;

public class EditableMessageDialog {
    Shell dialog;
    StyledText text;

    public void show(String title, String message) {
        this.show(title, message, new ArrayList<StyleRange>());
    }

    public void show(String title, String message, LineStyleListener listener) {
        this.initLayout();
        this.dialog.setText(title);
        this.text.setText(message);
        if (listener != null) {
            this.text.addLineStyleListener(listener);
        }
        this.dialog.pack();
        this.dialog.open();
    }

    public void show(String title, String message, List<StyleRange> srList) {
        this.initLayout();
        this.dialog.setText(title);
        this.text.setText(message);
        if (srList != null && srList.size() > 0) {
            this.text.setStyleRanges(srList.toArray(new StyleRange[srList.size()]));
        }
        this.dialog.pack();
        this.dialog.open();
    }

    private void initLayout() {
        this.dialog = new Shell(Display.getDefault(), 2160);
        UIUtil.setDialogDefaultFunctions(this.dialog);
        this.dialog.setLayout((Layout)new GridLayout(1, true));
        this.text = new StyledText((Composite)this.dialog, 2626);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        gd.heightHint = 300;
        this.text.setLayoutData((Object)gd);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!(e.stateMask != 262144 && e.stateMask != 0x400000 || e.keyCode != 97 && e.keyCode != 65)) {
                    EditableMessageDialog.this.text.selectAll();
                }
            }
        });
        Button btn = new Button((Composite)this.dialog, 8);
        gd = new GridData(131072, 4, false, false);
        gd.widthHint = 100;
        btn.setLayoutData((Object)gd);
        btn.setText("&Close");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableMessageDialog.this.dialog.close();
            }
        });
    }
}

