/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.text.Collator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import scouter.client.Images;
import scouter.client.group.GroupManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.popup.AddGroupDialog;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.UIUtil;

public class GroupAssignmentDialog
implements AddGroupDialog.IAddGroup {
    Display display;
    int serverId;
    int objHash;
    String objName;
    String objType;
    Table groupTable;
    IGroupAssign callback;
    Set<Integer> noSelectedSet = new HashSet<Integer>();
    Set<Integer> selectedSet = new HashSet<Integer>();

    public GroupAssignmentDialog(Display display, int serverId, int objHash, String objName, String objType, IGroupAssign callback) {
        this.display = display;
        this.serverId = serverId;
        this.objHash = objHash;
        this.objName = objName;
        this.objType = objType;
        this.callback = callback;
    }

    public void show() {
        final Shell dialog = new Shell(this.display, 67680);
        UIUtil.setDialogDefaultFunctions(dialog);
        dialog.setLayout((Layout)new GridLayout(2, false));
        dialog.setText("Group Assignment");
        CLabel title = new CLabel((Composite)dialog, 0);
        GridData gr = new GridData(16384, 0x1000000, true, true, 2, 1);
        title.setLayoutData((Object)gr);
        title.setFont(new Font(null, "Arial", 10, 1));
        title.setImage(Images.getObjectIcon(this.objType, true, this.serverId));
        title.setText(this.objName);
        this.groupTable = new Table((Composite)dialog, 2080);
        gr = new GridData(4, 4, true, true);
        gr.widthHint = 250;
        gr.heightHint = 350;
        this.groupTable.setLayoutData((Object)gr);
        Composite buttonComp = new Composite((Composite)dialog, 0);
        gr = new GridData(4, 4, false, true);
        buttonComp.setLayoutData((Object)gr);
        buttonComp.setLayout((Layout)UIUtil.formLayout(3, 3));
        Button selectAllBtn = new Button(buttonComp, 8);
        selectAllBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 5, null, -1, null, -1, 100));
        selectAllBtn.setText("&Select All");
        selectAllBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items;
                TableItem[] tableItemArray = items = GroupAssignmentDialog.this.groupTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(true);
                    ++n2;
                }
            }
        });
        Button deselectAllBtn = new Button(buttonComp, 8);
        deselectAllBtn.setLayoutData((Object)UIUtil.formData(null, -1, selectAllBtn, 5, null, -1, null, -1, 100));
        deselectAllBtn.setText("&Deselect All");
        deselectAllBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items;
                TableItem[] tableItemArray = items = GroupAssignmentDialog.this.groupTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(false);
                    ++n2;
                }
            }
        });
        Button newBtn = new Button(buttonComp, 8);
        newBtn.setLayoutData((Object)UIUtil.formData(null, -1, deselectAllBtn, 10, null, -1, null, -1, 100));
        newBtn.setText("&New");
        newBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AgentObject agent = AgentModelThread.getInstance().getAgentObject(GroupAssignmentDialog.this.objHash);
                if (agent == null) {
                    return;
                }
                Server server = ServerManager.getInstance().getServer(agent.getServerId());
                if (server == null) {
                    server = ServerManager.getInstance().getDefaultServer();
                }
                String displayObjType = server.getCounterEngine().getDisplayNameObjectType(GroupAssignmentDialog.this.objType);
                AddGroupDialog addDialog = new AddGroupDialog(GroupAssignmentDialog.this.display, GroupAssignmentDialog.this, GroupAssignmentDialog.this.objType, displayObjType, server.getId());
                addDialog.show();
            }
        });
        Composite bottomComp = new Composite((Composite)dialog, 0);
        bottomComp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        bottomComp.setLayout((Layout)UIUtil.formLayout(3, 3));
        Button cancelBtn = new Button(bottomComp, 8);
        cancelBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, 100, -5, null, -1, 100));
        cancelBtn.setText("&Cancel");
        cancelBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                dialog.close();
            }
        });
        Button okBtn = new Button(bottomComp, 8);
        okBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, cancelBtn, -5, null, -1, 100));
        okBtn.setText("&Ok");
        okBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = GroupAssignmentDialog.this.groupTable.getItems();
                ArrayList<String> checked = new ArrayList<String>();
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        checked.add(item.getText());
                    }
                    ++n2;
                }
                GroupAssignmentDialog.this.callback.endGroupAssignment(GroupAssignmentDialog.this.objHash, checked.toArray(new String[checked.size()]));
                dialog.close();
            }
        });
        Set<String> groupSet = GroupManager.getInstance().getGroupsByType(this.objType);
        Set<String> assginedGroups = GroupManager.getInstance().getObjGroups(this.objHash);
        for (String group : groupSet) {
            TableItem item = new TableItem(this.groupTable, 0);
            item.setText(group);
            item.setChecked(assginedGroups.contains(group));
        }
        this.sortTable(this.groupTable);
        dialog.pack();
        dialog.open();
    }

    private void sortTable(Table table) {
        TableItem[] items = table.getItems();
        Collator collator = Collator.getInstance(Locale.getDefault());
        int i = 1;
        while (i < items.length) {
            String value1 = items[i].getText(0);
            int j = 0;
            while (j < i) {
                String value2 = items[j].getText(0);
                if (collator.compare(value1, value2) < 0) {
                    String text = items[i].getText(0);
                    boolean checked = items[i].getChecked();
                    items[i].dispose();
                    TableItem item = new TableItem(table, 0, j);
                    item.setText(text);
                    item.setChecked(checked);
                    items = table.getItems();
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public boolean addedGroup(String objType, String name) {
        if (GroupManager.getInstance().addGroup(objType, name)) {
            TableItem item = new TableItem(this.groupTable, 0);
            item.setText(name);
            this.sortTable(this.groupTable);
            return true;
        }
        return false;
    }

    public static interface IGroupAssign {
        public void endGroupAssignment(int var1, String[] var2);
    }
}

