/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import scouter.Version;
import scouter.client.net.LoginMgr;
import scouter.client.net.LoginResult;
import scouter.client.popup.event.AbstractFocusGainedListener;
import scouter.client.preferences.ServerPrefUtil;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.UIUtil;
import scouter.util.StringUtil;
import scouter.util.ThreadUtil;

public class LoginDialog2
extends Dialog {
    public static final String ID = LoginDialog2.class.getName();
    private final Shell shell;
    private final ILoginDialog callback;
    private final int openType;
    public static final int TYPE_STARTUP = 991;
    public static final int TYPE_ADD_SERVER = 992;
    public static final int TYPE_OPEN_SERVER = 993;
    public static final int TYPE_EDIT_SERVER = 994;
    Combo addrCombo;
    Combo socksAddrCombo;
    Text idText;
    Text passText;
    Label idLabel;
    Label passLabel;
    List messageList;
    Button autoLoginCheck;
    Button secureCheck;
    Button sock5Check;
    boolean autoLogin;
    boolean secureLogin = true;
    boolean sock5Login;
    String address;
    String socksAddress;

    public LoginDialog2(Shell shell, ILoginDialog callback, int openType, String address, String socksAddress) {
        super(shell);
        this.shell = shell;
        this.callback = callback;
        this.openType = openType;
        this.address = address;
        this.socksAddress = socksAddress;
        this.sock5Login = StringUtil.isNotEmpty((String)socksAddress);
    }

    protected Control createDialogArea(Composite parent) {
        Server server;
        Composite comp = (Composite)super.createDialogArea(parent);
        comp.setLayout((Layout)UIUtil.formLayout(5, 5));
        Group parentGroup = new Group(comp, 0);
        parentGroup.setText("Authentication Info");
        parentGroup.setLayout((Layout)UIUtil.formLayout(5, 5));
        parentGroup.setLayoutData((Object)UIUtil.formData(null, -1, 0, 0, null, -1, null, -1));
        Label addrLabel = new Label((Composite)parentGroup, 131072);
        addrLabel.setText("Server Address :");
        addrLabel.setLayoutData((Object)UIUtil.formData(null, -1, 0, 10, null, -1, null, -1, 100));
        String[] addrs = ServerPrefUtil.getStoredServerList();
        this.addrCombo = new Combo((Composite)parentGroup, 2816);
        if (addrs != null && addrs.length > 0) {
            this.addrCombo.setItems(addrs);
        }
        this.addrCombo.setEnabled(true);
        this.addrCombo.setLayoutData((Object)UIUtil.formData(addrLabel, 5, 0, 7, 100, -5, null, -1, 150));
        this.idLabel = new Label((Composite)parentGroup, 131072);
        this.idLabel.setText("ID :");
        this.idLabel.setLayoutData((Object)UIUtil.formData(null, -1, this.addrCombo, 10, null, -1, null, -1, 100));
        this.idText = new Text((Composite)parentGroup, 2052);
        this.idText.setLayoutData((Object)UIUtil.formData(this.idLabel, 5, this.addrCombo, 7, 100, -5, null, -1));
        this.idText.addFocusListener((FocusListener)new AbstractFocusGainedListener(){

            public void focusGained(FocusEvent e) {
                LoginDialog2.this.idText.selectAll();
            }
        });
        this.passLabel = new Label((Composite)parentGroup, 131072);
        this.passLabel.setText("Password :");
        this.passLabel.setLayoutData((Object)UIUtil.formData(null, -1, this.idText, 10, null, -1, null, -1, 100));
        this.createPasswordInput((Composite)parentGroup);
        this.autoLoginCheck = new Button((Composite)parentGroup, 32);
        this.autoLoginCheck.setText("Auto Login");
        this.autoLoginCheck.setLayoutData((Object)UIUtil.formData(null, -1, this.passLabel, 10, 100, -5, null, -1));
        this.autoLoginCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginDialog2.this.autoLogin = LoginDialog2.this.autoLoginCheck.getSelection();
            }
        });
        this.autoLoginCheck.setSelection(false);
        this.secureCheck = new Button((Composite)parentGroup, 32);
        this.secureCheck.setText("Secure Login");
        this.secureCheck.setLayoutData((Object)UIUtil.formData(null, -1, this.passLabel, 10, this.autoLoginCheck, -5, null, -1));
        this.secureCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginDialog2.this.secureLogin = LoginDialog2.this.secureCheck.getSelection();
            }
        });
        this.secureCheck.setSelection(true);
        Group socksGroup = new Group(comp, 0);
        socksGroup.setText("SOCKS5");
        socksGroup.setLayout((Layout)UIUtil.formLayout(5, 5));
        socksGroup.setLayoutData((Object)UIUtil.formData(null, -1, parentGroup, 0, null, -1, null, -1));
        this.sock5Check = new Button((Composite)socksGroup, 16416);
        this.sock5Check.setText("SOCKS5");
        this.sock5Check.setLayoutData((Object)UIUtil.formData(0, 0, 0, 5, 100, -5, null, -1));
        this.sock5Check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginDialog2.this.sock5Login = LoginDialog2.this.sock5Check.getSelection();
                LoginDialog2.this.socksAddrCombo.setEnabled(LoginDialog2.this.sock5Login);
            }
        });
        this.sock5Check.setSelection(false);
        Label socks5AddrLabel = new Label((Composite)socksGroup, 131072);
        socks5AddrLabel.setText("SOCKS5 Address :");
        socks5AddrLabel.setLayoutData((Object)UIUtil.formData(null, -1, this.sock5Check, 10, null, -1, null, -1, 100));
        String[] socks5Addrs = ServerPrefUtil.getStoredSocks5ServerList();
        this.socksAddrCombo = new Combo((Composite)socksGroup, 2816);
        if (socks5Addrs != null && socks5Addrs.length > 0) {
            this.socksAddrCombo.setItems(socks5Addrs);
        }
        this.socksAddrCombo.setEnabled(this.sock5Login);
        this.socksAddrCombo.setLayoutData((Object)UIUtil.formData(socks5AddrLabel, 5, this.sock5Check, 10, 100, -5, null, -1, 150));
        Group consoleGroup = new Group(comp, 0);
        consoleGroup.setLayout((Layout)UIUtil.formLayout(5, 5));
        consoleGroup.setLayoutData((Object)UIUtil.formData(null, -1, socksGroup, 0, null, -1, null, -1));
        this.messageList = new List((Composite)consoleGroup, 0);
        this.messageList.setLayoutData((Object)UIUtil.formData(0, 5, 0, 5, 100, -5, null, -1, 250, 60));
        this.messageList.add("Type your authentication info...");
        this.messageList.select(this.messageList.getItemCount() - 1);
        this.messageList.showSelection();
        if (StringUtil.isNotEmpty((String)this.address)) {
            this.addrCombo.setText(this.address);
            server = ServerManager.getInstance().getServer(this.address);
            if (server != null && StringUtil.isNotEmpty((String)server.getUserId())) {
                this.idText.setText(server.getUserId());
                this.secureCheck.setSelection(server.isSecureMode());
            }
            this.autoLoginCheck.setSelection(ServerPrefUtil.isAutoLoginAddress(this.address));
        } else if (this.openType == 991) {
            this.addrCombo.setText("127.0.0.1:6100");
            this.idText.setText("admin");
        }
        if (StringUtil.isNotEmpty((String)this.socksAddress)) {
            this.socksAddrCombo.setText(this.socksAddress);
            this.sock5Check.setSelection(true);
            server = ServerManager.getInstance().getServer(this.address);
            if (server != null && StringUtil.isNotEmpty((String)server.getUserId())) {
                this.idText.setText(server.getUserId());
                this.secureCheck.setSelection(server.isSecureMode());
            }
            this.autoLoginCheck.setSelection(ServerPrefUtil.isAutoLoginAddress(this.address));
        }
        return comp;
    }

    protected Point getInitialLocation(Point initialSize) {
        Monitor primaryMonitor = Display.getDefault().getPrimaryMonitor();
        Rectangle bounds = primaryMonitor.getBounds();
        int x = bounds.x + bounds.width / 2;
        int y = bounds.y + bounds.height / 2;
        return new Point(x, y);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        switch (this.openType) {
            case 991: {
                newShell.setText(Version.getClientFullVersion());
                this.address = ServerPrefUtil.getStoredDefaultServer();
                break;
            }
            case 992: {
                newShell.setText("Add Server");
                break;
            }
            case 993: {
                newShell.setText("Open Server");
                break;
            }
            case 994: {
                newShell.setText("Edit Server");
                break;
            }
            default: {
                newShell.setText("Login");
            }
        }
    }

    protected boolean isResizable() {
        return false;
    }

    private void createPasswordInput(Composite parentGroup) {
        this.passText = new Text(parentGroup, 0x400804);
        this.passText.addFocusListener((FocusListener)new AbstractFocusGainedListener(){

            public void focusGained(FocusEvent e) {
                LoginDialog2.this.passText.selectAll();
            }
        });
        this.passText.setLayoutData((Object)UIUtil.formData(this.passLabel, 5, this.idText, 7, 100, -5, null, -1));
    }

    protected void okPressed() {
        if (this.loginInToServer(this.addrCombo.getText(), this.socksAddrCombo.getText())) {
            super.okPressed();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loginInToServer(String address, String socksAddress) {
        Server server = null;
        if (StringUtil.isEmpty((String)address)) {
            this.errMsg("Please check server address");
            this.msg("");
            return false;
        }
        address = address.trim();
        boolean existServer = false;
        try {
            String ip = null;
            String port = null;
            if (!address.contains(":")) {
                address = address.concat(":6100");
            }
            String[] addr = address.split(":");
            ip = addr[0];
            port = addr[1];
            String socksIp = null;
            String socksPort = null;
            if (this.sock5Login) {
                if (StringUtil.isEmpty((String)socksAddress) || !socksAddress.contains(":")) {
                    this.errMsg("Check SOCKS Address");
                    return false;
                }
                String[] socksAddr = socksAddress.split(":");
                socksIp = socksAddr[0];
                socksPort = socksAddr[1];
            }
            this.msg("Log in..." + address);
            ServerManager srvMgr = ServerManager.getInstance();
            if (this.openType != 994 && srvMgr.isRunningServer(ip, port)) {
                this.errMsg("Already running server");
                this.msg("");
                return false;
            }
            server = new Server(ip, port, null, socksIp, socksPort);
            if (srvMgr.getServer(server.getId()) == null) {
                srvMgr.addServer(server);
            } else {
                existServer = true;
                server = srvMgr.getServer(server.getId());
                server.setSocksIp(socksIp);
                server.setSocksPort(socksPort == null ? 0 : Integer.parseInt(socksPort));
            }
            LoginResult result = LoginMgr.login(server.getId(), this.idText.getText(), this.passText.getText());
            if (result.success) {
                this.msg("Successfully log in to " + address);
                ServerPrefUtil.addServerAddr(address);
                if (this.autoLogin) {
                    ServerPrefUtil.addAutoLoginServer(address, this.idText.getText(), server.getPassword(), socksAddress);
                } else {
                    ServerPrefUtil.removeAutoLoginServer(address);
                }
                this.msg("Completed !!!");
                this.msg("");
                if (this.callback != null) {
                    this.callback.loginSuccess(address, server.getId());
                }
                ThreadUtil.sleep((long)100L);
                return true;
            }
            if (!existServer) {
                ServerManager.getInstance().removeServer(server.getId());
            }
            this.errMsg(result.getErrorMessage());
            this.msg("");
            return false;
        }
        catch (Exception e) {
            if (server != null && !existServer) {
                ServerManager.getInstance().removeServer(server.getId());
            }
            e.printStackTrace();
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)("error occurred:" + e.getMessage()));
            return false;
        }
    }

    private void msg(String msg) {
        this.messageList.add(msg);
        this.messageList.select(this.messageList.getItemCount() - 1);
        this.messageList.showSelection();
    }

    private void errMsg(String msg) {
        this.msg(msg);
    }

    public static interface ILoginDialog {
        public void loginSuccess(String var1, int var2);
    }
}

