/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.text.Collator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import scouter.client.Images;
import scouter.client.group.GroupManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.UIUtil;

public class ManageGroupDialog {
    Display display;
    String groupName;
    String objType;
    IManageGroup callback;
    Set<Integer> noSelectedSet = new HashSet<Integer>();
    Set<Integer> selectedSet = new HashSet<Integer>();

    public ManageGroupDialog(Display display, String groupName, String objType, IManageGroup callback) {
        this.display = display;
        this.groupName = groupName;
        this.objType = objType;
        this.callback = callback;
    }

    public void show() {
        TableItem item;
        Object[] keys;
        final Shell dialog = new Shell(this.display, 67680);
        UIUtil.setDialogDefaultFunctions(dialog);
        dialog.setLayout((Layout)new GridLayout(3, false));
        dialog.setText("Manage Group");
        CLabel title = new CLabel((Composite)dialog, 0);
        GridData gr = new GridData(16384, 0x1000000, true, true, 3, 1);
        title.setLayoutData((Object)gr);
        title.setFont(new Font(null, "Arial", 10, 1));
        title.setImage(Images.getObjectIcon(this.objType, true, 0));
        title.setText(String.valueOf(this.groupName) + "(" + this.getDisplayObjtype(this.objType) + ")");
        final Table allObjects = new Table((Composite)dialog, 2050);
        gr = new GridData(4, 4, true, true);
        gr.widthHint = 250;
        gr.heightHint = 300;
        allObjects.setLayoutData((Object)gr);
        Composite centerComp = new Composite((Composite)dialog, 0);
        gr = new GridData(4, 4, true, true);
        gr.widthHint = 100;
        centerComp.setLayoutData((Object)gr);
        centerComp.setLayout((Layout)new GridLayout(1, true));
        Button addBtn = new Button(centerComp, 8);
        addBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        addBtn.setImage(Images.arrow_right);
        addBtn.setText("Add");
        Button removeBtn = new Button(centerComp, 8);
        removeBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        removeBtn.setImage(Images.arrow_left);
        removeBtn.setText("Remove");
        final Table selectedObjects = new Table((Composite)dialog, 2050);
        gr = new GridData(4, 4, true, true);
        gr.widthHint = 250;
        gr.heightHint = 300;
        selectedObjects.setLayoutData((Object)gr);
        addBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = allObjects.getSelection();
                if (items == null || items.length < 1) {
                    return;
                }
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    TableItem newItem = new TableItem(selectedObjects, 0);
                    newItem.setData(item.getData());
                    newItem.setText(item.getText());
                    newItem.setImage(item.getImage());
                    allObjects.remove(allObjects.indexOf(item));
                    item.dispose();
                    ++i;
                }
                ManageGroupDialog.this.sortTable(allObjects);
                ManageGroupDialog.this.sortTable(selectedObjects);
            }
        });
        removeBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = selectedObjects.getSelection();
                if (items == null || items.length < 1) {
                    return;
                }
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    TableItem newItem = new TableItem(allObjects, 0);
                    newItem.setData(item.getData());
                    newItem.setText(item.getText());
                    newItem.setImage(item.getImage());
                    selectedObjects.remove(selectedObjects.indexOf(item));
                    item.dispose();
                    ++i;
                }
                ManageGroupDialog.this.sortTable(allObjects);
                ManageGroupDialog.this.sortTable(selectedObjects);
            }
        });
        Composite bottomComp = new Composite((Composite)dialog, 0);
        bottomComp.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        bottomComp.setLayout((Layout)UIUtil.formLayout(3, 3));
        Button cancelBtn = new Button(bottomComp, 8);
        cancelBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, 100, -5, null, -1, 100));
        cancelBtn.setText("&Cancel");
        cancelBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                dialog.close();
            }
        });
        Button okBtn = new Button(bottomComp, 8);
        okBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, cancelBtn, -5, null, -1, 100));
        okBtn.setText("&Ok");
        okBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (ManageGroupDialog.this.callback == null) {
                    return;
                }
                TableItem[] selectedItems = selectedObjects.getItems();
                ArrayList<Integer> addedObjHashs = new ArrayList<Integer>();
                TableItem[] tableItemArray = selectedItems;
                int n = selectedItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    int objHash = (Integer)item.getData();
                    if (!ManageGroupDialog.this.selectedSet.contains(objHash)) {
                        addedObjHashs.add(objHash);
                    }
                    ++n2;
                }
                TableItem[] noSelectedItems = allObjects.getItems();
                ArrayList<Integer> removedObjHashs = new ArrayList<Integer>();
                TableItem[] tableItemArray2 = noSelectedItems;
                int n3 = noSelectedItems.length;
                int n4 = 0;
                while (n4 < n3) {
                    TableItem item = tableItemArray2[n4];
                    int objHash = (Integer)item.getData();
                    if (!ManageGroupDialog.this.noSelectedSet.contains(objHash)) {
                        removedObjHashs.add(objHash);
                    }
                    ++n4;
                }
                ManageGroupDialog.this.callback.setResult(ManageGroupDialog.this.groupName, ManageGroupDialog.this.toIntArray(addedObjHashs), ManageGroupDialog.this.toIntArray(removedObjHashs));
                dialog.close();
            }
        });
        Map<Integer, AgentObject> agentMap = AgentModelThread.getInstance().getAgentObjectMap();
        Object[] objectArray = keys = agentMap.keySet().toArray();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            if (key instanceof Integer) {
                int objHash = (Integer)key;
                AgentObject agent = AgentModelThread.getInstance().getAgentObject(objHash);
                if (agent.getObjType().equals(this.objType)) {
                    Set<String> groupSet = GroupManager.getInstance().getObjGroups(objHash);
                    if (groupSet.contains(this.groupName)) {
                        this.selectedSet.add(objHash);
                    } else {
                        this.noSelectedSet.add(objHash);
                    }
                }
            }
            ++n2;
        }
        for (Integer objHash : this.noSelectedSet) {
            AgentObject agent = AgentModelThread.getInstance().getAgentObject(objHash);
            if (agent == null) continue;
            item = new TableItem(allObjects, 0);
            item.setData((Object)objHash);
            item.setText(String.valueOf(agent.getObjName()) + "(" + ServerManager.getInstance().getServer(agent.getServerId()).getName() + ")");
            item.setImage(agent.isAlive() ? Images.active : Images.dead);
        }
        for (Integer objHash : this.selectedSet) {
            AgentObject agent = AgentModelThread.getInstance().getAgentObject(objHash);
            if (agent == null) continue;
            item = new TableItem(selectedObjects, 0);
            item.setData((Object)objHash);
            item.setText(String.valueOf(agent.getObjName()) + "(" + ServerManager.getInstance().getServer(agent.getServerId()).getName() + ")");
            item.setImage(agent.isAlive() ? Images.active : Images.dead);
        }
        this.sortTable(allObjects);
        this.sortTable(selectedObjects);
        dialog.pack();
        dialog.open();
    }

    private String getDisplayObjtype(String objType) {
        Iterator<Integer> itr = ServerManager.getInstance().getOpenServerList().iterator();
        while (itr.hasNext()) {
            Server server = ServerManager.getInstance().getServer(itr.next());
            String displayObjType = server.getCounterEngine().getDisplayNameObjectType(objType);
            if (displayObjType == null) continue;
            return displayObjType;
        }
        return objType;
    }

    public int[] toIntArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = list.get(i);
            ++i;
        }
        return ret;
    }

    private void sortTable(Table table) {
        TableItem[] items = table.getItems();
        Collator collator = Collator.getInstance(Locale.getDefault());
        int i = 1;
        while (i < items.length) {
            String value1 = items[i].getText(0);
            int j = 0;
            while (j < i) {
                String value2 = items[j].getText(0);
                if (collator.compare(value1, value2) < 0) {
                    String text = items[i].getText(0);
                    Object data = items[i].getData();
                    Image image = items[i].getImage();
                    items[i].dispose();
                    TableItem item = new TableItem(table, 0, j);
                    item.setText(text);
                    item.setData(data);
                    item.setImage(image);
                    items = table.getItems();
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public static interface IManageGroup {
        public void setResult(String var1, int[] var2, int[] var3);
    }
}

