/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import scouter.client.Images;
import scouter.client.model.AgentDailyListProxy;
import scouter.client.model.TextProxy;
import scouter.client.popup.CalendarDialog;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.UIUtil;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.ObjectPack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;

public class ObjectCounterDialog {
    public static final String[] HOURLY_TIMES = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"};
    Display display;
    int serverId;
    String objType;
    String from = DateUtil.yyyymmdd();
    String to = DateUtil.yyyymmdd();
    Text fromTxt;
    Text toTxt;
    Combo fromTime;
    Combo toTime;
    Table counterTable;
    Table objTable;
    ICounterObjectCallback callback;
    AgentDailyListProxy agentProxy = new AgentDailyListProxy();

    public ObjectCounterDialog(Display display, int serverId, String objType) {
        this.display = display;
        this.serverId = serverId;
        this.objType = objType;
    }

    public void setCallback(ICounterObjectCallback callback) {
        this.callback = callback;
    }

    public void show() {
        CounterEngine counterEngine = ServerManager.getInstance().getServer(this.serverId).getCounterEngine();
        final Shell dialog = new Shell(this.display, 67696);
        UIUtil.setDialogDefaultFunctions(dialog);
        dialog.setText("Objects & Counters");
        dialog.setLayout((Layout)new GridLayout(1, true));
        Composite mainComp = new Composite((Composite)dialog, 0);
        GridData gr = new GridData(4, 4, true, true);
        gr.widthHint = 700;
        gr.heightHint = 500;
        mainComp.setLayoutData((Object)gr);
        mainComp.setLayout((Layout)new GridLayout(1, true));
        Composite upperComp = new Composite(mainComp, 0);
        upperComp.setLayoutData((Object)new GridData(4, 4, true, false));
        upperComp.setLayout((Layout)new GridLayout(9, false));
        CLabel objTypeLbl = new CLabel(upperComp, 0);
        objTypeLbl.setLayoutData((Object)new GridData(128, 4, true, false));
        objTypeLbl.setAlignment(16384);
        objTypeLbl.setFont(new Font(null, "Arial", 10, 1));
        objTypeLbl.setImage(Images.getObjectIcon(this.objType, true, this.serverId));
        objTypeLbl.setText(counterEngine.getDisplayNameObjectType(this.objType));
        this.fromTxt = new Text(upperComp, 2056);
        gr = new GridData(4, 4, true, false);
        gr.widthHint = 100;
        this.fromTxt.setLayoutData((Object)gr);
        this.fromTxt.setBackground(ColorUtil.getInstance().getColor("white"));
        this.fromTxt.setText(String.valueOf(this.from.substring(0, 4)) + "-" + this.from.substring(4, 6) + "-" + this.from.substring(6, 8));
        Button fromCalBtn = new Button(upperComp, 8);
        fromCalBtn.setLayoutData((Object)new GridData(4, 4, false, false));
        fromCalBtn.setImage(Images.CTXMENU_RDC);
        fromCalBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CalendarDialog(ObjectCounterDialog.this.display, new CalendarDialog.ILoadCalendarDialog(){

                    @Override
                    public void onPressedOk(String date) {
                        (this).ObjectCounterDialog.this.from = date;
                        (this).ObjectCounterDialog.this.fromTxt.setText(String.valueOf(date.substring(0, 4)) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8));
                    }

                    @Override
                    public void onPressedOk(long startTime, long endTime) {
                    }

                    @Override
                    public void onPressedCancel() {
                    }
                }).show(-1, -1, DateUtil.getTime((String)ObjectCounterDialog.this.from, (String)"yyyyMMdd"));
            }
        });
        this.fromTime = new Combo(upperComp, 2568);
        gr = new GridData(4, 4, true, false);
        gr.widthHint = 50;
        this.fromTime.setLayoutData((Object)gr);
        this.fromTime.setItems(HOURLY_TIMES);
        this.fromTime.select(0);
        Label label = new Label(upperComp, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setAlignment(0x1000000);
        label.setText("~");
        this.toTxt = new Text(upperComp, 2056);
        gr = new GridData(4, 4, true, false);
        gr.widthHint = 100;
        this.toTxt.setLayoutData((Object)gr);
        this.toTxt.setBackground(ColorUtil.getInstance().getColor("white"));
        this.toTxt.setText(String.valueOf(this.to.substring(0, 4)) + "-" + this.to.substring(4, 6) + "-" + this.to.substring(6, 8));
        Button toCalBtn = new Button(upperComp, 8);
        toCalBtn.setLayoutData((Object)new GridData(4, 4, false, false));
        toCalBtn.setImage(Images.CTXMENU_RDC);
        toCalBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CalendarDialog(ObjectCounterDialog.this.display, new CalendarDialog.ILoadCalendarDialog(){

                    @Override
                    public void onPressedOk(String date) {
                        (this).ObjectCounterDialog.this.to = date;
                        (this).ObjectCounterDialog.this.toTxt.setText(String.valueOf(date.substring(0, 4)) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8));
                    }

                    @Override
                    public void onPressedOk(long startTime, long endTime) {
                    }

                    @Override
                    public void onPressedCancel() {
                    }
                }).show(-1, -1, DateUtil.getTime((String)ObjectCounterDialog.this.to, (String)"yyyyMMdd"));
            }
        });
        this.toTime = new Combo(upperComp, 2568);
        gr = new GridData(4, 4, true, false);
        gr.widthHint = 50;
        this.toTime.setLayoutData((Object)gr);
        this.toTime.setItems(HOURLY_TIMES);
        this.toTime.select(HOURLY_TIMES.length - 1);
        Button getBtn = new Button(upperComp, 8);
        gr = new GridData(4, 4, true, false);
        gr.widthHint = 120;
        getBtn.setLayoutData((Object)gr);
        getBtn.setText("Get Object List");
        getBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectCounterDialog.this.queryObjSet();
            }
        });
        Composite tableComp = new Composite(mainComp, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComp.setLayout((Layout)new GridLayout(2, true));
        final Button counterBtn = new Button(tableComp, 32);
        gr = new GridData(16384, 4, true, false);
        gr.horizontalIndent = 8;
        counterBtn.setLayoutData((Object)gr);
        counterBtn.setText(" Counter List");
        counterBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = ObjectCounterDialog.this.counterTable.getItems();
                if (items != null) {
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        item.setChecked(counterBtn.getSelection());
                        ++n2;
                    }
                }
            }
        });
        final Button objBtn = new Button(tableComp, 32);
        gr = new GridData(16384, 4, true, false);
        gr.horizontalIndent = 8;
        objBtn.setLayoutData((Object)gr);
        objBtn.setText(" Object List");
        objBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = ObjectCounterDialog.this.objTable.getItems();
                if (items != null) {
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        item.setChecked(objBtn.getSelection());
                        ++n2;
                    }
                }
            }
        });
        this.counterTable = new Table(tableComp, 2848);
        this.counterTable.setLayoutData((Object)new GridData(4, 4, true, true));
        ArrayList counters = counterEngine.getAllCounterList(this.objType);
        if (counters != null) {
            Collections.sort(counters);
            for (String counter : counters) {
                TableItem item = new TableItem(this.counterTable, 0);
                item.setText(counterEngine.getCounterDisplayName(this.objType, counter));
                item.setData((Object)counter);
            }
        }
        this.objTable = new Table(tableComp, 2848);
        this.objTable.setLayoutData((Object)new GridData(4, 4, true, true));
        Button okBtn = new Button(mainComp, 8);
        gr = new GridData(131072, 4, true, false);
        gr.widthHint = 100;
        okBtn.setLayoutData((Object)gr);
        okBtn.setText("&Ok");
        okBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectCounterDialog.this.callback != null) {
                    TableItem[] items = ObjectCounterDialog.this.objTable.getItems();
                    ArrayList<ObjectPack> objList = new ArrayList<ObjectPack>();
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getChecked()) {
                            ObjectPack pack = new ObjectPack();
                            pack.objHash = (Integer)item.getData();
                            pack.objName = item.getText();
                            pack.objType = ObjectCounterDialog.this.objType;
                            objList.add(pack);
                        }
                        ++n2;
                    }
                    items = ObjectCounterDialog.this.counterTable.getItems();
                    ArrayList<String> counterList = new ArrayList<String>();
                    TableItem[] tableItemArray2 = items;
                    int n3 = items.length;
                    n = 0;
                    while (n < n3) {
                        TableItem item = tableItemArray2[n];
                        if (item.getChecked()) {
                            counterList.add((String)item.getData());
                        }
                        ++n;
                    }
                    long stime = DateUtil.yyyymmdd((String)ObjectCounterDialog.this.from) + CastUtil.clong((Object)ObjectCounterDialog.this.fromTime.getText()) * 3600000L;
                    long etime = DateUtil.yyyymmdd((String)ObjectCounterDialog.this.to) + CastUtil.clong((Object)ObjectCounterDialog.this.toTime.getText()) * 3600000L;
                    ObjectCounterDialog.this.callback.completeSelection(stime, etime, objList, counterList);
                }
                dialog.close();
            }
        });
        getBtn.notifyListeners(13, new Event());
        dialog.setDefaultButton(okBtn);
        dialog.pack();
        dialog.open();
    }

    private void queryObjSet() {
        long stime = DateUtil.yyyymmdd((String)this.from);
        long etime = DateUtil.yyyymmdd((String)this.to);
        HashMap<String, ListValue> valueMap = new HashMap<String, ListValue>();
        while (stime <= etime) {
            String date = DateUtil.yyyymmdd((long)stime);
            ListValue lv = this.agentProxy.getObjHashLv(date, this.serverId, this.objType);
            valueMap.put(date, lv);
            stime += 86400000L;
        }
        this.objTable.removeAll();
        Set dateSet = valueMap.keySet();
        HashSet<Integer> alreadySet = new HashSet<Integer>();
        for (String date : dateSet) {
            ListValue lv = (ListValue)valueMap.get(date);
            int i = 0;
            while (i < lv.size()) {
                int objHash = (int)lv.getLong(i);
                if (!alreadySet.contains(objHash)) {
                    alreadySet.add(objHash);
                    String objName = TextProxy.object.getLoadText(date, objHash, this.serverId);
                    TableItem item = new TableItem(this.objTable, 0);
                    item.setText(objName);
                    item.setData((Object)objHash);
                }
                ++i;
            }
        }
        this.sortTable(this.objTable);
    }

    private void sortTable(Table table) {
        TableItem[] items = table.getItems();
        Collator collator = Collator.getInstance(Locale.getDefault());
        int i = 1;
        while (i < items.length) {
            String value1 = items[i].getText(0);
            int j = 0;
            while (j < i) {
                String value2 = items[j].getText(0);
                if (collator.compare(value1, value2) < 0) {
                    String text = items[i].getText(0);
                    boolean checked = items[i].getChecked();
                    Object data = items[i].getData();
                    items[i].dispose();
                    TableItem item = new TableItem(table, 0, j);
                    item.setText(text);
                    item.setChecked(checked);
                    item.setData(data);
                    items = table.getItems();
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public static interface ICounterObjectCallback {
        public void completeSelection(long var1, long var3, List<ObjectPack> var5, List<String> var6);
    }
}

