/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import scouter.client.model.AgentColorManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.PropertyData;
import scouter.client.net.TcpProxy;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.UIUtil;
import scouter.lang.ObjectType;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.Pack;
import scouter.util.CastUtil;
import scouter.util.FormatUtil;

public class ObjectPropertiesDialog {
    private final Display display;
    private Shell dialog;
    private final int objHash;
    private int serverId;
    private ObjectPack objectPack;
    private TableViewer propertyTableViewer;
    private TableColumnLayout tableColumnLayout;
    ArrayList<PropertyData> propertyList = new ArrayList();

    public ObjectPropertiesDialog(Display display, int objHash, int serverId) {
        this.display = display;
        this.objHash = objHash;
        this.serverId = serverId;
    }

    public void show() {
        this.dialog = this.setDialogLayout();
        UIUtil.setDialogDefaultFunctions(this.dialog);
        this.findObjectPack();
        this.makeTableContents();
    }

    public void show(final String date) {
        this.dialog = this.setDialogLayout();
        UIUtil.setDialogDefaultFunctions(this.dialog);
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                ObjectPack objectPack;
                block5: {
                    objectPack = null;
                    TcpProxy proxy = TcpProxy.getTcpProxy(ObjectPropertiesDialog.this.serverId);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("date", date);
                            param.put("objHash", (long)ObjectPropertiesDialog.this.objHash);
                            objectPack = (ObjectPack)proxy.getSingle("OBJECT_INFO", (Pack)param);
                            CounterEngine counterEngine = ServerManager.getInstance().getServer(ObjectPropertiesDialog.this.serverId).getCounterEngine();
                            String code = counterEngine.getMasterCounter(objectPack.objType);
                            objectPack.tags.put("main counter", code);
                        }
                        catch (Throwable t) {
                            ConsoleProxy.errorSafe(t.toString());
                            TcpProxy.putTcpProxy(proxy);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(proxy);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(proxy);
                }
                ObjectPropertiesDialog.this.objectPack = objectPack;
                ExUtil.exec((Composite)ObjectPropertiesDialog.this.propertyTableViewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        ObjectPropertiesDialog.this.makeTableContents();
                    }
                });
            }
        });
    }

    private Shell setDialogLayout() {
        Shell dialog = new Shell(this.display, 2160);
        dialog.setText("Properties");
        dialog.setLayout((Layout)new FillLayout());
        Composite tableComposite = new Composite((Composite)dialog, 0);
        this.initialTable(tableComposite);
        return dialog;
    }

    private void findObjectPack() {
        ArrayList<ObjectPack> packList = AgentModelThread.getInstance().getAgentPackList();
        for (ObjectPack objectPack : packList) {
            if (objectPack.objHash != this.objHash) continue;
            CounterEngine counterEngine = ServerManager.getInstance().getServer(this.serverId).getCounterEngine();
            String code = counterEngine.getMasterCounter(objectPack.objType);
            objectPack.tags.put("main counter", code);
            this.objectPack = objectPack;
            break;
        }
    }

    private void makeTableContents() {
        if (this.objectPack == null) {
            return;
        }
        CounterEngine counterEngine = ServerManager.getInstance().getServer(this.serverId).getCounterEngine();
        ObjectType type = counterEngine.getObjectType(this.objectPack.objType);
        this.propertyList.clear();
        this.propertyList.add(new PropertyData("objectName", this.objectPack.objName));
        this.propertyList.add(new PropertyData("objectType", this.objectPack.objType));
        this.propertyList.add(new PropertyData("family", type == null ? "undefined" : type.getFamily().getName()));
        this.propertyList.add(new PropertyData("address", this.objectPack.address));
        this.propertyList.add(new PropertyData("version", this.objectPack.version));
        this.propertyList.add(new PropertyData("alive", String.valueOf(this.objectPack.alive)));
        this.propertyList.add(new PropertyData("wakeUp", FormatUtil.print((Object)new Date(this.objectPack.wakeup), (String)"yyyyMMdd HH:mm:ss.SSS")));
        this.propertyList.add(new PropertyData("color", AgentColorManager.getInstance().assignColor(this.objectPack.objType, this.objHash)));
        for (String key : this.objectPack.tags.keySet()) {
            this.propertyList.add(new PropertyData(key, CastUtil.cString((Object)this.objectPack.tags.get(key))));
        }
        this.propertyTableViewer.refresh();
        this.dialog.pack();
        this.dialog.open();
    }

    private void initialTable(Composite composite) {
        this.propertyTableViewer = new TableViewer(composite, 2050);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        TableViewerColumn cdummy = this.createTableViewerDummyColumn("", 0, 4, true, true);
        cdummy.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }
        });
        TableViewerColumn c = this.createTableViewerColumn("Property", 150, 4, true, true);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String property;
                if (element instanceof PropertyData && (property = ((PropertyData)element).property) instanceof String) {
                    return property;
                }
                return null;
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        c = this.createTableViewerColumn("Value", 300, 4, true, true);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PropertyData) {
                    Object value = ((PropertyData)element).value;
                    if (value instanceof String) {
                        return (String)value;
                    }
                    if (value instanceof Color) {
                        Color color = (Color)value;
                        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
                    }
                }
                return null;
            }

            public Image getImage(Object element) {
                Object value;
                if (element instanceof PropertyData && (value = ((PropertyData)element).value) instanceof Color) {
                    Image im = new Image((Device)Display.getCurrent(), 20, 12);
                    GC gc = new GC((Drawable)im);
                    gc.setBackground((Color)value);
                    gc.fillRectangle(8, 1, 10, 10);
                    gc.setForeground(ColorUtil.getInstance().getColor(2));
                    gc.drawRectangle(8, 1, 10, 10);
                    gc.dispose();
                    return im;
                }
                return null;
            }
        });
        Table table = this.propertyTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.propertyTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.propertyTableViewer.setInput(this.propertyList);
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.propertyTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(30, width, resizable));
        return viewerColumn;
    }

    private TableViewerColumn createTableViewerDummyColumn(String title, int width, int alignment, boolean resizable, boolean moveable) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.propertyTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(0, width, false));
        return viewerColumn;
    }
}

