/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import scouter.client.Images;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.GroupObject;
import scouter.client.model.HierarchyObject;
import scouter.client.model.ServerObject;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.threads.ObjectSelectManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.UIUtil;
import scouter.lang.counters.CounterEngine;

public class ObjectSelectionDialog {
    public CheckboxTreeViewer objTreeViewer;
    private Map<String, ServerObject> root = new TreeMap<String, ServerObject>();
    ObjectSelectManager objSelMgr = ObjectSelectManager.getInstance();
    Set<Integer> objHashSet = new HashSet<Integer>();

    public void show() {
        Shell dialog = new Shell(Display.getDefault(), 67696);
        UIUtil.setDialogDefaultFunctions(dialog);
        dialog.setText("Filter Object");
        this.createPartControl(dialog);
        this.makeTreeContents();
        dialog.pack();
        dialog.open();
    }

    private void createPartControl(final Shell dialog) {
        dialog.setLayout((Layout)new GridLayout(1, true));
        Composite mainComposite = new Composite((Composite)dialog, 0);
        GridData gr = new GridData(4, 4, true, true);
        gr.widthHint = 500;
        gr.heightHint = 400;
        mainComposite.setLayoutData((Object)gr);
        this.objTreeViewer = new CheckboxTreeViewer(mainComposite, 0x10000B00);
        Tree objTree = this.objTreeViewer.getTree();
        objTree.setHeaderVisible(true);
        objTree.setLinesVisible(false);
        TreeColumn column1 = new TreeColumn(objTree, 16384);
        column1.setAlignment(16384);
        column1.setText("Type/Object");
        TreeColumnLayout layout = new TreeColumnLayout();
        mainComposite.setLayout((Layout)layout);
        layout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(100));
        this.objTreeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.objTreeViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.objTreeViewer.setCheckStateProvider((ICheckStateProvider)new TreeCheckStateProvider());
        this.objTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ObjectSelectionDialog.this.objTreeViewer.setSubtreeChecked(event.getElement(), event.getChecked());
            }
        });
        this.objTreeViewer.setInput(this.root);
        Composite bottomComp = new Composite((Composite)dialog, 0);
        gr = new GridData(4, 4, false, true);
        bottomComp.setLayoutData((Object)gr);
        bottomComp.setLayout((Layout)UIUtil.formLayout(0, 0));
        Button cancelBtn = new Button(bottomComp, 8);
        cancelBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 5, 100, -5, null, -1, 100));
        cancelBtn.setText("&Cancel");
        cancelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dialog.close();
            }
        });
        Button okBtn = new Button(bottomComp, 8);
        okBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 5, cancelBtn, -5, null, -1, 100));
        okBtn.setText("&Apply");
        okBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] checkedElements = ObjectSelectionDialog.this.objTreeViewer.getCheckedElements();
                HashSet<Integer> checkdObjHashSet = new HashSet<Integer>();
                Object[] objectArray = checkedElements;
                int n = checkedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof AgentObject) {
                        AgentObject a = (AgentObject)o;
                        checkdObjHashSet.add(a.getObjHash());
                    }
                    ++n2;
                }
                ObjectSelectionDialog.this.objHashSet.removeAll(checkdObjHashSet);
                ObjectSelectionDialog.this.objSelMgr.addAll(ObjectSelectionDialog.this.objHashSet);
                dialog.close();
            }
        });
    }

    private void makeTreeContents() {
        AgentObject[] objectList;
        Set<Integer> sIds = ServerManager.getInstance().getOpenServerList();
        for (int serverId : sIds) {
            String serverName = ServerManager.getInstance().getServer(serverId).getName();
            ServerObject serverObj = new ServerObject(serverId, serverName);
            this.root.put(serverName, serverObj);
        }
        AgentObject[] agentObjectArray = objectList = AgentModelThread.getInstance().getObjectList();
        int n = objectList.length;
        int n2 = 0;
        while (n2 < n) {
            AgentObject agent = agentObjectArray[n2];
            int serverId = agent.getServerId();
            String serverName = ServerManager.getInstance().getServer(serverId).getName();
            ServerObject serverObj = this.root.get(serverName);
            if (serverObj != null) {
                AgentObject obj = new AgentObject(agent);
                this.objHashSet.add(obj.getObjHash());
                HierarchyObject grpObj = serverObj.getChild(obj.getObjType());
                CounterEngine engine = ServerManager.getInstance().getServer(serverId).getCounterEngine();
                if (grpObj == null) {
                    grpObj = new GroupObject(obj.getObjType(), String.valueOf(serverName) + "/" + engine.getDisplayNameObjectType(obj.getObjType()));
                    serverObj.putChild(obj.getObjType(), grpObj);
                    grpObj.setParent(serverObj);
                }
                grpObj.putChild(obj.getObjName(), obj);
                obj.setParent(grpObj);
            }
            ++n2;
        }
        this.objTreeViewer.refresh();
        this.objTreeViewer.expandAll();
    }

    class TableLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object obj, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (obj instanceof AgentObject) {
                        AgentObject a = (AgentObject)obj;
                        return a.isAlive() ? Images.active : Images.dead;
                    }
                    if (obj instanceof ServerObject) {
                        ServerObject a = (ServerObject)obj;
                        Server server = ServerManager.getInstance().getServer(a.getId());
                        boolean isConnected = server.isConnected();
                        if (ServerManager.getInstance().getDefaultServer() == server) {
                            if (isConnected) {
                                return Images.SERVER_DEFAULT_ACT;
                            }
                            return Images.SERVER_DEFAULT_INACT;
                        }
                        if (isConnected) {
                            return Images.SERVER_ACT;
                        }
                        return Images.SERVER_INACT;
                    }
                    if (obj instanceof GroupObject) {
                        GroupObject grpObj = (GroupObject)obj;
                        HierarchyObject parent = grpObj.getParent();
                        if (parent != null && parent instanceof ServerObject) {
                            return Images.getObjectIcon(grpObj.getObjType(), true, ((ServerObject)parent).getId());
                        }
                        return Images.getObjectIcon(grpObj.getObjType(), true, 0);
                    }
                    return Images.default_context;
                }
            }
            return null;
        }

        public String getColumnText(Object obj, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (obj instanceof AgentObject) {
                        AgentObject a = (AgentObject)obj;
                        String display = a.getObjName();
                        return display;
                    }
                    if (obj instanceof ServerObject) {
                        ServerObject a = (ServerObject)obj;
                        return a.getName();
                    }
                    if (obj instanceof GroupObject) {
                        GroupObject a = (GroupObject)obj;
                        String name = a.getName();
                        int index = name.indexOf("/");
                        if (index > -1) {
                            return name.substring(index + 1, name.length());
                        }
                        return name;
                    }
                    return obj.toString();
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getForeground(Object obj) {
            AgentObject a;
            if (obj instanceof AgentObject && !(a = (AgentObject)obj).isAlive()) {
                return ColorUtil.getInstance().getColor("gray");
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    class TreeCheckStateProvider
    implements ICheckStateProvider {
        TreeCheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            if (element instanceof AgentObject) {
                return !ObjectSelectionDialog.this.objSelMgr.isUnselectedObject(((AgentObject)element).getObjHash());
            }
            return false;
        }

        public boolean isGrayed(Object element) {
            return !(element instanceof AgentObject);
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof Map) {
                return ((Map)parent).values().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof HierarchyObject) {
                return ((HierarchyObject)parentElement).getSortedChildArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof HierarchyObject) {
                return ((HierarchyObject)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof HierarchyObject) {
                return ((HierarchyObject)element).getChildSize() > 0;
            }
            return false;
        }

        public boolean equals(Object obj) {
            return true;
        }
    }
}

