/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.util.ArrayList;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import scouter.client.net.TcpProxy;
import scouter.client.util.ChartUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.UIUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;

public class RedefineClassDialog {
    private final Display display;
    private Shell dialog;
    Text addClassTxt;
    int objHash;
    private int selected = -1;
    private Table table = null;

    public RedefineClassDialog(Display display) {
        this.display = display;
    }

    public void show(int objHash, String value, int serverId, Rectangle r) {
        if (value == null || "".equals(value)) {
            return;
        }
        this.objHash = objHash;
        this.dialog = this.setDialogLayout(serverId);
        this.dialog.pack();
        this.dialog.setLocation(r.x + 100, r.y + 100);
        String[] classes = value.split(",");
        int inx = 0;
        while (inx < classes.length) {
            String classNm = classes[inx].trim();
            if (classNm != null && !"".equals(classNm)) {
                this.createTableRow(this.table, classNm);
            }
            ++inx;
        }
        this.dialog.open();
    }

    public void close() {
        if (!this.dialog.isDisposed()) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private Shell setDialogLayout(int serverId) {
        TableColumn[] cols;
        final int servId = serverId;
        Shell dialog = new Shell(this.display, 67696);
        dialog.setText("Redefine Classes");
        dialog.setLayout((Layout)UIUtil.formLayout(5, 5));
        Label label = new Label((Composite)dialog, 131072);
        label.setText("Class Name : ");
        label.setLayoutData((Object)UIUtil.formData(null, -1, 0, 2, null, -1, null, -1, 100));
        this.addClassTxt = new Text((Composite)dialog, 2052);
        this.addClassTxt.setLayoutData((Object)UIUtil.formData(label, 10, 0, 2, null, -1, null, -1, 310));
        this.addClassTxt.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    RedefineClassDialog.this.close();
                } else if (e.keyCode == 13) {
                    String newClassNm = RedefineClassDialog.this.addClassTxt.getText();
                    if (newClassNm != null && !"".equals(newClassNm)) {
                        RedefineClassDialog.this.createTableRow(RedefineClassDialog.this.table, newClassNm);
                    }
                    RedefineClassDialog.this.addClassTxt.setText("");
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Button addClassBtn = new Button((Composite)dialog, 8);
        addClassBtn.setLayoutData((Object)UIUtil.formData(this.addClassTxt, 10, null, -1, null, -1, null, -1, 70));
        addClassBtn.setText("Add");
        addClassBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        String newClassNm = RedefineClassDialog.this.addClassTxt.getText();
                        if (newClassNm != null && !"".equals(newClassNm)) {
                            RedefineClassDialog.this.createTableRow(RedefineClassDialog.this.table, newClassNm);
                        }
                        RedefineClassDialog.this.addClassTxt.setText("");
                    }
                }
            }
        });
        Label listLabel = new Label((Composite)dialog, 131072);
        listLabel.setText("Class Names : ");
        listLabel.setLayoutData((Object)UIUtil.formData(null, -1, label, 12, null, -1, null, -1, 100));
        this.table = new Table((Composite)dialog, 68416);
        this.table.setLayoutData((Object)UIUtil.formData(listLabel, 10, label, 12, null, -1, null, -1, 300, 150));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayout((Layout)ChartUtil.gridlayout(1));
        cols = new TableColumn[]{UIUtil.create(this.table, 16384, "Class Name", cols.length, 0, false, 310)};
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableItem[] selection = RedefineClassDialog.this.table.getSelection();
                if (selection.length < 0) {
                    return;
                }
                RedefineClassDialog.this.selected = RedefineClassDialog.this.table.getSelectionIndex();
            }
        });
        Button removeBtn = new Button((Composite)dialog, 8);
        removeBtn.setLayoutData((Object)UIUtil.formData(this.addClassTxt, 10, label, 12, null, -1, null, -1, 70));
        removeBtn.setText("Remove");
        removeBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (RedefineClassDialog.this.selected == -1) break;
                        RedefineClassDialog.this.table.remove(RedefineClassDialog.this.selected);
                        RedefineClassDialog.this.selected = -1;
                    }
                }
            }
        });
        Button redefineBtn = new Button((Composite)dialog, 8);
        redefineBtn.setLayoutData((Object)UIUtil.formData(null, -1, this.table, 10, 100, 0, null, -1, 200));
        redefineBtn.setText("Redefine class");
        redefineBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        TableItem[] items = RedefineClassDialog.this.table.getItems();
                        if (items == null || items.length <= 0) {
                            return;
                        }
                        ArrayList<String> classNames = new ArrayList<String>();
                        int i = 0;
                        while (i < items.length) {
                            classNames.add(items[i].getText(0));
                            ++i;
                        }
                        String newClassNm = RedefineClassDialog.this.addClassTxt.getText();
                        if (newClassNm != null && !"".equals(newClassNm)) {
                            classNames.add(newClassNm);
                        }
                        RedefineClassDialog.this.requestRedefineClass(classNames, servId);
                        RedefineClassDialog.this.close();
                    }
                }
            }
        });
        this.addClassTxt.selectAll();
        this.addClassTxt.setFocus();
        return dialog;
    }

    private void requestRedefineClass(ArrayList<String> classes, int serverId) {
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            try {
                MapPack param = new MapPack();
                param.put("objHash", (long)this.objHash);
                ListValue classNames = param.newList("classNames");
                int inx = 0;
                while (inx < classes.size()) {
                    classNames.add(classes.get(inx));
                    ++inx;
                }
                MapPack mapPack = (MapPack)tcp.getSingle("REDEFINE_CLASSES", (Pack)param);
            }
            catch (Exception e) {
                ConsoleProxy.errorSafe(e.toString());
                TcpProxy.putTcpProxy(tcp);
            }
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
    }

    private void createTableRow(Table table, String clsNm) {
        TableItem t = new TableItem(table, 0, 0);
        t.setText(new String[]{clsNm});
    }

    private Table build(Composite parent) {
        TableColumn[] cols;
        Table table = new Table(parent, 68416);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        cols = new TableColumn[]{UIUtil.create(table, 16384, "Class Name", cols.length, 0, false, 200)};
        return table;
    }
}

