/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.hibernate.jdbc.util.BasicFormatterImpl;
import scouter.client.util.SqlFormatUtil;
import scouter.client.util.SqlMakerUtil;
import scouter.client.util.UIUtil;
import scouter.util.StringUtil;

public class SQLFormatDialog {
    public void show(String message, String error) {
        this.show(message, error, null);
    }

    public void show(final String message, String error, final String params) {
        final Shell dialog = new Shell(Display.getDefault(), 67696);
        UIUtil.setDialogDefaultFunctions(dialog);
        dialog.setText("SQL");
        dialog.setLayout((Layout)new GridLayout(1, true));
        StyledText errorTxt = new StyledText((Composite)dialog, 2114);
        GridData gr = new GridData(4, 4, true, false);
        errorTxt.setLayoutData((Object)gr);
        gr.exclude = true;
        errorTxt.setVisible(false);
        if (error != null) {
            gr.exclude = false;
            errorTxt.setVisible(true);
            errorTxt.setText(error);
            StyleRange sr = new StyleRange();
            sr.foreground = Display.getCurrent().getSystemColor(3);
            sr.start = 0;
            sr.length = error.length();
            errorTxt.setStyleRange(sr);
        }
        final StyledText text = new StyledText((Composite)dialog, 2626);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 700;
        gd.heightHint = 500;
        text.setLayoutData((Object)gd);
        if (params == null) {
            SqlFormatUtil.applyStyledFormat(text, message);
        } else {
            SqlFormatUtil.applyStyledFormat(text, SqlMakerUtil.bindSQL(message, params));
        }
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && (e.keyCode == 97 || e.keyCode == 65)) {
                    text.selectAll();
                }
            }
        });
        Composite bottomComp = new Composite((Composite)dialog, 0);
        bottomComp.setLayoutData((Object)new GridData(4, 4, true, false));
        bottomComp.setLayout((Layout)UIUtil.formLayout(3, 3));
        Button btn = new Button(bottomComp, 8);
        btn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, 100, -5, null, -1, 100));
        btn.setText("&Close");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dialog.close();
            }
        });
        final Button formatBtn = new Button(bottomComp, 8);
        formatBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, btn, -5, null, -1, 100));
        formatBtn.setText("&Format");
        formatBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                formatBtn.setEnabled(false);
                String inputSQL = text.getText();
                String bindVariables = null;
                int search = -1;
                if (inputSQL != null && (search = inputSQL.indexOf(SqlMakerUtil.SQLDIVIDE)) >= 0) {
                    bindVariables = inputSQL.substring(search);
                    inputSQL = inputSQL.substring(0, search);
                }
                String formateed = new BasicFormatterImpl().format(inputSQL);
                if (search >= 0) {
                    formateed = String.valueOf(formateed) + bindVariables;
                }
                text.setText(formateed);
                formatBtn.setEnabled(true);
            }
        });
        Button copyBtn = new Button(bottomComp, 8);
        copyBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, formatBtn, -5, null, -1, 100));
        copyBtn.setText("&Copy");
        copyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents((Object[])new String[]{text.getText()}, new Transfer[]{textTransfer});
                clipboard.dispose();
                MessageDialog.openInformation((Shell)dialog, (String)"Copy", (String)"Copied to clipboard");
            }
        });
        Button bindBtn = new Button(bottomComp, 8);
        bindBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, copyBtn, -5, null, -1, 100));
        bindBtn.setText("&Bind");
        bindBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                text.setText(SqlMakerUtil.replaceSQLParameter(message, params));
            }
        });
        if (StringUtil.isEmpty((String)params)) {
            bindBtn.setEnabled(false);
        }
        dialog.pack();
        dialog.open();
    }
}

