/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import scouter.client.Images;
import scouter.client.popup.AddServerAddressDialog;
import scouter.client.popup.LoginDialog2;
import scouter.client.preferences.ServerPrefUtil;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.UIUtil;

public class ServerManagerDialog
implements AddServerAddressDialog.ServerAddressAddition,
LoginDialog2.ILoginDialog {
    Table table;
    Set<String> addrSet = new HashSet<String>();

    public void show() {
        final Shell dialog = new Shell(Display.getDefault(), 2144);
        UIUtil.setDialogDefaultFunctions(dialog);
        dialog.setLayout((Layout)new GridLayout(2, false));
        dialog.setText("Server");
        CLabel title = new CLabel((Composite)dialog, 0);
        GridData gr = new GridData(16384, 0x1000000, true, true, 2, 1);
        title.setLayoutData((Object)gr);
        title.setFont(new Font(null, "Arial", 10, 1));
        title.setImage(Images.SERVER_ACT);
        title.setText("Server List");
        this.table = new Table((Composite)dialog, 2816);
        gr = new GridData(4, 4, true, true);
        gr.widthHint = 250;
        gr.heightHint = 350;
        this.table.setLayoutData((Object)gr);
        Composite buttonComp = new Composite((Composite)dialog, 0);
        gr = new GridData(4, 4, false, true);
        buttonComp.setLayoutData((Object)gr);
        buttonComp.setLayout((Layout)UIUtil.formLayout(3, 3));
        Button addBtn = new Button(buttonComp, 8);
        addBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 5, null, -1, null, -1, 100));
        addBtn.setText("&Add");
        addBtn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                new AddServerAddressDialog(e.widget.getDisplay(), ServerManagerDialog.this, ServerManagerDialog.this.addrSet).show(e.widget.getDisplay().getBounds());
            }
        });
        Button importBtn = new Button(buttonComp, 8);
        importBtn.setLayoutData((Object)UIUtil.formData(null, -1, addBtn, 5, null, -1, null, -1, 100));
        importBtn.setText("&Import");
        importBtn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Shell shell = new Shell(e.widget.getDisplay());
                FileDialog fileDialog = new FileDialog(shell);
                fileDialog.setFilterExtensions(new String[]{"*.tns"});
                fileDialog.setFilterNames(new String[]{"Server List File(*.tns)"});
                final String path = fileDialog.open();
                if (path != null && !"".equals(path)) {
                    ExUtil.asyncRun(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BufferedReader br = new BufferedReader(new FileReader(path));
                                String s = null;
                                final HashSet<String> addedSet = new HashSet<String>();
                                while ((s = br.readLine()) != null) {
                                    if ((this).ServerManagerDialog.this.addrSet.contains(s)) continue;
                                    try {
                                        String[] str = s.split(":");
                                        if (str == null || str.length != 2) continue;
                                        addedSet.add(s);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                ExUtil.exec(Display.getDefault(), new Runnable(){

                                    @Override
                                    public void run() {
                                        for (String newAddress : addedSet) {
                                            ServerManagerDialog.this.addServerAddress(newAddress);
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        });
        final Button authBtn = new Button(buttonComp, 8);
        authBtn.setLayoutData((Object)UIUtil.formData(null, -1, importBtn, 10, null, -1, null, -1, 100));
        authBtn.setText("&Auth.");
        authBtn.setEnabled(false);
        authBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = ServerManagerDialog.this.table.getSelection();
                if (items != null && items.length > 0) {
                    String addr = (String)items[0].getData();
                    String socksAddr = ServerPrefUtil.getStoredSocksServer(addr);
                    if (items[0].getForeground().getRGB().equals((Object)ColorUtil.getInstance().getColor(3).getRGB())) {
                        LoginDialog2 loginDialog = new LoginDialog2(dialog, ServerManagerDialog.this, 992, addr, socksAddr);
                        loginDialog.open();
                    } else {
                        LoginDialog2 loginDialog = new LoginDialog2(dialog, ServerManagerDialog.this, 994, addr, socksAddr);
                        loginDialog.open();
                    }
                }
            }
        });
        Composite bottomComp = new Composite((Composite)dialog, 0);
        bottomComp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        bottomComp.setLayout((Layout)UIUtil.formLayout(3, 3));
        Button cancelBtn = new Button(bottomComp, 8);
        cancelBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, 100, -5, null, -1, 100));
        cancelBtn.setText("&Cancel");
        cancelBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                dialog.close();
            }
        });
        Button okBtn = new Button(bottomComp, 8);
        okBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, cancelBtn, -5, null, -1, 100));
        okBtn.setText("&Ok");
        okBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items;
                TableItem[] tableItemArray = items = ServerManagerDialog.this.table.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getForeground().getRGB().equals((Object)ColorUtil.getInstance().getColor(3).getRGB())) {
                        String addr = (String)item.getData();
                        ServerPrefUtil.addServerAddr(addr);
                        String[] addrs = addr.split(":");
                        Server server = new Server(addrs[0], addrs[1]);
                        ServerManager.getInstance().addServer(server);
                    }
                    ++n2;
                }
                dialog.close();
            }
        });
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    authBtn.setEnabled(true);
                    return;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Enumeration<Integer> allServerSet = ServerManager.getInstance().getAllServerList();
        while (allServerSet.hasMoreElements()) {
            int serverId = allServerSet.nextElement();
            Server server = ServerManager.getInstance().getServer(serverId);
            if (server == null) continue;
            TableItem item = new TableItem(this.table, 0);
            String str = String.valueOf(server.getIp()) + ":" + server.getPort();
            item.setData((Object)str);
            this.addrSet.add(str);
            if (server.isOpen()) {
                str = String.valueOf(str) + " (" + server.getName() + ")";
                str = server.isConnected() ? String.valueOf(str) + " - Running" : String.valueOf(str) + " - Disconnected";
            } else {
                str = String.valueOf(str) + " - Closed";
            }
            item.setText(str);
        }
        dialog.pack();
        dialog.open();
    }

    @Override
    public void addServerAddress(String newAddress) {
        TableItem item = new TableItem(this.table, 0);
        item.setForeground(ColorUtil.getInstance().getColor(3));
        item.setData((Object)newAddress);
        item.setText(newAddress);
        this.addrSet.add(newAddress);
    }

    @Override
    public void loginSuccess(String serverAddr, int serverId) {
        TableItem[] items = this.table.getSelection();
        if (items[0].getData().equals(serverAddr)) {
            items[0].setForeground(null);
            Server server = ServerManager.getInstance().getServer(serverId);
            if (server.isOpen()) {
                items[0].setText(String.valueOf(serverAddr) + " (" + server.getName() + ") - Running");
            }
        }
    }
}

