/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import java.util.ArrayList;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import scouter.client.model.PropertyData;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.UIUtil;

public class ServerPropertiesDialog {
    private final Display display;
    private Shell dialog;
    private int serverId;
    private TableViewer propertyTableViewer;
    private TableColumnLayout tableColumnLayout;
    ArrayList<PropertyData> propertyList = new ArrayList();

    public ServerPropertiesDialog(Display display, int serverId) {
        this.display = display;
        this.serverId = serverId;
    }

    public void show() {
        this.dialog = this.setDialogLayout();
        UIUtil.setDialogDefaultFunctions(this.dialog);
        this.makeTableContents();
    }

    private Shell setDialogLayout() {
        Shell dialog = new Shell(this.display, 2160);
        dialog.setLayout((Layout)new FillLayout());
        dialog.setText("Properties");
        Composite tableComposite = new Composite((Composite)dialog, 0);
        this.initialTable(tableComposite);
        return dialog;
    }

    private void makeTableContents() {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        this.propertyList.clear();
        this.propertyList.add(new PropertyData("name", server.getName()));
        this.propertyList.add(new PropertyData("ip", server.getIp()));
        this.propertyList.add(new PropertyData("port", "" + server.getPort()));
        if (server.getSocksAddr() != null) {
            this.propertyList.add(new PropertyData("socks5 ip", server.getSocksIp()));
            this.propertyList.add(new PropertyData("socks5 port", "" + server.getSocksPort()));
        }
        this.propertyList.add(new PropertyData("version", server.getVersion()));
        this.propertyList.add(new PropertyData("user id", server.getUserId()));
        this.propertyList.add(new PropertyData("group", server.getGroup()));
        this.propertyList.add(new PropertyData("timezone", server.getTimezone()));
        this.propertyList.add(new PropertyData("session", server.getSession()));
        this.propertyList.add(new PropertyData("time delta(ms)", server.getDelta()));
        this.propertyList.add(new PropertyData("secure_mode", server.isSecureMode()));
        this.propertyTableViewer.refresh();
        this.dialog.pack();
        this.dialog.open();
    }

    private void initialTable(Composite composite) {
        this.propertyTableViewer = new TableViewer(composite, 2050);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        TableViewerColumn c = this.createTableViewerColumn("Property", 1, 150, 4, true, true);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PropertyData) {
                    return ((PropertyData)element).property;
                }
                return null;
            }
        });
        c = this.createTableViewerColumn("Value", 2, 300, 4, true, true);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Object value;
                if (element instanceof PropertyData && (value = ((PropertyData)element).value) instanceof String) {
                    return (String)value;
                }
                return null;
            }
        });
        Table table = this.propertyTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.propertyTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.propertyTableViewer.setInput(this.propertyList);
    }

    private TableViewerColumn createTableViewerColumn(String title, int weight, int width, int alignment, boolean resizable, boolean moveable) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.propertyTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight, width, resizable));
        return viewerColumn;
    }
}

