/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import org.csstudio.swt.xygraph.figures.Axis;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import scouter.util.CastUtil;

public class SetRangeDialog
extends Dialog {
    Button autoRange;
    Axis axis;
    Text maxTxt;
    Text minTxt;

    public SetRangeDialog(Shell parentShell, Axis axis) {
        super(parentShell);
        this.axis = axis;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 5;
        comp.setLayout((Layout)fillLayout);
        Group container = new Group(comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        container.setLayout((Layout)layout);
        this.autoRange = new Button((Composite)container, 32);
        this.autoRange.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.autoRange.setText("Auto Range");
        this.autoRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SetRangeDialog.this.autoRange.getSelection()) {
                    SetRangeDialog.this.maxTxt.setEnabled(false);
                    SetRangeDialog.this.minTxt.setEnabled(false);
                } else {
                    SetRangeDialog.this.maxTxt.setEnabled(true);
                    SetRangeDialog.this.minTxt.setEnabled(true);
                }
            }
        });
        Label maxLbl = new Label((Composite)container, 0);
        maxLbl.setLayoutData((Object)new GridData(4, 4, false, false));
        maxLbl.setAlignment(131072);
        maxLbl.setText("Max : ");
        this.maxTxt = new Text((Composite)container, 2048);
        this.maxTxt.setLayoutData((Object)new GridData(4, 4, true, false));
        Label minLbl = new Label((Composite)container, 0);
        minLbl.setLayoutData((Object)new GridData(4, 4, false, false));
        minLbl.setAlignment(131072);
        minLbl.setText("Min : ");
        this.minTxt = new Text((Composite)container, 2048);
        this.minTxt.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.axis.isAutoScale()) {
            this.autoRange.setSelection(true);
            this.maxTxt.setText(CastUtil.cString((Object)this.axis.getRange().getUpper()));
            this.minTxt.setText(CastUtil.cString((Object)this.axis.getRange().getLower()));
            this.maxTxt.setEnabled(false);
            this.minTxt.setEnabled(false);
        } else {
            this.maxTxt.setText(CastUtil.cString((Object)this.axis.getRange().getUpper()));
            this.minTxt.setText(CastUtil.cString((Object)this.axis.getRange().getLower()));
        }
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Set Range");
    }

    protected boolean isResizable() {
        return false;
    }

    protected void okPressed() {
        if (this.autoRange.getSelection()) {
            this.axis.setAutoScale(true);
            super.okPressed();
        } else {
            try {
                double max = CastUtil.cdouble((Object)this.maxTxt.getText().trim());
                double min = CastUtil.cdouble((Object)this.minTxt.getText().trim());
                if (max > min) {
                    this.axis.setRangeDirect(min, max);
                } else {
                    this.axis.setRangeDirect(max, min);
                }
                this.axis.setAutoScale(false);
                super.okPressed();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.toString());
            }
        }
    }
}

