/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import scouter.client.summary.modules.AlertSummaryComposite;
import scouter.client.summary.modules.ApicallSummaryComposite;
import scouter.client.summary.modules.ErrorSummaryComposite;
import scouter.client.summary.modules.IpSummaryComposite;
import scouter.client.summary.modules.ServiceSummaryComposite;
import scouter.client.summary.modules.SqlSummaryComposite;
import scouter.client.summary.modules.UserAgentSummaryComposite;
import scouter.lang.pack.MapPack;

public class SummaryDialog {
    int serverId;
    MapPack param;
    Shell dialog;
    TabFolder tabFolder;
    TabItem serviceTab;
    TabItem sqlTab;
    TabItem apicallTab;
    TabItem ipTab;
    TabItem userAgentTab;
    TabItem errorTab;
    TabItem alertTab;

    public SummaryDialog(int serverId, MapPack param) {
        this.serverId = serverId;
        this.param = param;
    }

    public void show(String title) {
        this.dialog = new Shell(Display.getDefault(), 67696);
        this.dialog.setText(title);
        this.dialog.setLayout((Layout)new GridLayout(1, true));
        this.tabFolder = new TabFolder((Composite)this.dialog, 2048);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.serviceTab = new TabItem(this.tabFolder, 0);
        this.serviceTab.setText("Service");
        this.serviceTab.setControl(this.getServiceControl((Composite)this.tabFolder));
        this.sqlTab = new TabItem(this.tabFolder, 0);
        this.sqlTab.setText("SQL");
        this.sqlTab.setControl(this.getSqlControl((Composite)this.tabFolder));
        this.apicallTab = new TabItem(this.tabFolder, 0);
        this.apicallTab.setText("API Call");
        this.apicallTab.setControl(this.getApicallControl((Composite)this.tabFolder));
        this.ipTab = new TabItem(this.tabFolder, 0);
        this.ipTab.setText("IP");
        this.ipTab.setControl(this.getIpControl((Composite)this.tabFolder));
        this.userAgentTab = new TabItem(this.tabFolder, 0);
        this.userAgentTab.setText("User-Agent");
        this.userAgentTab.setControl(this.getUaControl((Composite)this.tabFolder));
        this.errorTab = new TabItem(this.tabFolder, 0);
        this.errorTab.setText("Exception");
        this.errorTab.setControl(this.getErrorControl((Composite)this.tabFolder));
        this.alertTab = new TabItem(this.tabFolder, 0);
        this.alertTab.setText("Alert");
        this.alertTab.setControl(this.getAlertControl((Composite)this.tabFolder));
        Button closeBtn = new Button((Composite)this.dialog, 8);
        GridData gr = new GridData(131072, 4, false, false);
        gr.widthHint = 100;
        closeBtn.setLayoutData((Object)gr);
        closeBtn.setText("&Close");
        closeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SummaryDialog.this.dialog.close();
            }
        });
        this.dialog.pack();
        this.dialog.open();
    }

    private Control getServiceControl(Composite parent) {
        ServiceSummaryComposite comp = new ServiceSummaryComposite(parent, 0);
        comp.setData(this.serverId, this.param);
        return comp;
    }

    private Control getSqlControl(Composite parent) {
        SqlSummaryComposite comp = new SqlSummaryComposite(parent, 0);
        comp.setData(this.serverId, this.param);
        return comp;
    }

    private Control getApicallControl(Composite parent) {
        ApicallSummaryComposite comp = new ApicallSummaryComposite(parent, 0);
        comp.setData(this.serverId, this.param);
        return comp;
    }

    private Control getIpControl(Composite parent) {
        IpSummaryComposite comp = new IpSummaryComposite(parent, 0);
        comp.setData(this.serverId, this.param);
        return comp;
    }

    private Control getUaControl(Composite parent) {
        UserAgentSummaryComposite comp = new UserAgentSummaryComposite(parent, 0);
        comp.setData(this.serverId, this.param);
        return comp;
    }

    private Control getErrorControl(Composite parent) {
        ErrorSummaryComposite comp = new ErrorSummaryComposite(parent, 0);
        comp.setData(this.serverId, this.param);
        return comp;
    }

    private Control getAlertControl(Composite parent) {
        AlertSummaryComposite comp = new AlertSummaryComposite(parent, 0);
        comp.setData(this.serverId, this.param);
        return comp;
    }
}

