/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.util.DateUtil;

public class TimeRangeDialog {
    Display display;
    ITimeRange callback;
    String yyyymmdd;

    public TimeRangeDialog(Display display, ITimeRange callback) {
        this(display, callback, DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime()));
    }

    public TimeRangeDialog(Display display, ITimeRange callback, String yyyymmdd) {
        this.display = display;
        this.callback = callback;
        this.yyyymmdd = yyyymmdd;
    }

    public void show() {
        this.show(TimeUtil.getCurrentTime() - 300000L, TimeUtil.getCurrentTime());
    }

    public void show(long stime, long etime) {
        final Shell dialog = new Shell(this.display, 67680);
        dialog.setLayout((Layout)new GridLayout(4, false));
        dialog.setText("Time Range");
        UIUtil.setDialogDefaultFunctions(dialog);
        Label label = new Label((Composite)dialog, 0);
        label.setText("From");
        final DateTime startTime = new DateTime((Composite)dialog, 32896);
        startTime.setHours(DateUtil.getHour((long)stime));
        startTime.setMinutes(DateUtil.getMin((long)stime));
        label = new Label((Composite)dialog, 0);
        label.setText("To");
        final DateTime endTime = new DateTime((Composite)dialog, 32896);
        endTime.setHours(DateUtil.getHour((long)etime));
        endTime.setMinutes(DateUtil.getMin((long)etime));
        Button okButton = new Button((Composite)dialog, 8);
        okButton.setText("&OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        try {
                            String fromTime = String.valueOf(TimeRangeDialog.this.yyyymmdd) + (startTime.getHours() < 10 ? "0" : "") + startTime.getHours() + (startTime.getMinutes() < 10 ? "0" : "") + startTime.getMinutes();
                            String toTime = String.valueOf(TimeRangeDialog.this.yyyymmdd) + (endTime.getHours() < 10 ? "0" : "") + endTime.getHours() + (endTime.getMinutes() < 10 ? "0" : "") + endTime.getMinutes();
                            long stime = DateUtil.getTime((String)fromTime, (String)"yyyyMMddHHmm");
                            long etime = DateUtil.getTime((String)toTime, (String)"yyyyMMddHHmm");
                            if (etime <= stime) {
                                MessageDialog.openWarning((Shell)dialog, (String)"Warning", (String)"Time range is incorrect. ");
                                break;
                            }
                            TimeRangeDialog.this.callback.setTimeRange(stime, etime);
                            dialog.close();
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MessageDialog.openError((Shell)dialog, (String)"Error", (String)("Date format error:" + e.getMessage()));
                        }
                    }
                }
            }
        });
        Button cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("&Cancel");
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        dialog.close();
                    }
                }
            }
        });
        dialog.setDefaultButton(okButton);
        dialog.pack();
        dialog.open();
    }

    public static interface ITimeRange {
        public void setTimeRange(long var1, long var3);
    }
}

