/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.popup;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import scouter.client.xlog.views.XLogViewPainter;
import scouter.util.CastUtil;

public class XLogYValueMaxDialog {
    private final Display display;
    private Shell dialog;
    Text maxValue;
    XLogViewPainter viewPainter;

    public XLogYValueMaxDialog(Display display, XLogViewPainter viewPainter) {
        this.display = display;
        this.viewPainter = viewPainter;
    }

    public void show() {
        this.dialog = this.setDialogLayout();
        this.dialog.pack();
        Rectangle rect = this.dialog.getBounds();
        Point cursorLocation = Display.getCurrent().getCursorLocation();
        this.dialog.setLocation(cursorLocation.x - rect.width / 2, cursorLocation.y - rect.height / 2);
        this.dialog.open();
    }

    public void show(String date) {
        this.dialog = this.setDialogLayout();
        this.dialog.pack();
        Monitor primaryMonitor = this.display.getPrimaryMonitor();
        Rectangle bounds = primaryMonitor.getBounds();
        Rectangle rect = this.dialog.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.dialog.setLocation(x, y);
        this.dialog.open();
    }

    public void close() {
        if (!this.dialog.isDisposed()) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private Shell setDialogLayout() {
        Shell dialog = new Shell(this.display, 67696);
        dialog.setText("Set Max Value");
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.verticalSpacing = 8;
        dialog.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)dialog, 0);
        label.setText("Y axis max : ");
        this.maxValue = new Text((Composite)dialog, 2052);
        GridData gridData = new GridData(256);
        gridData.widthHint = 100;
        gridData.horizontalSpan = 2;
        this.maxValue.setLayoutData((Object)gridData);
        this.maxValue.setText(CastUtil.cString((Object)this.viewPainter.getYValue()));
        this.maxValue.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    XLogYValueMaxDialog.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Label warn = new Label((Composite)dialog, 0);
        warn.setForeground(Display.getCurrent().getSystemColor(3));
        warn.setText("Max value > 0.05");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 3;
        warn.setLayoutData((Object)gridData);
        Button setValueBtn = new Button((Composite)dialog, 8);
        setValueBtn.setText("Set value");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 3;
        setValueBtn.setLayoutData((Object)gridData);
        setValueBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        double newVal = CastUtil.cdouble((Object)XLogYValueMaxDialog.this.maxValue.getText());
                        if (newVal < 0.05) {
                            newVal = 0.05;
                        }
                        XLogYValueMaxDialog.this.viewPainter.setYValueMaxValue(newVal);
                        XLogYValueMaxDialog.this.close();
                    }
                }
            }
        });
        this.maxValue.selectAll();
        dialog.setDefaultButton(setValueBtn);
        return dialog;
    }
}

