/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.preferences;

import java.util.HashMap;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import scouter.client.Activator;
import scouter.client.message.M;
import scouter.client.preferences.IntegerVerifyListener;
import scouter.client.preferences.PManager;
import scouter.client.util.UIUtil;
import scouter.client.xlog.views.XLogColumnEnum;
import scouter.util.CastUtil;

public class ChartPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    GridData gdata;
    Text lineWidthTxt;
    Text xlogIgnoreTxt;
    Text xlogMxCntTxt;
    Text xlogMxDragCntTxt;
    int xLogIgnoreTime;
    int xLogMaxCount;
    int xLogDragMaxCount;
    HashMap<XLogColumnEnum, Boolean> xLogColumnVisibleMap = new HashMap();
    HashMap<XLogColumnEnum, Button> xLogColumnCheckButtonMap = new HashMap();
    private int lineWidth;

    public ChartPreferencePage() {
        this.noDefaultAndApplyButton();
        this.setDescription(M.PREFERENCE_EXPAND_CHART);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        ((GridLayout)parent.getLayout()).marginBottom = 0;
        Group layoutGroup = new Group(parent, 0);
        layoutGroup.setText(M.PREFERENCE_CHARTSETTING);
        layoutGroup.setLayout((Layout)UIUtil.formLayout(5, 5));
        this.gdata = new GridData();
        this.gdata.horizontalAlignment = 4;
        layoutGroup.setLayoutData((Object)this.gdata);
        IntegerVerifyListener verifyListener = new IntegerVerifyListener();
        Label lineWidthLbl = new Label((Composite)layoutGroup, 131072);
        lineWidthLbl.setText(M.PREFERENCE_CHARTLINE_WIDTH);
        lineWidthLbl.setLayoutData((Object)UIUtil.formData(null, -1, 0, 0, null, -1, null, -1, 160));
        this.lineWidthTxt = new Text((Composite)layoutGroup, 2048);
        this.lineWidthTxt.setText("" + this.lineWidth);
        this.lineWidthTxt.setLayoutData((Object)UIUtil.formData(lineWidthLbl, 10, 0, -2, 100, -5, null, -1));
        this.lineWidthTxt.addVerifyListener((VerifyListener)verifyListener);
        Label ignoreLbl = new Label((Composite)layoutGroup, 131072);
        ignoreLbl.setText(M.PREFERENCE_CHARTXLOG_IGNORE_TIME);
        ignoreLbl.setLayoutData((Object)UIUtil.formData(null, -1, this.lineWidthTxt, 5, null, -1, null, -1, 160));
        this.xlogIgnoreTxt = new Text((Composite)layoutGroup, 2048);
        this.xlogIgnoreTxt.setText(Integer.toString(this.xLogIgnoreTime));
        this.xlogIgnoreTxt.setLayoutData((Object)UIUtil.formData(ignoreLbl, 10, this.lineWidthTxt, 3, 100, -5, null, -1, 150));
        this.xlogIgnoreTxt.addVerifyListener((VerifyListener)verifyListener);
        Label maxCntLbl = new Label((Composite)layoutGroup, 131072);
        maxCntLbl.setText(M.PREFERENCE_CHARTXLOG_MAX_COUNT);
        maxCntLbl.setLayoutData((Object)UIUtil.formData(null, -1, this.xlogIgnoreTxt, 5, null, -1, null, -1, 160));
        this.xlogMxCntTxt = new Text((Composite)layoutGroup, 2048);
        this.xlogMxCntTxt.setText(Integer.toString(this.xLogMaxCount));
        this.xlogMxCntTxt.setLayoutData((Object)UIUtil.formData(ignoreLbl, 10, this.xlogIgnoreTxt, 3, 100, -5, null, -1, 150));
        this.xlogMxCntTxt.addVerifyListener((VerifyListener)verifyListener);
        Label maxDragCntLbl = new Label((Composite)layoutGroup, 131072);
        maxDragCntLbl.setText(M.PREFERENCE_CHARTXLOG_MAX_DRAG_COUNT);
        maxDragCntLbl.setLayoutData((Object)UIUtil.formData(null, -1, this.xlogMxCntTxt, 5, null, -1, null, -1, 160));
        this.xlogMxDragCntTxt = new Text((Composite)layoutGroup, 2048);
        this.xlogMxDragCntTxt.setText(Integer.toString(this.xLogDragMaxCount));
        this.xlogMxDragCntTxt.setLayoutData((Object)UIUtil.formData(ignoreLbl, 10, this.xlogMxCntTxt, 3, 100, -5, null, -1, 150));
        this.xlogMxDragCntTxt.addVerifyListener((VerifyListener)verifyListener);
        Group layoutGroup2 = new Group(parent, 0);
        layoutGroup2.setText("XLog Columns");
        layoutGroup2.setLayout((Layout)UIUtil.formLayout(5, 5));
        GridData gdata2 = new GridData();
        gdata2.horizontalAlignment = 4;
        layoutGroup2.setLayoutData((Object)gdata2);
        boolean isFirstCol = true;
        Integer prevLabel = null;
        XLogColumnEnum[] xLogColumnEnumArray = XLogColumnEnum.values();
        int n = xLogColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            XLogColumnEnum xLogColumn = xLogColumnEnumArray[n2];
            Label label = new Label((Composite)layoutGroup2, 131072);
            label.setText(String.valueOf(xLogColumn.getTitle()) + " :");
            label.setLayoutData((Object)UIUtil.formData(null, -1, isFirstCol ? Integer.valueOf(0) : prevLabel, 1, null, -1, null, -1, 160));
            Button button = new Button((Composite)layoutGroup2, 32);
            button.setSelection(this.xLogColumnVisibleMap.get(xLogColumn).booleanValue());
            button.setLayoutData((Object)UIUtil.formData(label, 10, isFirstCol ? Integer.valueOf(0) : prevLabel, -1, 100, -5, null, -1));
            this.xLogColumnCheckButtonMap.put(xLogColumn, button);
            prevLabel = label;
            isFirstCol = false;
            ++n2;
        }
        return super.createContents(parent);
    }

    public void init(IWorkbench workbench) {
        this.lineWidth = PManager.getInstance().getInt("lineWidth");
        this.xLogIgnoreTime = PManager.getInstance().getInt("xlog_ignore_time");
        this.xLogMaxCount = PManager.getInstance().getInt("xlog_max_count");
        this.xLogDragMaxCount = PManager.getInstance().getInt("xlog_drag_max_count");
        XLogColumnEnum[] xLogColumnEnumArray = XLogColumnEnum.values();
        int n = xLogColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            XLogColumnEnum xLogColumnEnum = xLogColumnEnumArray[n2];
            this.xLogColumnVisibleMap.put(xLogColumnEnum, PManager.getInstance().getBoolean(xLogColumnEnum.getInternalID()));
            ++n2;
        }
    }

    public boolean performOk() {
        PManager.getInstance().setValue("lineWidth", CastUtil.cint((Object)this.lineWidthTxt.getText()));
        PManager.getInstance().setValue("xlog_ignore_time", CastUtil.cint((Object)this.xlogIgnoreTxt.getText()));
        PManager.getInstance().setValue("xlog_max_count", CastUtil.cint((Object)this.xlogMxCntTxt.getText()));
        PManager.getInstance().setValue("xlog_drag_max_count", CastUtil.cint((Object)this.xlogMxDragCntTxt.getText()));
        XLogColumnEnum[] xLogColumnEnumArray = XLogColumnEnum.values();
        int n = xLogColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            XLogColumnEnum xLogColumnEnum = xLogColumnEnumArray[n2];
            PManager.getInstance().setValue(xLogColumnEnum.getInternalID(), this.xLogColumnCheckButtonMap.get(xLogColumnEnum).getSelection());
            ++n2;
        }
        return true;
    }

    protected void createFieldEditors() {
    }
}

