/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.preferences;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import scouter.Version;
import scouter.client.Activator;
import scouter.client.Images;
import scouter.client.message.M;
import scouter.client.preferences.PManager;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.RCPUtil;
import scouter.client.util.UIUtil;
import scouter.lang.counters.CounterEngine;
import scouter.util.CastUtil;
import scouter.util.ObjectUtil;

public class GeneralPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    ComboFieldEditor serverIP;
    Combo hostCombo;
    Combo javaeeCombo;
    Text file;
    Text color;
    Text maxText;
    Text alertDialogTimeout;
    Text txtLinkName;
    Text txtLinkPattern;
    String filePath = "";
    String colorRgb = "";
    private String host;
    private String javaee;
    private int maxBlock;
    int alertdialogTimeoutSec = -1;

    public GeneralPreferencePage() {
        this.noDefaultAndApplyButton();
        this.setDescription(M.PREFERENCE_EXPAND);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        ((GridLayout)parent.getLayout()).marginBottom = 30;
        Label versionLabel = new Label(parent, 0);
        versionLabel.setText(" - Current Version : " + Version.getClientFullVersion());
        versionLabel.setLayoutData((Object)UIUtil.gridData(4));
        Group layoutGroup = new Group(parent, 0);
        layoutGroup.setText("Default Object Type");
        layoutGroup.setLayout((Layout)UIUtil.formLayout(5, 5));
        layoutGroup.setLayoutData((Object)UIUtil.gridData(4));
        CounterEngine counterEngine = ServerManager.getInstance().getDefaultServer().getCounterEngine();
        this.hostCombo = new Combo((Composite)layoutGroup, 2816);
        this.hostCombo.setItems(counterEngine.getChildren("host"));
        this.hostCombo.setText(this.host);
        this.hostCombo.setEnabled(true);
        this.hostCombo.setLayoutData((Object)UIUtil.formData(null, -1, 0, 8, 100, -5, null, -1, 220));
        CLabel hostLabel = new CLabel((Composite)layoutGroup, 0);
        hostLabel.setText("default 'Host'");
        hostLabel.setImage(Images.getObjectIcon("host", true, 0));
        hostLabel.setLayoutData((Object)UIUtil.formData(null, -1, 0, 8, this.hostCombo, -5, null, -1, 130));
        this.javaeeCombo = new Combo((Composite)layoutGroup, 2816);
        this.javaeeCombo.setItems(counterEngine.getChildren("javaee"));
        this.javaeeCombo.setText(this.javaee);
        this.javaeeCombo.setEnabled(true);
        this.javaeeCombo.setLayoutData((Object)UIUtil.formData(null, -1, this.hostCombo, 8, 100, -5, null, -1, 220));
        CLabel javaLabel = new CLabel((Composite)layoutGroup, 0);
        javaLabel.setText("default 'JavaEE'");
        javaLabel.setImage(Images.getObjectIcon("java", true, 0));
        javaLabel.setLayoutData((Object)UIUtil.formData(null, -1, hostLabel, 8, this.javaeeCombo, -5, null, -1, 130));
        layoutGroup = new Group(parent, 0);
        layoutGroup.setText("Profiling");
        layoutGroup.setLayout((Layout)UIUtil.formLayout(5, 5));
        layoutGroup.setLayoutData((Object)UIUtil.gridData(4));
        this.maxText = new Text((Composite)layoutGroup, 133120);
        this.maxText.setText("" + this.maxBlock);
        this.maxText.setBackground(ColorUtil.getInstance().getColor("white"));
        this.maxText.setLayoutData((Object)UIUtil.formData(null, -1, 0, -2, 100, -5, null, -1, 265));
        this.maxText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text text = (Text)e.getSource();
                String oldS = text.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                boolean isFloat = true;
                try {
                    Float.parseFloat(newS);
                }
                catch (NumberFormatException ex) {
                    isFloat = false;
                }
                if (!isFloat) {
                    e.doit = false;
                }
            }
        });
        Label label = new Label((Composite)layoutGroup, 0);
        label.setText("Max Block count:");
        label.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, this.maxText, -5, null, -1, 100));
        return super.createContents(parent);
    }

    public void init(IWorkbench workbench) {
        this.host = PManager.getInstance().getString("wasServiceDefaultHost");
        this.javaee = PManager.getInstance().getString("wasServiceDefaultWAS");
        this.maxBlock = PManager.getInstance().getInt("massProfileBlock");
    }

    public boolean performOk() {
        boolean needResetPerspective = false;
        if (!ObjectUtil.equals((Object)this.javaee, (Object)this.javaeeCombo.getText())) {
            needResetPerspective = true;
        }
        if (!ObjectUtil.equals((Object)this.host, (Object)this.hostCombo.getText())) {
            needResetPerspective = true;
        }
        if (needResetPerspective && !MessageDialog.openConfirm((Shell)this.getShell(), (String)"Reset Perspectives", (String)"To apply 'Default Object Type', all perspectives will be reset. Continue?")) {
            return false;
        }
        PManager.getInstance().setValue("wasServiceDefaultHost", this.hostCombo.getText());
        PManager.getInstance().setValue("wasServiceDefaultWAS", this.javaeeCombo.getText());
        PManager.getInstance().setValue("massProfileBlock", CastUtil.cint((Object)this.maxText.getText()));
        if (needResetPerspective) {
            RCPUtil.resetPerspective();
        }
        return true;
    }

    protected void createFieldEditors() {
    }
}

