/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.preferences;

import scouter.client.preferences.PManager;
import scouter.util.StringUtil;

public class ServerPrefUtil {
    public static void storeDefaultServer(String addr) {
        PManager.getInstance().setValue("svrAddrDef", addr);
    }

    public static void addServerAddr(String addr) {
        String addrs = PManager.getInstance().getString("svrAddrList");
        if (StringUtil.isEmpty((String)addrs)) {
            PManager.getInstance().setValue("svrAddrList", addr);
        } else if (!addrs.contains(addr)) {
            addrs = String.valueOf(addrs) + "," + addr;
            PManager.getInstance().setValue("svrAddrList", addrs);
        }
    }

    public static void addAutoLoginServer(String addr, String id, String encryptedPass, String socksAddr) {
        String addrs = PManager.getInstance().getString("svrAddrAutoLogin");
        if (StringUtil.isEmpty((String)addrs)) {
            PManager.getInstance().setValue("svrAddrAutoLogin", addr);
        } else if (!addrs.contains(addr)) {
            addrs = String.valueOf(addrs) + "," + addr;
            PManager.getInstance().setValue("svrAddrAutoLogin", addrs);
        }
        String socksAddrs = PManager.getInstance().getString("socksSvrAddrAutoLogin");
        if (StringUtil.isEmpty((String)socksAddrs)) {
            PManager.getInstance().setValue("socksSvrAddrAutoLogin", socksAddr);
        } else if (!socksAddrs.contains(socksAddr)) {
            socksAddrs = String.valueOf(socksAddrs) + "," + socksAddr;
            PManager.getInstance().setValue("socksSvrAddrAutoLogin", socksAddrs);
        }
        PManager.getInstance().setValue("autologin_" + addr, String.valueOf(id) + "," + encryptedPass);
        PManager.getInstance().setValue("socksServerAddr_" + addr, socksAddr);
    }

    public static void removeServerAddr(String addr) {
        String addrs = PManager.getInstance().getString("svrAddrList");
        if (addrs != null && addrs.contains(addr)) {
            String str = ServerPrefUtil.pickOutString(addrs, addr, ",");
            PManager.getInstance().setValue("svrAddrList", str);
        }
        ServerPrefUtil.removeAutoLoginServer(addr);
    }

    public static void removeAutoLoginServer(String addr) {
        String addrs = PManager.getInstance().getString("svrAddrAutoLogin");
        if (addrs != null && addrs.contains(addr)) {
            String str = ServerPrefUtil.pickOutString(addrs, addr, ",");
            PManager.getInstance().setValue("svrAddrAutoLogin", str);
        }
        PManager.getInstance().setValue("autologin_" + addr, "");
    }

    public static String getStoredDefaultServer() {
        return PManager.getInstance().getString("svrAddrDef");
    }

    public static String[] getStoredServerList() {
        String addrs = PManager.getInstance().getString("svrAddrList");
        return StringUtil.tokenizer((String)addrs, (String)",");
    }

    public static String[] getStoredSocks5ServerList() {
        String addrs = PManager.getInstance().getString("socksSvrAddrAutoLogin");
        return StringUtil.tokenizer((String)addrs, (String)",");
    }

    public static String[] getStoredAutoLoginServerList() {
        String addrs = PManager.getInstance().getString("svrAddrAutoLogin");
        return StringUtil.tokenizer((String)addrs, (String)",");
    }

    public static String getStoredAccountInfo(String addr) {
        return PManager.getInstance().getString("autologin_" + addr);
    }

    public static boolean isSocksLogin(String addr) {
        return StringUtil.isNotEmpty((String)PManager.getInstance().getString("socksServerAddr_" + addr));
    }

    public static String getStoredSocksServer(String addr) {
        return PManager.getInstance().getString("socksServerAddr_" + addr);
    }

    public static boolean isAutoLoginAddress(String addr) {
        String addrs = PManager.getInstance().getString("svrAddrAutoLogin");
        return addrs.contains(addr);
    }

    public static String pickOutString(String fullStr, String pickStr, String delimeter) {
        if (fullStr.equals(pickStr)) {
            return "";
        }
        int index = fullStr.indexOf(pickStr);
        if (index < 0) {
            return fullStr;
        }
        if (index == 0) {
            return fullStr.substring(pickStr.length() + delimeter.length(), fullStr.length());
        }
        return String.valueOf(fullStr.substring(0, index - delimeter.length())) + fullStr.substring(index + pickStr.length(), fullStr.length());
    }

    public static void main(String[] args) {
        String fullStr = "gggg,tytytyty,abc,ggg,kdkdkd";
        String pickStr = "abc";
        System.out.println(ServerPrefUtil.pickOutString(fullStr, pickStr, ","));
    }
}

