/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.remote;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.remote.RemoteHandler;
import scouter.client.remote.handle.ActionControl;
import scouter.client.remote.handle.LifeControl;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.TextPack;
import scouter.util.ThreadUtil;

public class CheckMyJob
extends Thread {
    private static volatile CheckMyJob instance;
    protected static HashMap<String, Invocation> handlers;
    static Set<String> classSet;

    static {
        handlers = new HashMap();
        classSet = new HashSet<String>();
        classSet.add(LifeControl.class.getName());
        classSet.add(ActionControl.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CheckMyJob getInstance() {
        if (instance != null) return instance;
        Class<CheckMyJob> clazz = CheckMyJob.class;
        synchronized (CheckMyJob.class) {
            if (instance != null) return instance;
            instance = new CheckMyJob();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName((Thread)instance));
            instance.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void load() {
        Iterator<String> itr = classSet.iterator();
        while (itr.hasNext()) {
            try {
                Class<?> c = Class.forName(itr.next());
                if (!Modifier.isPublic(c.getModifiers())) continue;
                try {
                    Method[] m = c.getDeclaredMethods();
                    int i = 0;
                    while (i < m.length) {
                        RemoteHandler mapAn = m[i].getAnnotation(RemoteHandler.class);
                        if (mapAn != null) {
                            String key = mapAn.value();
                            Invocation news = new Invocation(c.newInstance(), m[i]);
                            handlers.put(key, news);
                        }
                        ++i;
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        this.load();
        while (true) {
            try {
                Set<Integer> serverSet = ServerManager.getInstance().getOpenServerList();
                for (Integer id : serverSet) {
                    Server server = ServerManager.getInstance().getServer(id);
                    TcpProxy tcp = TcpProxy.getTcpProxy(id);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("session", server.getSession());
                            final DoJob job = new DoJob();
                            tcp.process("CHECK_JOB", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    Pack p = in.readPack();
                                    if (p instanceof TextPack) {
                                        job.command = ((TextPack)p).text;
                                    } else if (p instanceof MapPack) {
                                        job.param = (MapPack)p;
                                    }
                                }
                            });
                            if (job.command != null) {
                                ConsoleProxy.infoSafe(String.valueOf(job.command) + " cheked");
                                Invocation handler = handlers.get(job.command);
                                if (handler != null) {
                                    handler.exec(id, job.param);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
            ThreadUtil.sleep((long)2000L);
        }
    }

    static class DoJob {
        String command;
        MapPack param;

        DoJob() {
        }
    }

    protected static class Invocation {
        Object object;
        Method method;

        public Invocation(Object object, Method method) {
            this.object = object;
            this.method = method;
        }

        public void exec(int serverId, MapPack param) {
            try {
                this.method.invoke(this.object, serverId, param);
            }
            catch (InvocationTargetException t) {
                if (t.getCause() != null) {
                    t.getCause().printStackTrace();
                } else {
                    t.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return String.valueOf(this.object.getClass().getName()) + "." + this.method.getName();
        }
    }
}

