/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.remote.handle;

import org.eclipse.swt.widgets.Display;
import scouter.client.net.TcpProxy;
import scouter.client.popup.PopupMessageDialog;
import scouter.client.remote.RemoteHandler;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BlobValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;

public class ActionControl {
    @RemoteHandler(value="POPUP_MESSAGE")
    public void popUpMessage(int serverId, final MapPack param) throws Exception {
        ExUtil.exec(Display.getDefault(), new Runnable(){

            @Override
            public void run() {
                Value message = param.get("message");
                Value from = param.get("from");
                Value keepTime = param.get("keeptime");
                if (message != null) {
                    if (keepTime == null) {
                        new PopupMessageDialog().show(CastUtil.cString((Object)from), CastUtil.cString((Object)message));
                    } else {
                        new PopupMessageDialog().show(CastUtil.cString((Object)from), CastUtil.cString((Object)message), CastUtil.cint((Object)keepTime));
                    }
                }
            }
        });
    }

    @RemoteHandler(value="REFETCH_COUNTER_XML")
    public void refetchCounterXml(int serverId, MapPack param) throws Exception {
        Pack p;
        Server server;
        block8: {
            server = ServerManager.getInstance().getServer(serverId);
            if (server == null) {
                return;
            }
            TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
            p = null;
            try {
                try {
                    p = tcp.getSingle("GET_XML_COUNTER", null);
                }
                catch (Exception e) {
                    ConsoleProxy.errorSafe(e.toString());
                    TcpProxy.putTcpProxy(tcp);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        if (p != null) {
            ConsoleProxy.infoSafe("***********************************");
            ConsoleProxy.infoSafe("Refetch counter.xml is successfully read from " + server.getName());
            CounterEngine engine = server.getCounterEngine();
            MapPack m = (MapPack)p;
            engine.clear();
            Value v1 = m.get("default");
            engine.parse(((BlobValue)v1).value);
            v1 = m.get("custom");
            if (v1 != null) {
                engine.parse(((BlobValue)v1).value);
            }
            server.setDirty(true);
            ConsoleProxy.infoSafe("Applied Complete.");
            ConsoleProxy.infoSafe("***********************************");
        }
    }
}

