/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.server;

import scouter.client.net.ConnectionPool;
import scouter.lang.counters.CounterEngine;
import scouter.lang.value.MapValue;
import scouter.util.HashUtil;

public class Server {
    private final int id;
    private String name;
    private String ip;
    private int port;
    private ConnectionPool connPool = new ConnectionPool();
    private boolean connected = false;
    private long session;
    private long delta;
    private CounterEngine counterEngine = new CounterEngine();
    private String timezone;
    private String userId;
    private String encryptedPass;
    private String group;
    private String version;
    private String recommendedClientVersion;
    private String email;
    private boolean secureMode = true;
    private boolean open = false;
    private long usedMemory;
    private long totalMemory;
    private boolean dirty = false;
    private int soTimeOut = 8000;
    private String extLinkName;
    private String extLinkUrlPattern;
    private MapValue groupPolicyMap = new MapValue();
    private MapValue menuEnableMap = new MapValue();
    private String socksIp;
    private int socksPort;

    public Server(String ip, String port) {
        this(ip, port, null);
    }

    public Server(String ip, String port, String name) {
        this(ip, port, name, null, null);
    }

    public Server(String ip, String port, String name, String socksIp, String socksPort) {
        this.id = HashUtil.hash((String)(String.valueOf(ip) + port));
        this.ip = ip;
        this.port = Integer.valueOf(port);
        this.name = name;
        this.socksIp = socksIp;
        if (socksPort != null) {
            try {
                this.socksPort = Integer.valueOf(socksPort);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getSocksAddr() {
        String socksAddr = null;
        if (this.getSocksIp() != null && this.getSocksPort() != 0) {
            socksAddr = String.valueOf(this.getSocksIp()) + ":" + this.getSocksPort();
        }
        return socksAddr;
    }

    public boolean isSocksLogin() {
        return this.getSocksIp() != null && this.getSocksPort() != 0;
    }

    public int getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getSocksIp() {
        return this.socksIp;
    }

    public void setSocksIp(String socksIp) {
        this.socksIp = socksIp;
    }

    public int getSocksPort() {
        return this.socksPort;
    }

    public void setSocksPort(int socksPort) {
        this.socksPort = socksPort;
    }

    public ConnectionPool getConnectionPool() {
        return this.connPool;
    }

    public void close() {
        this.connPool.closeAll();
    }

    public long getSession() {
        return this.session;
    }

    public void setSession(long session) {
        this.session = session;
    }

    public long getDelta() {
        return this.delta;
    }

    public void setDelta(long serverTime) {
        this.delta = serverTime < 1L ? 0L : serverTime - System.currentTimeMillis();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean isConnected) {
        this.connected = isConnected;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            return String.valueOf(this.ip) + ":" + this.port;
        }
        return this.name;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.encryptedPass;
    }

    public void setPassword(String password) {
        this.encryptedPass = password;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRecommendedClientVersion() {
        return this.recommendedClientVersion;
    }

    public void setRecommendedClientVersion(String recommendedClientVersion) {
        this.recommendedClientVersion = recommendedClientVersion;
    }

    public void setGroupPolicy(MapValue mv) {
        this.groupPolicyMap = mv;
    }

    public boolean isAllowAction(String name) {
        return this.groupPolicyMap.getBoolean(name);
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public CounterEngine getCounterEngine() {
        return this.counterEngine;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public void setUsedMemory(long usedMemory) {
        this.usedMemory = usedMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void setMenuEnableMap(MapValue mv) {
        this.menuEnableMap = mv;
    }

    public boolean isEnableMenu(String key) {
        return this.menuEnableMap.getBoolean(key);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis() + this.getDelta();
    }

    public int getSoTimeOut() {
        return this.soTimeOut;
    }

    public void setSoTimeOut(int soTimeOut) {
        this.soTimeOut = soTimeOut;
    }

    public String getExtLinkName() {
        return this.extLinkName;
    }

    public void setExtLinkName(String extLinkName) {
        this.extLinkName = extLinkName;
    }

    public String getExtLinkUrlPattern() {
        return this.extLinkUrlPattern;
    }

    public void setExtLinkUrlPattern(String extLinkUrlPattern) {
        this.extLinkUrlPattern = extLinkUrlPattern;
    }

    public boolean isSecureMode() {
        return this.secureMode;
    }

    public void setSecureMode(boolean secureMode) {
        this.secureMode = secureMode;
    }

    public String toString() {
        return "Server [id=" + this.id + ", name=" + this.name + ", ip=" + this.ip + ", port=" + this.port + ", connected=" + this.connected + ", delta=" + this.delta + ", userId=" + this.userId + ", group=" + this.group + ", version=" + this.version + "]";
    }
}

