/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.server;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.lang.pack.MapPack;
import scouter.util.HashUtil;
import scouter.util.LinkedMap;
import scouter.util.ThreadUtil;

public class ServerManager
extends Thread {
    private static volatile ServerManager instance;
    private final LinkedMap<Integer, Server> serverMap = new LinkedMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerManager getInstance() {
        if (instance != null) return instance;
        Class<ServerManager> clazz = ServerManager.class;
        synchronized (ServerManager.class) {
            if (instance != null) return instance;
            ServerManager serverManager = new ServerManager();
            serverManager.setName(ThreadUtil.getName((Thread)serverManager));
            serverManager.setDaemon(true);
            serverManager.start();
            instance = serverManager;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ServerManager() {
    }

    public Server addServer(Server server) {
        return (Server)this.serverMap.put((Object)server.getId(), (Object)server);
    }

    public Server getDefaultServer() {
        return (Server)this.serverMap.getFirstValue();
    }

    public boolean setDefaultServer(Server server) {
        this.serverMap.putFirst((Object)server.getId(), (Object)server);
        return true;
    }

    @Override
    public void run() {
        while (true) {
            this.syncServerTime();
            ThreadUtil.sleep((long)2000L);
        }
    }

    private void syncServerTime() {
        Enumeration servers = this.serverMap.values();
        while (servers.hasMoreElements()) {
            Server server = (Server)servers.nextElement();
            if (!server.isConnected() || !server.isOpen()) continue;
            TcpProxy tcp = TcpProxy.getTcpProxy(server.getId());
            try {
                try {
                    MapPack p = (MapPack)tcp.getSingle("SERVER_STATUS", null);
                    if (p != null) {
                        long time = p.getLong("time");
                        if (time > 0L) {
                            server.setDelta(time);
                        }
                        long usedMemory = p.getLong("used");
                        long totalMemory = p.getLong("total");
                        server.setUsedMemory(usedMemory);
                        server.setTotalMemory(totalMemory);
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    continue;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
    }

    public Server getServer(int id) {
        return (Server)this.serverMap.get((Object)id);
    }

    public Server getServer(String addr) {
        if (addr == null) {
            return null;
        }
        String[] addrSplits = addr.split(":");
        if (addrSplits.length < 2) {
            return null;
        }
        return this.getServer(HashUtil.hash((String)(String.valueOf(addrSplits[0]) + addrSplits[1])));
    }

    public void removeServer(int serverId) {
        Server remove = (Server)this.serverMap.remove((Object)serverId);
        if (remove != null) {
            remove.close();
            System.out.println("Remove server : " + remove.getName());
        }
    }

    public Set<Integer> getOpenServerList() {
        HashSet<Integer> keySet = new HashSet<Integer>();
        Enumeration servers = this.serverMap.values();
        while (servers.hasMoreElements()) {
            Server server = (Server)servers.nextElement();
            if (!server.isOpen()) continue;
            keySet.add(server.getId());
        }
        return keySet;
    }

    public Enumeration<Integer> getAllServerList() {
        return this.serverMap.keys();
    }

    public boolean isRunningServer(String ip, String port) {
        int hash = HashUtil.hash((String)(String.valueOf(ip) + port));
        Server server = (Server)this.serverMap.get((Object)hash);
        if (server == null) {
            return false;
        }
        return server.isOpen();
    }

    public void printAll() {
        System.out.println("******************************");
        System.out.println("SERVER LIST");
        System.out.println("******************************");
        Enumeration itr = this.serverMap.keys();
        while (itr.hasMoreElements()) {
            Integer key = (Integer)itr.nextElement();
            Server server = (Server)this.serverMap.get((Object)key);
            System.out.println("ID : " + key);
            System.out.println("IP : " + server.getIp());
            System.out.println("Port : " + server.getPort());
            System.out.println("Connected : " + server.isConnected());
            System.out.println("Session : " + server.getSession());
            System.out.println("------------------------------------------");
        }
    }

    public void shutdown() {
        Enumeration servers = this.serverMap.values();
        while (servers.hasMoreElements()) {
            Server server = (Server)servers.nextElement();
            server.close();
        }
        this.serverMap.clear();
    }
}

