/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.sorter;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.util.CastUtil;

public class TableLabelSorter
extends ViewerComparator {
    public static final int ORDER_ASC = 1;
    public static final int NONE = 0;
    public static final int ORDER_DESC = -1;
    private TableColumn col = null;
    private int colIndex = 0;
    ICustomCompare custom;
    TableViewer viewer;
    Table table;
    private int dir = 0;

    public TableLabelSorter(TableViewer viewer) {
        this.viewer = viewer;
        this.table = viewer.getTable();
    }

    public TableLabelSorter setCustomCompare(ICustomCompare custom) {
        this.custom = custom;
        return this;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (this.dir == 0 || this.col == null) {
            return 0;
        }
        if (this.custom == null) {
            return this.dir * this.compareNormal(o1, o2);
        }
        return this.dir * this.custom.doCompare(this.col, this.colIndex, o1, o2);
    }

    public void setColumn(TableColumn clickedColumn) {
        if (this.col == clickedColumn) {
            this.dir *= -1;
        } else {
            this.col = clickedColumn;
            this.dir = 1;
        }
        TableColumn[] cols = this.table.getColumns();
        int colLen = cols.length;
        int i = 0;
        while (i < colLen) {
            if (cols[i] == this.col) {
                this.colIndex = i;
                break;
            }
            ++i;
        }
        this.table.setSortColumn(clickedColumn);
        switch (this.dir) {
            case 1: {
                this.table.setSortDirection(128);
                break;
            }
            case -1: {
                this.table.setSortDirection(1024);
            }
        }
        this.viewer.refresh();
    }

    protected int compareNormal(Object e1, Object e2) {
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.viewer.getLabelProvider();
        String t1 = labelProvider.getColumnText(e1, this.colIndex);
        String t2 = labelProvider.getColumnText(e2, this.colIndex);
        Boolean isNumber = (Boolean)this.col.getData("isNumber");
        if (isNumber != null && isNumber.booleanValue()) {
            double n2;
            t1 = ColumnLabelSorter.numonly(t1);
            t2 = ColumnLabelSorter.numonly(t2);
            double n1 = CastUtil.cdouble((Object)t1);
            return n1 == (n2 = CastUtil.cdouble((Object)t2)) ? 0 : (n1 > n2 ? 1 : -1);
        }
        if (t1 == null) {
            t1 = "";
        }
        if (t2 == null) {
            t2 = "";
        }
        return t1.compareTo(t2);
    }

    public static interface ICustomCompare {
        public int doCompare(TableColumn var1, int var2, Object var3, Object var4);
    }
}

