/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.actions;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.util.ExUtil;
import scouter.client.views.ObjectThreadDumpView;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.StackPack;

public class FetchSingleStackJob
extends Job {
    int serverId;
    String objName;
    long time;
    List<Long> list;
    ObjectThreadDumpView view;

    public FetchSingleStackJob(int serverId, String objName, long time, List<Long> list, ObjectThreadDumpView view) {
        super(String.valueOf(objName) + " stack ...");
        this.serverId = serverId;
        this.objName = objName;
        this.time = time;
        this.list = list;
        this.view = view;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        StringBuilder content;
        block5: {
            monitor.beginTask("Fetching...", 1);
            TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
            content = new StringBuilder();
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objName", this.objName);
                    param.put("from", this.time);
                    param.put("to", this.time + 1L);
                    tcp.process("GET_STACK_ANALYZER", param, new INetReader(){
                        int count = 0;

                        @Override
                        public void process(DataInputX in) throws IOException {
                            StackPack sp = (StackPack)in.readPack();
                            content.append(sp.getStack());
                            monitor.worked(this.count++);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                TcpProxy.putTcpProxy(tcp);
                throw throwable;
            }
            TcpProxy.putTcpProxy(tcp);
        }
        monitor.done();
        ExUtil.exec(Display.getDefault(), new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    try {
                        if (FetchSingleStackJob.this.view == null) {
                            ObjectThreadDumpView newView = (ObjectThreadDumpView)window.getActivePage().showView(ObjectThreadDumpView.ID, null, 1);
                            if (newView != null) {
                                newView.setInput(content.toString(), FetchSingleStackJob.this.objName, FetchSingleStackJob.this.serverId, FetchSingleStackJob.this.time, FetchSingleStackJob.this.list);
                            }
                        } else {
                            FetchSingleStackJob.this.view.setInput(content.toString());
                        }
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
                    }
                }
            }
        });
        return Status.OK_STATUS;
    }
}

