/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.stack.base.MainProcessor;
import scouter.client.util.ExUtil;
import scouter.client.util.StackUtil;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.StackPack;
import scouter.util.DateUtil;

public class FetchStackJob
extends Job {
    int serverId;
    String objName;
    long from;
    long to;
    int total;

    public FetchStackJob(int serverId, String objName, long from, long to, int total) {
        super(String.valueOf(objName) + " stack list...");
        this.serverId = serverId;
        this.objName = objName;
        this.from = from;
        this.to = to;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        File stackFile;
        block7: {
            String dirPath = StackUtil.getStackWorkspaceDir(this.objName);
            StringBuilder sb = new StringBuilder();
            sb.append(DateUtil.format((long)this.from, (String)"yyyyMMdd"));
            sb.append("_");
            sb.append(DateUtil.format((long)this.from, (String)"HHmmss"));
            sb.append("_");
            sb.append(DateUtil.format((long)this.to, (String)"HHmmss"));
            sb.append(".stack");
            stackFile = new File(dirPath, sb.toString());
            if (!stackFile.canRead()) {
                monitor.beginTask("Fetching...", this.total);
                TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
                try {
                    try {
                        MapPack param = new MapPack();
                        param.put("objName", this.objName);
                        param.put("from", this.from);
                        param.put("to", this.to);
                        final StringBuilder content = new StringBuilder();
                        tcp.process("GET_STACK_ANALYZER", param, new INetReader(){
                            int count = 0;

                            @Override
                            public void process(DataInputX in) throws IOException {
                                StackPack sp = (StackPack)in.readPack();
                                content.append(sp.getStack());
                                monitor.worked(this.count++);
                                if (this.count % 100 == 0) {
                                    FetchStackJob.this.writeAppendFile(stackFile, content.toString());
                                    content.setLength(0);
                                }
                            }
                        });
                        if (content.length() > 0) {
                            this.writeAppendFile(stackFile, content.toString());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        stackFile.delete();
                        TcpProxy.putTcpProxy(tcp);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
        }
        monitor.done();
        ExUtil.exec(Display.getDefault(), new Runnable(){

            @Override
            public void run() {
                MainProcessor.instance().processStackFile(stackFile.getAbsolutePath());
            }
        });
        return Status.OK_STATUS;
    }

    private void writeAppendFile(File file, String str) throws IOException {
        FileWriter writer = new FileWriter(file, true);
        BufferedWriter bufferedWriter = new BufferedWriter(writer, 8192);
        bufferedWriter.write(str);
        bufferedWriter.flush();
        bufferedWriter.close();
    }
}

