/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.base;

import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import scouter.client.Images;
import scouter.client.stack.base.MainProcessor;
import scouter.client.util.UIUtil;

public class FilterInputDialog {
    private boolean m_isAscending = true;
    private Text m_field = null;
    private TASK m_jobType = TASK.NONE;
    private Shell m_shell = null;

    public FilterInputDialog(Shell shell, boolean isAscending, TASK jobtype) {
        this.m_shell = new Shell(shell);
        this.m_shell.setText("Input Filter String");
        this.m_shell.setImage(Images.filter);
        this.m_shell.setSize(700, 120);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.m_shell.setLayoutData((Object)layout);
        int[] screen = UIUtil.getScreenSize();
        this.m_shell.setLocation(screen[0] / 2 - 350, screen[1] / 2 - 75);
        this.m_field = new Text((Composite)this.m_shell, 18432);
        this.m_field.setEditable(true);
        this.m_field.setTextLimit(100);
        this.m_field.setSize(682, 25);
        this.m_field.setLocation(5, 5);
        Button button = new Button((Composite)this.m_shell, 0);
        button.setText("Execute");
        button.setAlignment(0x1000000);
        button.setSize(100, 35);
        button.setLocation(480, 40);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String filter = FilterInputDialog.this.m_field.getText();
                if (filter != null && filter.length() > 0) {
                    MainProcessor mainProcessor = MainProcessor.instance();
                    switch (FilterInputDialog.this.m_jobType) {
                        case PERFORMANCE_TREE: {
                            mainProcessor.createAnalyzedPerformance(filter, FilterInputDialog.this.m_isAscending);
                            break;
                        }
                        case SERVICE_CALL: {
                            mainProcessor.viewServiceCall(filter);
                            break;
                        }
                        case THREAD_STACK: {
                            mainProcessor.viewThreadStack(filter);
                            break;
                        }
                        case FILTER_ANALYZER: {
                            mainProcessor.analyzeFilterStack(filter, FilterInputDialog.this.m_isAscending);
                        }
                    }
                }
                FilterInputDialog.this.m_shell.close();
            }
        });
        this.m_shell.setDefaultButton(button);
        button = new Button((Composite)this.m_shell, 0);
        button.setText("Cancel");
        button.setAlignment(0x1000000);
        button.setSize(100, 35);
        button.setLocation(588, 40);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    FilterInputDialog.this.m_shell.close();
                }
            }
        });
        this.m_isAscending = isAscending;
        this.m_jobType = jobtype;
        this.m_field.setFocus();
        this.m_shell.open();
    }

    public static enum TASK {
        NONE,
        PERFORMANCE_TREE,
        SERVICE_CALL,
        THREAD_STACK,
        FILTER_ANALYZER;

    }
}

