/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import scouter.client.Images;
import scouter.client.PerspectiveStackAnalyzer;
import scouter.client.stack.base.FilterInputDialog;
import scouter.client.stack.base.PerformanceWindow;
import scouter.client.stack.base.PreferenceManager;
import scouter.client.stack.config.ParserConfig;
import scouter.client.stack.config.ParserConfigReader;
import scouter.client.stack.data.StackAnalyzedInfo;
import scouter.client.stack.data.StackAnalyzedValue;
import scouter.client.stack.data.StackAnalyzedValueComp;
import scouter.client.stack.data.StackFileInfo;
import scouter.client.stack.data.StackParser;
import scouter.client.stack.data.UniqueStackValue;
import scouter.client.stack.utils.HtmlUtils;
import scouter.client.stack.utils.ResourceUtils;
import scouter.client.stack.utils.StringUtils;
import scouter.client.stack.utils.ValueObject;
import scouter.client.stack.views.StackAnalyzerView;

public class MainProcessor {
    private static MainProcessor m_mainProcessor = null;
    private StackAnalyzerView m_stackAnalyzerView = null;
    private Composite m_parentComposite = null;
    private boolean m_isExcludeStack = true;
    private boolean m_isRemoveLine = false;
    private boolean m_isInerPercent = false;
    private boolean m_isSortByFunction = false;
    private boolean m_isSimpleDumpTimeList = true;
    private boolean m_isDefaultConfiguration = false;
    private boolean m_isAnalyzeAllThreads = false;

    static {
        m_mainProcessor = new MainProcessor();
    }

    public static MainProcessor instance() {
        return m_mainProcessor;
    }

    public StackAnalyzerView getStackAnalyzerView() {
        return this.m_stackAnalyzerView;
    }

    public void setStackAnalyzerView(StackAnalyzerView stackAnalyzerView) {
        this.m_stackAnalyzerView = stackAnalyzerView;
    }

    public void setParentComposite(Composite parent) {
        this.m_parentComposite = parent;
    }

    public Composite getParentComposite() {
        return this.m_parentComposite;
    }

    public boolean isExcludeStack() {
        return this.m_isExcludeStack;
    }

    public void setExcludeStack(boolean value) {
        this.m_isExcludeStack = value;
    }

    public boolean isRemoveLine() {
        return this.m_isRemoveLine;
    }

    public void setRemoveLine(boolean value) {
        this.m_isRemoveLine = value;
    }

    public boolean isInerPercent() {
        return this.m_isInerPercent;
    }

    public void setInerPercent(boolean value) {
        this.m_isInerPercent = value;
    }

    public boolean isSortByFunction() {
        return this.m_isSortByFunction;
    }

    public void setSortByFunction(boolean value) {
        this.m_isSortByFunction = value;
    }

    public boolean isSimpleDumpTimeList() {
        return this.m_isSimpleDumpTimeList;
    }

    public void setSimpleDumpTimeList(boolean value) {
        this.m_isSimpleDumpTimeList = value;
    }

    public boolean isDefaultConfiguration() {
        return this.m_isDefaultConfiguration;
    }

    public void setDefaultConfiguration(boolean value) {
        this.m_isDefaultConfiguration = value;
    }

    public boolean isAnalyzeAllThreads() {
        return this.m_isAnalyzeAllThreads;
    }

    public void setAnalyzeAllThread(boolean value) {
        this.m_isAnalyzeAllThreads = value;
    }

    public void processMenu(String menuName) {
        System.out.println("Selected:" + menuName);
        if (!menuName.substring(1, 3).equals(":\\")) {
            if ("Open Stack Log".equals(menuName)) {
                this.chooseStackFile();
            } else if ("Open Analyzed Stack Log".equals(menuName)) {
                this.openAnalyzedInfo();
            } else if ("Close All".equals(menuName)) {
                this.closeStackAllFileInfo();
            } else if ("Select Parser Configuration".equals(menuName)) {
                this.selectCurrentParserConfig();
            } else if ("Manual Performance Tree(Ascending)".equals(menuName)) {
                this.createManualJob(FilterInputDialog.TASK.PERFORMANCE_TREE, true);
            } else if ("Manual Performance Tree(Descending)".equals(menuName)) {
                this.createManualJob(FilterInputDialog.TASK.PERFORMANCE_TREE, false);
            } else if ("Manual Service Call".equals(menuName)) {
                this.createManualJob(FilterInputDialog.TASK.SERVICE_CALL, true);
            } else if ("Manual Thread Stack (max 20000 lines)".equals(menuName)) {
                this.createManualJob(FilterInputDialog.TASK.THREAD_STACK, true);
            } else if ("Manual Stack Analyze(Include)".equals(menuName)) {
                this.createManualJob(FilterInputDialog.TASK.FILTER_ANALYZER, true);
            } else if ("Manual Stack Analyze(Exclude)".equals(menuName)) {
                this.createManualJob(FilterInputDialog.TASK.FILTER_ANALYZER, false);
            } else if ("Performance Tree".equals(menuName)) {
                this.createMainPerformance();
            } else if ("Close".equals(menuName)) {
                this.closeStackFileInfo();
            } else if ("Reanalyze".equals(menuName)) {
                this.reanalyzeStackFileInfo();
            } else if ("View Raw Index File".equals(menuName)) {
                this.viewRawIndexFile();
            } else if ("Performance Tree(Ascending)".equals(menuName)) {
                this.createAnalyzedPerformance(true);
            } else if ("Performance Tree(Descending)".equals(menuName)) {
                this.createAnalyzedPerformance(false);
            } else if ("View Thread Stack (max 20000 lines)".equals(menuName)) {
                this.viewThreadStack();
            } else if ("View Service Call".equals(menuName)) {
                this.viewServiceCall();
            } else if ("Filter Stack Analyze".equals(menuName)) {
                this.analyzeFilterStack(null);
            } else if ("Copy Function".equals(menuName)) {
                this.copyFunctionName();
            }
        }
    }

    private void chooseStackFile() {
        PreferenceManager prefManager = PreferenceManager.get();
        String fileName = ResourceUtils.selectFileDialog(this.m_parentComposite, "Stack Log File", new String[]{"Stack Log Files", "All Files"}, new String[]{"*.log;*.txt;*.gz;*.stack", "*.*"});
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        prefManager.setSelectedPath(file.getParentFile());
        this.openFile(file, false);
    }

    private ParserConfig selectAdoptiveParserConfig() {
        PreferenceManager prefManager = PreferenceManager.get();
        String configFile = prefManager.getCurrentParserConfig();
        if (this.m_isDefaultConfiguration) {
            configFile = "Default";
        }
        if (configFile == null) {
            MessageBox messageBox = new MessageBox(this.m_parentComposite.getShell(), 65732);
            messageBox.setText("Check Setting selection");
            messageBox.setMessage("The configuration file is not selected.\r\nDo you want to use the default configuration?");
            int result = messageBox.open();
            if (result == 64) {
                configFile = "Default";
            } else {
                configFile = this.selectCurrentParserConfig();
                if (configFile == null) {
                    throw new RuntimeException("Parser config file is not selected!");
                }
            }
        }
        ParserConfigReader reader = new ParserConfigReader(configFile);
        return reader.read();
    }

    private void addProcessedStack(StackFileInfo stackFileInfo) {
        if (stackFileInfo == null) {
            return;
        }
        this.addMainTree(stackFileInfo);
        this.displayContent(null);
    }

    private void openContents(String contents) {
        ParserConfig config = this.selectAdoptiveParserConfig();
        StackFileInfo stackFileInfo = this.processStackContents(contents, config, null, false, true);
        this.addProcessedStack(stackFileInfo);
    }

    private void openFile(File file, boolean isRecent) {
        ParserConfig config = this.selectAdoptiveParserConfig();
        StackFileInfo stackFileInfo = this.processStackFile(file.getAbsolutePath(), config, null, isRecent, true);
        this.addProcessedStack(stackFileInfo);
    }

    private void openAnalyzedInfo() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("info");
        String filename = ResourceUtils.selectFileDialog(this.m_parentComposite, "Analyzed Info File", new String[]{"Stack Analyzed Files", "All Files"}, new String[]{"*.info", "*.*"});
        if (filename == null) {
            return;
        }
        this.openAnalyzedFile(filename);
    }

    private void openAnalyzedFile(String filename) {
        StackFileInfo fileInfo = StackParser.loadAnalyzedInfo(filename);
        this.addProcessedStack(fileInfo);
    }

    private StackFileInfo processStackContents(String contents, ParserConfig config, String filter, boolean isRecent, boolean isInclude) {
        StackFileInfo stackFileInfo = new StackFileInfo("Stacks");
        return this.processStackContents(contents, stackFileInfo, config, filter, isRecent, isInclude);
    }

    private StackFileInfo processStackFile(String stackFilename, ParserConfig config, String filter, boolean isRecent, boolean isInclude) {
        StackFileInfo stackFileInfo = new StackFileInfo(stackFilename);
        return this.processStackFile(stackFileInfo, config, filter, isRecent, isInclude);
    }

    private StackFileInfo postSTackFile(StackFileInfo stackFileInfo, ParserConfig config, String filter, boolean isRecent) {
        if (stackFileInfo.getTotalWorkingCount() <= 0) {
            MessageBox messageBox = new MessageBox(this.m_parentComposite.getShell(), 65601);
            messageBox.setText("File open error");
            messageBox.setMessage(new StringBuilder(200).append("A working thread is not exists in ").append(stackFileInfo.getFilename()).append(". configure a ").append(config.getConfigFilename()).append(". ").toString());
            messageBox.open();
            return null;
        }
        if (!isRecent) {
            PreferenceManager prefManager = PreferenceManager.get();
            if (filter == null) {
                prefManager.addToStackFiles(stackFileInfo.getFilename());
            }
            prefManager.addToAnalyzedStackFiles(stackFileInfo.getFilename());
        }
        return stackFileInfo;
    }

    private StackFileInfo processStackContents(String contents, StackFileInfo stackFileInfo, ParserConfig config, String filter, boolean isRecent, boolean isInclude) {
        try {
            StackParser parser = StackParser.getParser(config, filter, isInclude);
            parser.setStackContents(contents);
            parser.analyze(stackFileInfo);
            stackFileInfo = this.postSTackFile(stackFileInfo, config, filter, isRecent);
        }
        catch (RuntimeException ex) {
            StackParser.removeAllAnalyzedFile(stackFileInfo);
            throw ex;
        }
        return stackFileInfo;
    }

    private StackFileInfo processStackFile(StackFileInfo stackFileInfo, ParserConfig config, String filter, boolean isRecent, boolean isInclude) {
        try {
            StackParser parser = StackParser.getParser(config, filter, isInclude);
            parser.analyze(stackFileInfo);
            stackFileInfo = this.postSTackFile(stackFileInfo, config, filter, isRecent);
        }
        catch (RuntimeException ex) {
            StackParser.removeAllAnalyzedFile(stackFileInfo);
            throw ex;
        }
        return stackFileInfo;
    }

    private String selectCurrentParserConfig() {
        String fileName = ResourceUtils.selectFileDialog(this.m_parentComposite, "XML Parser Configuration", new String[]{"XML config", "All Files"}, new String[]{"*.xml", "*.*"});
        if (fileName != null) {
            PreferenceManager.get().setCurrentParserConfig(fileName);
            this.displayContent(null);
        }
        return fileName;
    }

    public Browser getBrowser() {
        if (this.m_stackAnalyzerView == null) {
            return null;
        }
        return this.m_stackAnalyzerView.getBrowser();
    }

    public Tree getMainTree() {
        if (this.m_stackAnalyzerView == null) {
            return null;
        }
        return this.m_stackAnalyzerView.getMainTree();
    }

    public Table getTable() {
        if (this.m_stackAnalyzerView == null) {
            return null;
        }
        return this.m_stackAnalyzerView.getTable();
    }

    public void displayContent(String textHtml) {
        Browser browser = this.getBrowser();
        if (textHtml != null) {
            browser.setText(textHtml);
        } else {
            browser.setText(HtmlUtils.getDefaultBody());
        }
    }

    private void addMainTree(StackFileInfo stackFileInfo) {
        Tree tree = this.getMainTree();
        TreeItem item = new TreeItem(tree, 0);
        item.setText(stackFileInfo.toTreeInfo());
        item.setImage(Images.thread);
        item.setData((Object)stackFileInfo);
        this.addMainTreeSubItem(item, stackFileInfo.getStackAnalyzedInfoList());
        item.setExpanded(true);
    }

    private void addMainTreeSubItem(TreeItem parent, ArrayList<StackAnalyzedInfo> list) {
        for (StackAnalyzedInfo info : list) {
            TreeItem subItem = new TreeItem(parent, 0);
            subItem.setText(info.toTreeInfo());
            subItem.setImage(Images.grid);
            subItem.setData((Object)info);
        }
    }

    public void setTable(StackAnalyzedInfo stackAnalyzedInfo) {
        this.clearTable();
        Table table = this.getTable();
        if (stackAnalyzedInfo == null) {
            return;
        }
        ArrayList<StackAnalyzedValue> list = null;
        list = this.m_isSortByFunction ? StackAnalyzedValueComp.sortClone(stackAnalyzedInfo.getAnalyzedList(), false) : stackAnalyzedInfo.getAnalyzedList();
        for (StackAnalyzedValue value : list) {
            TableItem item = new TableItem(table, 2048);
            item.setText(value.toTableInfo());
            if (!(value instanceof UniqueStackValue)) continue;
            item.setData(((UniqueStackValue)value).getStack());
        }
    }

    private void closeStackAllFileInfo() {
        Tree tree = this.getMainTree();
        if (tree != null) {
            tree.clearAll(true);
            tree.setItemCount(0);
        }
        this.clearTable();
        this.displayContent(null);
    }

    public void clearTable() {
        Table table = this.getTable();
        if (table != null) {
            table.clearAll();
            table.setItemCount(0);
        }
    }

    public TreeItem getSelectedItemFromMainTree() {
        Tree tree = this.getMainTree();
        if (tree == null) {
            return null;
        }
        TreeItem[] items = tree.getSelection();
        if (items == null || items.length == 0) {
            return null;
        }
        return items[0];
    }

    public Object getSelectedFromMainTree() {
        TreeItem item = this.getSelectedItemFromMainTree();
        if (item == null) {
            return null;
        }
        return item.getData();
    }

    public TreeItem getSelectedRootItemFromMainTree() {
        Tree tree = this.getMainTree();
        if (tree == null) {
            return null;
        }
        TreeItem[] items = tree.getSelection();
        if (items == null || items.length == 0) {
            return null;
        }
        if (items[0].getData() instanceof StackAnalyzedInfo) {
            return items[0].getParentItem();
        }
        return items[0];
    }

    public StackFileInfo getSelectedStackFileInfo() {
        Object object = this.getSelectedFromMainTree();
        StackFileInfo stackFileInfo = null;
        if (object instanceof StackAnalyzedInfo) {
            stackFileInfo = ((StackAnalyzedInfo)object).getStackFileInfo();
        } else if (object instanceof StackFileInfo) {
            stackFileInfo = (StackFileInfo)object;
        }
        return stackFileInfo;
    }

    private void createMainPerformance() {
        StackFileInfo stackFileInfo = this.getSelectedStackFileInfo();
        if (stackFileInfo != null) {
            new PerformanceWindow(this.m_parentComposite.getShell(), stackFileInfo, null, this.m_isExcludeStack, true, this.m_isRemoveLine, this.m_isInerPercent);
        }
    }

    private void viewRawIndexFile() {
        Object object = this.getSelectedFromMainTree();
        if (object == null) {
            return;
        }
        if (!(object instanceof StackAnalyzedInfo)) {
            return;
        }
        StackAnalyzedInfo analyzedInfo = (StackAnalyzedInfo)object;
        if (analyzedInfo.getExtension().equals("UNQ")) {
            return;
        }
        StackFileInfo stackFileInfo = analyzedInfo.getStackFileInfo();
        System.out.println("StackFile:" + stackFileInfo.toString());
        System.out.println("File:" + analyzedInfo.toString());
        String analyzedFilename = StackParser.getAnaylzedFilename(stackFileInfo.getFilename(), analyzedInfo.getExtension());
        File file = new File(analyzedFilename);
        if (!file.isFile()) {
            return;
        }
        BufferedReader reader = null;
        boolean isDetail = false;
        boolean isStart = false;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                int totalCount = 0;
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() > 0) {
                        isStart = true;
                    }
                    if (line.length() == 0) {
                        if (!isStart) continue;
                        isDetail = true;
                        continue;
                    }
                    if (!isDetail) continue;
                    ++totalCount;
                    HtmlUtils.caculCounter(line, map);
                }
                ArrayList<ValueObject> list = HtmlUtils.sortCounter(map);
                StringBuilder buffer = new StringBuilder(102400);
                buffer.append(HtmlUtils.getMainBodyStart());
                buffer.append(HtmlUtils.getCurrentConfigurationBody()).append("<br><br>");
                buffer.append("<b>[ ").append(stackFileInfo.getFilename()).append(" ]</b><BR>");
                buffer.append("<b>").append(analyzedInfo.toString()).append(" - ").append(analyzedFilename).append("</b><br><br>");
                buffer.append("<table border='1'><tr align='center'><th>Count</th><th>Percent</th><th>Class.method</th></tr>");
                for (ValueObject valueObject : list) {
                    int value = valueObject.getValue();
                    buffer.append("<tr><td align='right'>").append(value).append("</td><td align='right'>").append(100 * value / totalCount).append('%').append("</td>");
                    buffer.append("<td align='left'>").append(valueObject.getKey()).append("</td></tr>");
                }
                buffer.append("</table>");
                buffer.append(HtmlUtils.getMainBodyEnd());
                this.displayContent(buffer.toString());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void createManualJob(FilterInputDialog.TASK jobtype, boolean isAscending) {
        try {
            new FilterInputDialog(this.m_parentComposite.getShell(), isAscending, jobtype);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createAnalyzedPerformance(boolean isAscending) {
        this.createAnalyzedPerformance(this.getSelectedAnalyzedFunction(), isAscending);
    }

    public void createAnalyzedPerformance(String filter, boolean isAscending) {
        if (filter == null) {
            return;
        }
        StackFileInfo stackFileInfo = this.getSelectedStackFileInfo();
        if (stackFileInfo != null) {
            new PerformanceWindow(this.m_parentComposite.getShell(), stackFileInfo, filter, this.m_isExcludeStack, isAscending, this.m_isRemoveLine, this.m_isInerPercent);
        }
    }

    public void analyzeFilterStack(String inputFilter) {
        this.analyzeFilterStack(inputFilter, true);
    }

    private String getSelectedAnalyzedFunction() {
        Table table = this.getTable();
        if (table == null) {
            return null;
        }
        TableItem[] items = table.getSelection();
        if (items == null || items.length == 0) {
            return null;
        }
        return items[0].getText(3);
    }

    public void analyzeFilterStack(String inputFilter, boolean isInclude) {
        String filter = null;
        filter = inputFilter == null ? this.getSelectedAnalyzedFunction() : inputFilter;
        if (filter == null) {
            return;
        }
        StackFileInfo stackFileInfo = this.getSelectedStackFileInfo();
        if (stackFileInfo == null) {
            return;
        }
        ParserConfigReader reader = new ParserConfigReader(stackFileInfo.getParserConfig().getConfigFilename());
        ParserConfig config = reader.read();
        StackFileInfo filteredStackFileInfo = this.processStackFile(StackParser.getWorkingThreadFilename(stackFileInfo.getFilename()), config, filter, false, isInclude);
        this.addProcessedStack(filteredStackFileInfo);
    }

    private void viewThreadStack() {
        this.viewThreadStack(this.getSelectedAnalyzedFunction());
    }

    public void viewThreadStack(String filter) {
        if (filter == null) {
            return;
        }
        StackFileInfo stackFileInfo = this.getSelectedStackFileInfo();
        if (stackFileInfo == null) {
            return;
        }
        String filename = StackParser.getWorkingThreadFilename(stackFileInfo.getFilename());
        int stackStartLine = stackFileInfo.getParserConfig().getStackStartLine();
        if (filename != null && filter != null) {
            Browser broswer = this.getBrowser();
            if (this.m_isExcludeStack) {
                broswer.setText(HtmlUtils.filterThreadStack(filename, filter, stackFileInfo.getParserConfig().getExcludeStack(), stackStartLine));
            } else {
                broswer.setText(HtmlUtils.filterThreadStack(filename, filter, null, stackStartLine));
            }
        }
    }

    private void viewServiceCall() {
        this.viewServiceCall(this.getSelectedAnalyzedFunction());
    }

    public void viewServiceCall(String filter) {
        if (filter == null) {
            return;
        }
        StackFileInfo stackFileInfo = this.getSelectedStackFileInfo();
        if (stackFileInfo == null) {
            return;
        }
        String filename = StackParser.getWorkingThreadFilename(stackFileInfo.getFilename());
        int stackStartLine = stackFileInfo.getParserConfig().getStackStartLine();
        if (filename != null && filter != null) {
            this.getBrowser().setText(HtmlUtils.filterServiceCall(filename, filter, stackFileInfo.getParserConfig().getService(), stackStartLine));
        }
    }

    private void copyFunctionName() {
        String filter = this.getSelectedAnalyzedFunction();
        if (filter != null && filter.length() > 0) {
            StringUtils.setClipboard(filter);
        }
    }

    private void closeStackFileInfo() {
        TreeItem item = this.getSelectedItemFromMainTree();
        if (item == null) {
            return;
        }
        if (item.getData() instanceof StackAnalyzedInfo) {
            item = item.getParentItem();
        }
        item.removeAll();
        item.dispose();
        Table table = this.getTable();
        table.clearAll();
        table.setItemCount(0);
        this.displayContent(null);
    }

    private void reanalyzeStackFileInfo() {
        TreeItem item = this.getSelectedRootItemFromMainTree();
        if (item == null) {
            return;
        }
        StackFileInfo stackFileInfo = (StackFileInfo)item.getData();
        if (stackFileInfo == null) {
            return;
        }
        try {
            ParserConfigReader reader = new ParserConfigReader(stackFileInfo.getParserConfig().getConfigFilename());
            ParserConfig config = reader.read();
            StackParser.removeAllAnalyzedFile(stackFileInfo);
            this.processStackFile(stackFileInfo, config, null, false, true);
        }
        catch (RuntimeException ex) {
            this.closeStackFileInfo();
            throw ex;
        }
        item.removeAll();
        item.setText(stackFileInfo.toTreeInfo());
        this.addMainTreeSubItem(item, stackFileInfo.getStackAnalyzedInfoList());
        item.setExpanded(true);
        this.clearTable();
    }

    public void openStackAnalyzer() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        try {
            workbench.showPerspective(PerspectiveStackAnalyzer.ID, window);
            window.getActivePage().showView(StackAnalyzerView.ID);
        }
        catch (WorkbenchException e) {
            System.out.println("Unable to open Perspective: " + PerspectiveStackAnalyzer.ID);
        }
    }

    public void processStackFile(String fileName) {
        this.openStackAnalyzer();
        File file = new File(fileName);
        this.openFile(file, false);
    }

    public void processStackContents(String contents) {
        this.openStackAnalyzer();
        this.openContents(contents);
    }
}

