/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import scouter.client.Activator;
import scouter.client.Images;
import scouter.client.stack.data.StackFileInfo;
import scouter.client.stack.data.StackParser;
import scouter.client.stack.utils.NumberUtils;
import scouter.client.stack.utils.StringUtils;

public class PerformanceWindow
implements Listener {
    private Shell m_parentShell = null;
    private Shell m_shell = null;
    private Tree m_performanceTree = null;
    private StackFileInfo m_stackFileInfo = null;
    private String m_filter = null;
    private boolean m_isExcludeStack = true;
    private boolean m_isAscending = true;
    private boolean m_isRemoveLine = true;
    private boolean m_isInerPercent = false;
    private int m_totalCount = 0;
    private ArrayList<String> m_excludeStack = null;
    private ArrayList<String> m_singleStack = null;
    private int m_singleStackCount = 0;
    private int m_expandStartInx = 0;

    public PerformanceWindow(Shell shell, StackFileInfo stackFileInfo, String filter, boolean isExcludeStack, boolean isAscending, boolean isRemoveLine, boolean isInerPercent) {
        this.m_parentShell = shell;
        this.m_stackFileInfo = stackFileInfo;
        this.m_filter = filter;
        this.m_isExcludeStack = isExcludeStack;
        this.m_isAscending = isAscending;
        this.m_isRemoveLine = isRemoveLine;
        this.m_isInerPercent = isInerPercent;
        ArrayList<String> list = stackFileInfo.getParserConfig().getExcludeStack();
        if (this.m_isExcludeStack && list != null && list.size() > 0) {
            this.m_excludeStack = list;
        }
        if ((list = stackFileInfo.getParserConfig().getSingleStack()) != null && list.size() > 0) {
            this.m_singleStack = list;
            this.m_singleStackCount = list.size();
        }
        StringBuilder buffer = new StringBuilder(200);
        buffer.append('[');
        if (filter == null) {
            buffer.append("All");
        } else {
            buffer.append(filter);
        }
        buffer.append("] ").append(stackFileInfo.getFilename());
        buffer.append(" [EXC:").append(isExcludeStack).append("] [ASC:");
        buffer.append(isAscending).append(']');
        this.init(shell, buffer.toString());
    }

    private void init(Shell shell, String title) {
        this.m_shell = new Shell(shell, 1264);
        this.m_shell.setText(title);
        this.m_shell.setImage(Images.tree_mode);
        this.m_shell.setLayout((Layout)new FillLayout());
        this.m_performanceTree = new Tree((Composite)this.m_shell, 2816);
        this.m_performanceTree.setBackgroundImage(Activator.getImage("icons/grid.jpg"));
        this.constructTree();
        this.createTreePopupMenu();
        this.m_shell.open();
    }

    private void constructTree() {
        String filename = StackParser.getWorkingThreadFilename(this.m_stackFileInfo.getFilename());
        if (filename == null) {
            return;
        }
        HashMap<String, Counter> tree = new HashMap<String, Counter>();
        BufferedReader reader = null;
        int startStackLine = this.m_stackFileInfo.getUsedParser().getConfig().getStackStartLine();
        try {
            try {
                File file = new File(filename);
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                int lineCount = 0;
                boolean isFiltered = false;
                int filterIndex = 0;
                ArrayList<String> list = new ArrayList<String>(300);
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) {
                        if (isFiltered && list.size() > 0) {
                            this.createPerformanceTree(tree, list, filterIndex);
                        }
                        list = new ArrayList(300);
                        lineCount = 0;
                        isFiltered = false;
                        continue;
                    }
                    if (++lineCount <= startStackLine) continue;
                    if (!isFiltered) {
                        if (this.m_filter == null) {
                            isFiltered = true;
                        } else if (line.indexOf(this.m_filter) >= 0) {
                            isFiltered = true;
                            filterIndex = lineCount - (startStackLine + 1);
                        }
                    }
                    list.add(line);
                }
                if (isFiltered && list.size() > 0) {
                    this.createPerformanceTree(tree, list, filterIndex);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.m_isInerPercent && tree != null) {
            for (Counter cntr : tree.values()) {
                cntr.caculInerCount();
            }
        }
        TreeItem treeItem = new TreeItem(this.m_performanceTree, 0);
        treeItem.setText("Stack File Nodes");
        treeItem.setData(null);
        treeItem.setExpanded(true);
        this.makePerformanceTreeUI(treeItem, tree, 0);
    }

    private void makePerformanceTreeUI(TreeItem parent, HashMap<String, Counter> tree, int depth) {
        if (tree == null || tree.size() == 0) {
            return;
        }
        ++depth;
        String key = null;
        Counter counter = null;
        StringBuilder buffer = null;
        int index = 0;
        Iterator<String> itor = tree.keySet().iterator();
        ArrayList<Counter> sortList = new ArrayList<Counter>();
        while (itor.hasNext()) {
            key = itor.next();
            counter = tree.get(key);
            counter.setValue(key);
            sortList.add(counter);
        }
        Collections.sort(sortList, new ValueComp());
        int itemCount = sortList.size();
        if (itemCount > 1 && this.m_expandStartInx == 0) {
            this.m_expandStartInx = depth;
        }
        index = 0;
        while (index < itemCount) {
            counter = (Counter)sortList.get(index);
            buffer = new StringBuilder(100);
            buffer.append(counter.getCount()).append(" (").append(NumberUtils.intToPercent(counter.getCount() * 10000 / this.m_totalCount)).append("%) ");
            if (this.m_isInerPercent) {
                buffer.append(NumberUtils.intToPercent(counter.getInerCount() * 10000 / this.m_totalCount)).append("% ");
            }
            buffer.append(counter.getValue());
            TreeItem treeItem = new TreeItem(parent, 0);
            treeItem.setText(buffer.toString());
            treeItem.setData((Object)counter.getValue());
            treeItem.setExpanded(true);
            if (this.m_expandStartInx == 0) {
                this.m_performanceTree.showItem(treeItem);
            } else if (depth - this.m_expandStartInx <= 3) {
                this.m_performanceTree.showItem(treeItem);
            }
            if (counter.getMap() != null) {
                this.makePerformanceTreeUI(treeItem, counter.getMap(), depth);
            }
            ++index;
        }
    }

    private void createPerformanceTree(HashMap<String, Counter> tree, ArrayList<String> list, int filterIndex) {
        int startIndex = 0;
        int size = list.size() - 1;
        startIndex = this.m_filter != null ? filterIndex : list.size() - 1;
        ++this.m_totalCount;
        String line = null;
        HashMap<String, Counter> currentMap = tree;
        Counter currentCounter = null;
        int baseIndex = startIndex;
        while (true) {
            line = list.get(startIndex);
            if (this.m_singleStackCount > 0) {
                int index = 0;
                while (index < this.m_singleStackCount) {
                    if (line.indexOf(this.m_singleStack.get(index)) >= 0) {
                        line = this.m_singleStack.get(index);
                        break;
                    }
                    ++index;
                }
            }
            if (this.m_excludeStack != null && currentMap != null && currentMap != tree && StringUtils.checkExist(line, this.m_excludeStack)) {
                if (this.m_isAscending) {
                    if (startIndex == 0) break;
                    --startIndex;
                    continue;
                }
                if (startIndex == size) break;
                ++startIndex;
                continue;
            }
            line = this.m_filter != null && baseIndex == startIndex ? StringUtils.makeSimpleLine(line, false) : StringUtils.makeSimpleLine(line, this.m_isRemoveLine);
            if (currentCounter != null && (currentMap = currentCounter.getMap()) == null) {
                currentMap = currentCounter.addMap();
            }
            if ((currentCounter = currentMap.get(line)) == null) {
                currentCounter = new Counter();
                currentMap.put(line, currentCounter);
            }
            currentCounter.addCount();
            if (this.m_isAscending) {
                if (startIndex == 0) break;
                --startIndex;
                continue;
            }
            if (startIndex == size) break;
            ++startIndex;
        }
    }

    private void createTreePopupMenu() {
        Menu popupMenu = new Menu((Control)this.m_performanceTree);
        MenuItem menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("Performance tree(Ascending)");
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("Performance tree(Descending)");
        menuItem.addListener(13, (Listener)this);
        menuItem = new MenuItem(popupMenu, 2);
        menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("Copy function");
        menuItem.addListener(13, (Listener)this);
        this.m_performanceTree.setMenu(popupMenu);
    }

    public void handleEvent(Event event) {
        try {
            MenuItem item = (MenuItem)event.widget;
            String menuText = item.getText();
            if ("Performance tree(Ascending)".endsWith(menuText)) {
                this.createAnalyzedPerformance(true);
            } else if ("Performance tree(Descending)".endsWith(menuText)) {
                this.createAnalyzedPerformance(false);
            } else if ("Copy function".endsWith(menuText)) {
                this.CopyFunctionName();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createAnalyzedPerformance(boolean isAscending) {
        String filter = this.getSelectedFunctionName();
        if (filter != null && this.m_stackFileInfo != null) {
            new PerformanceWindow(this.m_parentShell, this.m_stackFileInfo, filter, this.m_isExcludeStack, isAscending, this.m_isRemoveLine, this.m_isInerPercent);
        }
    }

    private void CopyFunctionName() {
        String functionName = this.getSelectedFunctionName();
        if (functionName != null) {
            StringUtils.setClipboard(functionName.trim());
        }
    }

    private String getSelectedFunctionName() {
        TreeItem[] items = this.m_performanceTree.getSelection();
        if (items == null || items.length == 0) {
            return null;
        }
        String function = (String)items[0].getData();
        int endIndex = function.indexOf(40);
        if (endIndex >= 0) {
            function = function.substring(0, endIndex);
        }
        return function;
    }

    private class Counter {
        private int m_count = 0;
        private int m_inerCount = 0;
        private String m_value = null;
        private HashMap<String, Counter> m_map = null;

        private Counter() {
        }

        public void addCount() {
            ++this.m_count;
        }

        public int getCount() {
            return this.m_count;
        }

        public int getInerCount() {
            return this.m_inerCount;
        }

        public void setValue(String value) {
            this.m_value = value;
        }

        public String getValue() {
            return this.m_value;
        }

        public HashMap<String, Counter> addMap() {
            if (this.m_map == null) {
                this.m_map = new HashMap();
            }
            return this.m_map;
        }

        public HashMap<String, Counter> getMap() {
            return this.m_map;
        }

        public void caculInerCount() {
            if (this.m_map == null) {
                this.m_inerCount = this.m_count;
                return;
            }
            int subCount = 0;
            for (Counter cntr : this.m_map.values()) {
                subCount += cntr.getCount();
                cntr.caculInerCount();
            }
            this.m_inerCount = this.m_count - subCount;
        }
    }

    private class ValueComp
    implements Comparator<Counter> {
        private ValueComp() {
        }

        @Override
        public int compare(Counter o1, Counter o2) {
            if (o1.getCount() > o2.getCount()) {
                return -1;
            }
            if (o1.getCount() < o2.getCount()) {
                return 1;
            }
            return 0;
        }
    }
}

