/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.base;

import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PreferenceManager {
    private static final PreferenceManager preferenceManager = new PreferenceManager();
    public static final String DELIMETER = "\u00a7\u00a7\u00a7\u00a7";
    private final Preferences preferences = Preferences.userNodeForPackage(this.getClass());

    private PreferenceManager() {
    }

    public static PreferenceManager get() {
        return preferenceManager;
    }

    public String getSelectedPath() {
        return this.preferences.get("selectedPath", "");
    }

    public void setSelectedPath(File directory) {
        this.preferences.put("selectedPath", directory.getAbsolutePath());
    }

    public void setMaxLogfileSize(int size) {
        this.preferences.putInt("maxlogfilesize", size);
    }

    public int getTopDividerPos() {
        return this.preferences.getInt("top.dividerPos", 0);
    }

    public void setTopDividerPos(int pos) {
        this.preferences.putInt("top.dividerPos", pos);
    }

    public int getDividerPos() {
        return this.preferences.getInt("dividerPos", 0);
    }

    public void setDividerPos(int pos) {
        this.preferences.putInt("dividerPos", pos);
    }

    public void addToStackFiles(String file) {
        String[] currentFiles = this.getStackFiles();
        if (!this.hasInFiles(file, currentFiles)) {
            int start = currentFiles.length == 10 ? 1 : 0;
            StringBuilder recentFiles = new StringBuilder();
            int i = start;
            while (i < currentFiles.length) {
                recentFiles.append(currentFiles[i]);
                recentFiles.append(DELIMETER);
                ++i;
            }
            recentFiles.append(file);
            this.preferences.put("stackFiles", recentFiles.toString());
        }
    }

    public String[] getStackFiles() {
        return this.preferences.get("stackFiles", "").split(DELIMETER);
    }

    public void addToAnalyzedStackFiles(String file) {
        String[] currentFiles = this.getAnalyzedStackFiles();
        if (!this.hasInFiles(file, currentFiles)) {
            int start = currentFiles.length == 10 ? 1 : 0;
            StringBuilder recentFiles = new StringBuilder();
            int i = start;
            while (i < currentFiles.length) {
                recentFiles.append(currentFiles[i]);
                recentFiles.append(DELIMETER);
                ++i;
            }
            recentFiles.append(file);
            this.preferences.put("analyzedStackFiles", recentFiles.toString());
        }
    }

    public String[] getAnalyzedStackFiles() {
        return this.preferences.get("analyzedStackFiles", "").split(DELIMETER);
    }

    public void setCurrentParserConfig(String filename) {
        this.preferences.put("currentParserConfig", filename);
    }

    public String getCurrentParserConfig() {
        return this.preferences.get("currentParserConfig", null);
    }

    public void setPreference(String name, String value) {
        this.preferences.put(name, value);
    }

    public String getPreference(String name, String defaultValue) {
        return this.preferences.get(name, defaultValue);
    }

    public void flush() {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    private boolean hasInFiles(String file, String[] currentFiles) {
        int i = 0;
        while (i < currentFiles.length) {
            if (file.equals(currentFiles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

