/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.config;

import java.util.ArrayList;

public class AnalyzerValue {
    public static final int FILTER_ALL = 1;
    public static final int FILTER_EACH = 2;
    public static final int READER_FIRST = 1;
    public static final int READER_LAST = 2;
    public static final int READER_NEXT = 3;
    private String m_name = null;
    private String m_extension = null;
    private int m_filter = 0;
    private int m_reader = 0;
    ArrayList<String> m_list = null;
    ArrayList<String> m_listMain = null;

    public String getName() {
        return this.m_name;
    }

    public String getExtension() {
        return this.m_extension;
    }

    public int getFilter() {
        return this.m_filter;
    }

    public int getReader() {
        return this.m_reader;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setExtension(String extension) {
        this.m_extension = extension;
    }

    public void setFilter(int filter) {
        this.m_filter = filter;
    }

    public void setReader(int reader) {
        this.m_reader = reader;
    }

    public void setList(ArrayList<String> list) {
        this.m_list = list;
    }

    public void setListMain(ArrayList<String> list) {
        this.m_listMain = list;
    }

    public ArrayList<String> getList() {
        return this.m_list;
    }

    public ArrayList<String> getListMain() {
        return this.m_listMain;
    }

    public void setFilter(String filter) {
        if (filter == null || filter.length() == 0) {
            throw new RuntimeException("analyzeStack filter attribute is null");
        }
        if ("ALL".equals(filter.toUpperCase())) {
            this.m_filter = 1;
        } else if ("EACH".equals(filter.toUpperCase())) {
            this.m_filter = 2;
        } else {
            throw new RuntimeException("analyzeStack filter attribute must in (all,each) - " + filter);
        }
    }

    public void setReader(String reader) {
        if (reader == null || reader.length() == 0) {
            throw new RuntimeException("analyzeStack reader attribute is null");
        }
        if ("FIRST".equals(reader.toUpperCase())) {
            this.m_reader = 1;
        } else if ("LAST".equals(reader.toUpperCase())) {
            this.m_reader = 2;
        } else if ("NEXT".equals(reader.toUpperCase())) {
            this.m_reader = 3;
        } else {
            throw new RuntimeException("analyzeStack reader attribute must in (first,last,next) - " + reader);
        }
    }

    public boolean isValid() {
        if (this.m_name == null || this.m_name.length() == 0) {
            return false;
        }
        if (this.m_extension == null || this.m_extension.length() == 0) {
            return false;
        }
        String search = "[" + this.m_extension + "]";
        if ("[LOG] [SVC] [TOP] [SQL] [WS]".indexOf(search) >= 0) {
            return false;
        }
        if (this.m_filter <= 0 || this.m_filter > 2) {
            return false;
        }
        if (this.m_reader <= 0 || this.m_filter > 3) {
            return false;
        }
        if (this.m_list == null || this.m_list.size() == 0) {
            return false;
        }
        return this.m_filter != 1 || this.m_listMain != null && this.m_listMain.size() != 0;
    }
}

