/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.config;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import scouter.client.stack.config.AnalyzerValue;
import scouter.client.stack.config.JmxConfig;
import scouter.client.stack.config.preprocessor.Processor;

public class ParserConfig {
    private String m_configFilename = null;
    private String m_parserName = null;
    private int m_stackStartLine = 2;
    private String m_divideStack = null;
    private String m_timeFormat = null;
    private SimpleDateFormat m_simpleDateFormat = null;
    private int m_timeSize = 0;
    private String m_timeFilter = null;
    private int m_timePosition = 0;
    private String m_threadStatus = null;
    private boolean m_serviceExclude = false;
    private ArrayList<String> m_workerThread = new ArrayList();
    private ArrayList<String> m_workingThread = new ArrayList();
    private ArrayList<String> m_sql = new ArrayList();
    private ArrayList<String> m_service = new ArrayList();
    private ArrayList<String> m_log = new ArrayList();
    private ArrayList<String> m_excludeStack = new ArrayList();
    private ArrayList<String> m_singleStack = new ArrayList();
    private JmxConfig m_jmxConfig = null;
    private ArrayList<AnalyzerValue> m_analyzer = null;
    private ArrayList<Processor> m_stackPreprocessorList = null;
    private Processor.TARGET m_stackPreprocessorTarget = null;

    public ArrayList<String> getWorkingThread() {
        return this.m_workingThread;
    }

    public void setStackStartLine(int line) {
        this.m_stackStartLine = line;
    }

    public int getStackStartLine() {
        return this.m_stackStartLine;
    }

    public void setDivideStack(String divideStack) {
        this.m_divideStack = divideStack;
    }

    public String getDivideStack() {
        return this.m_divideStack;
    }

    public ArrayList<String> getSql() {
        return this.m_sql;
    }

    public ArrayList<String> getService() {
        return this.m_service;
    }

    public boolean isServiceExclude() {
        return this.m_serviceExclude;
    }

    public ArrayList<String> getLog() {
        return this.m_log;
    }

    public ArrayList<String> getExcludeStack() {
        return this.m_excludeStack;
    }

    public ArrayList<String> getSingleStack() {
        return this.m_singleStack;
    }

    public ArrayList<String> getWorkerThread() {
        return this.m_workerThread;
    }

    public String getThreadStatus() {
        return this.m_threadStatus;
    }

    public void setThreadStatus(String status) {
        this.m_threadStatus = status;
    }

    public void setWorkerThread(ArrayList<String> workerThread) {
        this.m_workerThread = workerThread;
    }

    public void setWorkingThread(ArrayList<String> workingThread) {
        this.m_workingThread = workingThread;
    }

    public void setSql(ArrayList<String> sql) {
        this.m_sql = sql;
    }

    public void setService(ArrayList<String> service) {
        this.m_service = service;
    }

    public void setServiceExclude(boolean value) {
        this.m_serviceExclude = value;
    }

    public void setLog(ArrayList<String> log) {
        this.m_log = log;
    }

    public void setExcludeStack(ArrayList<String> excludeStack) {
        this.m_excludeStack = excludeStack;
    }

    public void setSingleStack(ArrayList<String> singleStack) {
        this.m_singleStack = singleStack;
    }

    public void setConfigFilename(String filename) {
        this.m_configFilename = filename;
    }

    public String getConfigFilename() {
        return this.m_configFilename;
    }

    public String getParserName() {
        return this.m_parserName;
    }

    public void setParserName(String parserName) {
        this.m_parserName = parserName;
    }

    public String getTimeFormat() {
        return this.m_timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.m_timeFormat = timeFormat;
        if (this.m_timeFormat != null) {
            this.m_simpleDateFormat = new SimpleDateFormat(this.m_timeFormat);
        }
    }

    public void setStackPreprocessorList(ArrayList<Processor> list) {
        this.m_stackPreprocessorList = list;
    }

    public ArrayList<Processor> getStackPreprocessorList() {
        return this.m_stackPreprocessorList;
    }

    public void setStackPreprocessorTarget(String target) {
        if (target == null || target.length() == 0) {
            throw new RuntimeException("preProcessor target attribute of preprocessor is not exist!");
        }
        if (target.equals("header")) {
            this.m_stackPreprocessorTarget = Processor.TARGET.HEADER;
        } else if (target.equals("stack")) {
            this.m_stackPreprocessorTarget = Processor.TARGET.STACK;
        } else if (target.equals("all")) {
            this.m_stackPreprocessorTarget = Processor.TARGET.ALL;
        } else {
            throw new RuntimeException("preProcessor target (header/stack/all) of preprocessor is wrong(" + target + ")!");
        }
    }

    public Processor.TARGET getStackPreprocessorTarget() {
        return this.m_stackPreprocessorTarget;
    }

    public void setTimeSize(int size) {
        this.m_timeSize = size;
    }

    public int getTimeSize() {
        return this.m_timeSize;
    }

    public void setTimePosition(int position) {
        this.m_timePosition = position;
    }

    public int getTimePosition() {
        return this.m_timePosition;
    }

    public void setTimeFilter(String filter) {
        this.m_timeFilter = filter;
    }

    public String getTimeFilter() {
        return this.m_timeFilter;
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return this.m_simpleDateFormat;
    }

    public void setSimpleDateFormat(SimpleDateFormat format) {
        this.m_simpleDateFormat = format;
    }

    public ArrayList<AnalyzerValue> getAnalyzerList() {
        return this.m_analyzer;
    }

    public boolean addAnalyzer(AnalyzerValue value) {
        if (!value.isValid()) {
            return false;
        }
        if (this.m_analyzer == null) {
            this.m_analyzer = new ArrayList();
        }
        this.m_analyzer.add(value);
        return true;
    }

    public JmxConfig getJMXConfig() {
        return this.m_jmxConfig;
    }

    public void setJMXConfig(int count, int interval, String filePath) {
        this.m_jmxConfig = new JmxConfig(count, interval, filePath);
    }
}

