/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.config;

import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scouter.client.stack.config.AnalyzerValue;
import scouter.client.stack.config.JmxConfig;
import scouter.client.stack.config.ParserConfig;
import scouter.client.stack.config.XMLReader;
import scouter.client.stack.config.preprocessor.PreProcessor;

public class ParserConfigReader
extends XMLReader {
    public ParserConfigReader(String fileName) {
        super(fileName);
    }

    public ParserConfig read() {
        ParserConfig config = new ParserConfig();
        config.setConfigFilename(this.getFilename());
        try {
            config.setParserName(this.getSingleValue("scouter/parser"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            config.setStackStartLine(Integer.parseInt(this.getAttribute("scouter/parser", "stackStartLine")));
        }
        catch (Exception ex) {
            System.err.println("stackStartLine attribute in scouter/parser is not exist! (Default: 2)");
        }
        try {
            config.setDivideStack(this.getAttribute("scouter/parser", "divideStack"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            config.setTimeFormat(this.getSingleValue("scouter/time"));
            config.setTimeSize(Integer.parseInt(this.getAttribute("scouter/time", "size")));
            config.setTimePosition(Integer.parseInt(this.getAttribute("scouter/time", "position")));
            config.setTimeFilter(this.getAttribute("scouter/time", "filter"));
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        try {
            config.setThreadStatus(this.getAttribute("scouter/workingThread", "status"));
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        this.readDefaultAnalyzer(config);
        this.readAddedAnalyzer(config);
        this.readJMX(config);
        String filename = null;
        try {
            filename = this.getSingleValue("scouter/preProcessor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (filename != null && filename.length() > 0) {
            PreProcessor.readPreprocessor(config, filename);
        }
        return config;
    }

    private void readDefaultAnalyzer(ParserConfig config) {
        ArrayList<String> list = null;
        try {
            list = this.readList("scouter/workerThread");
            config.setWorkerThread(list);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        list = this.readList("scouter/workingThread");
        config.setWorkingThread(list);
        try {
            String value = this.getAttribute("scouter/service", "type");
            if ("exclude".equalsIgnoreCase(value)) {
                config.setServiceExclude(true);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            list = this.readList("scouter/service");
            config.setService(list);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        try {
            list = this.readList("scouter/sql");
            config.setSql(list);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        try {
            list = this.readList("scouter/log");
            config.setLog(list);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        try {
            list = this.readList("scouter/excludeStack");
            config.setExcludeStack(list);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        try {
            list = this.readList("scouter/singleStack");
            config.setSingleStack(list);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    private void readAddedAnalyzer(ParserConfig config) {
        ArrayList<Node> nodeList = null;
        try {
            nodeList = this.getNodeList("scouter/analyze");
            if (nodeList == null || nodeList.size() == 0) {
                return;
            }
            int i = 0;
            while (i < nodeList.size()) {
                this.readAnalyzer(nodeList.get(i), config);
                ++i;
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    private void readAnalyzer(Node node, ParserConfig config) throws Exception {
        ArrayList<Node> nodeList = this.getNodeList(node, "analyzeStack");
        if (nodeList == null || nodeList.size() == 0) {
            return;
        }
        int i = 0;
        while (i < nodeList.size()) {
            this.readAnalyzerEach(nodeList.get(i), config);
            ++i;
        }
    }

    private void readAnalyzerEach(Node node, ParserConfig config) throws Exception {
        AnalyzerValue value = new AnalyzerValue();
        value.setName(this.getAttribute(node, "name"));
        value.setExtension(this.getAttribute(node, "extension"));
        value.setFilter(this.getAttribute(node, "filter"));
        value.setReader(this.getAttribute(node, "reader"));
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Node> nodeList = this.getNodeList(node, "list");
        String filterValue = null;
        int i = 0;
        while (i < nodeList.size()) {
            filterValue = this.getValue(nodeList.get(i));
            if (filterValue != null && filterValue.length() > 0) {
                list.add(filterValue);
            }
            ++i;
        }
        if (value.getFilter() == 1) {
            ArrayList<String> listMain = new ArrayList<String>();
            nodeList = this.getNodeList(node, "listMain");
            int i2 = 0;
            while (i2 < nodeList.size()) {
                filterValue = this.getValue(nodeList.get(i2));
                if (filterValue != null && filterValue.length() > 0) {
                    listMain.add(filterValue);
                }
                ++i2;
            }
            if (listMain.size() > 0) {
                value.setListMain(listMain);
            }
        }
        value.setList(list);
        if (!value.isValid()) {
            throw new RuntimeException("analyzeStack configuration is wrong!");
        }
        config.addAnalyzer(value);
    }

    private String getSingleValue(String nodeName) {
        String returnValue = null;
        try {
            returnValue = this.getValue(nodeName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return returnValue;
    }

    private ArrayList<String> readList(String nodeName) {
        ArrayList<Node> nodeList = null;
        try {
            nodeList = this.getNodeList(nodeName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (nodeList == null || nodeList.size() == 0) {
            return null;
        }
        ArrayList<String> returnList = new ArrayList<String>();
        Node node = null;
        int i = 0;
        while (i < nodeList.size()) {
            try {
                node = nodeList.get(i);
                NodeList listList = nodeList.get(i).getChildNodes();
                if (!(listList == null | listList.getLength() == 0)) {
                    int ii = 0;
                    while (ii < listList.getLength()) {
                        node = listList.item(ii);
                        if (node.getNodeName().equals("list")) {
                            returnList.add(node.getFirstChild().getNodeValue());
                        }
                        ++ii;
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ++i;
        }
        return returnList;
    }

    private void readJMX(ParserConfig config) {
        ArrayList<Node> nodeList = null;
        try {
            nodeList = this.getNodeList("scouter/jmx");
            if (nodeList == null || nodeList.size() == 0) {
                return;
            }
            int count = 100;
            int interval = 10000;
            String path = ".";
            Node jmxNode = nodeList.get(0);
            ArrayList<Node> list = this.getNodeList(jmxNode, "count");
            if (list != null && list.size() > 0) {
                count = Integer.parseInt(this.getValue(list.get(0)));
            }
            if ((list = this.getNodeList(jmxNode, "interval")) != null && list.size() > 0) {
                interval = Integer.parseInt(this.getValue(list.get(0)));
            }
            if ((list = this.getNodeList(jmxNode, "path")) != null && list.size() > 0) {
                path = this.getValue(list.get(0));
            }
            System.out.println("JMX: count " + count + ", interval " + interval + ", path " + path);
            config.setJMXConfig(count, interval, path);
            this.readJMXserver(jmxNode, config);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    private void readJMXserver(Node node, ParserConfig config) throws Exception {
        ArrayList<Node> nodeList = this.getNodeList(node, "server");
        if (nodeList == null || nodeList.size() == 0) {
            return;
        }
        JmxConfig jconfig = config.getJMXConfig();
        if (jconfig == null) {
            throw new Exception("JMX configuration(count,interval,path) is not exists!");
        }
        int i = 0;
        while (i < nodeList.size()) {
            Node data = this.getNodeList(nodeList.get(i), "ip").get(0);
            String ip = this.getValue(data);
            data = this.getNodeList(nodeList.get(i), "port").get(0);
            int port = Integer.parseInt(this.getValue(data));
            if (ip == null || port == 0) {
                throw new Exception("JMX configuration(ip or port) is not exist!");
            }
            System.out.println("JMX Server:" + ip + " " + port);
            jconfig.addServer(ip, port);
            ++i;
        }
    }
}

