/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scouter.client.stack.utils.ResourceUtils;

public class XMLReader {
    public static final String DEFAULT_XMLCONFIG = "Default";
    private Document m_xmlDoc = null;
    private String m_filename = null;

    public XMLReader(String filename) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setIgnoringComments(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.m_xmlDoc = DEFAULT_XMLCONFIG.equals(filename) ? db.parse(ResourceUtils.getDefaultXMLConfig()) : db.parse(new File(filename));
            this.m_filename = filename;
        }
        catch (Exception ex) {
            this.m_xmlDoc = null;
            throw new RuntimeException(ex);
        }
    }

    public ArrayList<Node> getNodeList(String parameter) throws Exception {
        ArrayList<Node> list = this.getNodeListByTagName(this.m_xmlDoc, parameter);
        if (list == null || list.size() < 1) {
            throw new IOException(String.valueOf(parameter) + " node lists in XML file are not exist!");
        }
        return list;
    }

    public String getValue(Node node) throws Exception {
        if (this.m_xmlDoc == null || node == null) {
            return null;
        }
        return node.getFirstChild().getNodeValue();
    }

    public String getValue(String parameter) throws Exception {
        if (this.m_xmlDoc == null) {
            return null;
        }
        ArrayList<Node> list = this.getNodeList(parameter);
        Node node = list.get(0);
        return node.getFirstChild().getNodeValue();
    }

    public String getAttribute(Node node, String attribute) throws Exception {
        if (this.m_xmlDoc == null || node == null) {
            return null;
        }
        String attribute_value = null;
        try {
            attribute_value = node.getAttributes().getNamedItem(attribute).getNodeValue();
        }
        catch (Exception ex) {
            throw new IOException(String.valueOf(attribute) + " attribute of node" + node.toString() + " is not exists!");
        }
        return attribute_value;
    }

    public String getAttribute(String parameter, String attribute) throws Exception {
        if (this.m_xmlDoc == null) {
            return null;
        }
        ArrayList<Node> list = this.getNodeList(parameter);
        Node node = list.get(0);
        String attribute_value = null;
        try {
            attribute_value = node.getAttributes().getNamedItem(attribute).getNodeValue();
        }
        catch (Exception ex) {
            throw new IOException(String.valueOf(attribute) + " attribute of " + parameter + " is not exists!");
        }
        return attribute_value;
    }

    public ArrayList<String> getList(String name) throws Exception {
        if (this.m_xmlDoc == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Node> injarList = this.getNodeListByTagName(this.m_xmlDoc, name);
        if (injarList == null || injarList.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < injarList.size()) {
            try {
                list.add(injarList.get(i).getFirstChild().getNodeValue());
            }
            catch (Exception ex) {
                throw new IOException(String.valueOf(name) + " lists in EXL file are not exist!");
            }
            ++i;
        }
        return list;
    }

    public ArrayList<Node> getNodeListByTagName(Document xmlDoc, String nodeName) {
        if (xmlDoc == null || nodeName == null || nodeName.length() == 0) {
            return null;
        }
        String newNodeName = nodeName.replace('/', ' ');
        StringTokenizer token = new StringTokenizer(newNodeName);
        NodeList nodeList = xmlDoc.getElementsByTagName(token.nextToken());
        if (nodeList.getLength() == 0) {
            return null;
        }
        ArrayList<Node> list = new ArrayList<Node>();
        if (token.hasMoreTokens()) {
            String tagname = token.nextToken();
            int list_cnt = 0;
            int i = 0;
            while (i < nodeList.getLength()) {
                ArrayList<Node> temp = this.getNodeList(nodeList.item(i), tagname);
                if (temp != null) {
                    int ii = 0;
                    while (ii < temp.size()) {
                        list.add(list_cnt++, temp.get(ii));
                        ++ii;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < nodeList.getLength()) {
                list.add(i, nodeList.item(i));
                ++i;
            }
        }
        return list;
    }

    public ArrayList<Node> getNodeList(Node node, String tagname) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        int list_cnt = 0;
        ArrayList<Node> list = new ArrayList<Node>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node item = nodeList.item(i);
            if (item.getNodeName().equals(tagname)) {
                list.add(list_cnt++, item);
            }
            ++i;
        }
        if (list_cnt == 0) {
            return null;
        }
        return list;
    }

    public String getFilename() {
        return this.m_filename;
    }
}

