/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.config.preprocessor;

import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Node;
import scouter.client.stack.config.XMLReader;
import scouter.client.stack.config.preprocessor.Processor;
import scouter.client.stack.config.preprocessor.ProcessorAdd;
import scouter.client.stack.config.preprocessor.ProcessorRemoveCount;
import scouter.client.stack.config.preprocessor.ProcessorRemoveFrom;
import scouter.client.stack.config.preprocessor.ProcessorRemoveLine;
import scouter.client.stack.config.preprocessor.ProcessorRemoveStart;
import scouter.client.stack.config.preprocessor.ProcessorRemoveValue;
import scouter.client.stack.config.preprocessor.ProcessorReplace;
import scouter.client.stack.config.preprocessor.ProcessorReplaceStart;

public class ParserPreProcessorReader
extends XMLReader {
    public ParserPreProcessorReader(String fileName) {
        super(fileName);
    }

    public String readTarget() throws Exception {
        return this.getAttribute("preProcessor", "target");
    }

    public ArrayList<Processor> readProcessors() {
        ArrayList<Processor> processorList = new ArrayList<Processor>();
        ArrayList<Node> nodeList = null;
        try {
            nodeList = this.getNodeList("preProcessor/processor");
            if (nodeList == null || nodeList.size() == 0) {
                return processorList;
            }
            int i = 0;
            while (i < nodeList.size()) {
                processorList.add(this.readProcessor(nodeList.get(i)));
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return processorList;
    }

    private Processor readProcessor(Node node) {
        Processor.TYPE type;
        Processor processor = null;
        try {
            type = this.getType(this.getAttribute(node, "type"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (type == Processor.TYPE.ADD) {
            processor = new ProcessorAdd();
        } else if (type == Processor.TYPE.REPLACE) {
            try {
                processor = new ProcessorReplaceStart(this.getAttribute(node, "start"));
            }
            catch (Exception ex) {
                processor = new ProcessorReplace();
            }
        } else if (type == Processor.TYPE.REMOVE) {
            try {
                processor = new ProcessorRemoveStart(this.getAttribute(node, "start"));
            }
            catch (Exception ex) {
                try {
                    processor = new ProcessorRemoveCount(this.getAttribute(node, "count"));
                }
                catch (Exception e1) {
                    try {
                        processor = new ProcessorRemoveValue(this.getAttribute(node, "value"));
                    }
                    catch (Exception e2) {
                        try {
                            processor = new ProcessorRemoveFrom(this.getAttribute(node, "from"));
                        }
                        catch (Exception e3) {
                            throw new RuntimeException("processor type(remove) is abnormal!");
                        }
                    }
                }
            }
        } else if (type == Processor.TYPE.REMOVELINE) {
            processor = new ProcessorRemoveLine();
        }
        try {
            processor.setFilter(this.getAttribute(node, "filter"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Processor)processor).readConfig(this, node);
        return processor;
    }

    private Processor.TYPE getType(String type) throws IOException {
        if (type == null || type.length() == 0) {
            throw new IOException("processor type attribute of preprocessor is not exist!");
        }
        if (type.equals("add")) {
            return Processor.TYPE.ADD;
        }
        if (type.equals("replace")) {
            return Processor.TYPE.REPLACE;
        }
        if (type.equals("remove")) {
            return Processor.TYPE.REMOVE;
        }
        if (type.equals("removeline")) {
            return Processor.TYPE.REMOVELINE;
        }
        throw new IOException("processor type (add/replace/remove) of preprocessor is wrong(" + type + ")!");
    }
}

